/***************************************************************************/
// Unsigned 24-bit integer
/***************************************************************************/

/***************************************************************************/
// assign it
/***************************************************************************/
inline u24::u24(u32 i)
{
	// copy it in
	data[0] = (unsigned char)( ( i >>  0) & 0xff);
	data[1] = (unsigned char)( ( i >>  8) & 0xff);
	data[2] = (unsigned char)( ( i >> 16) & 0xff);
}

/***************************************************************************/
/***************************************************************************/
inline u24 &u24::operator=(
const u24 &i)
{
	data[0] = i.data[0];
	data[1] = i.data[1];
	data[2] = i.data[2];

	return(*this);
}

/***************************************************************************/
// cast it
/***************************************************************************/
inline u24::operator u32(void) const
{
	unsigned int i = 0;

	i |= ( data[0] << 0);
	i |= ( data[1] << 8);
	i |= ( data[2] << 16);

	return(i);
}

/***************************************************************************/
// compare it
/***************************************************************************/
inline int u24::operator==(
const u32 i) const
{
	return((u32)*this == i);
}

/***************************************************************************/
/***************************************************************************/
inline int u24::operator!=(
const u32 i) const
{
	return((u32)*this != i);
}

/***************************************************************************/
// compare it
/***************************************************************************/
inline int u24::operator==(
const u24 &i) const
{
	return(data[0] == i.data[0] && data[1] == i.data[1] && data[2] == i.data[2]);
}

/***************************************************************************/
/***************************************************************************/
inline int u24::operator!=(
const u24 &i) const
{
	return(data[0] != i.data[0] || data[1] != i.data[1] || data[2] != i.data[2]);
}

/***************************************************************************/
/***************************************************************************/
inline int u24::operator>=(
const u32 i) const
{
	return((u32)*this >= i);
}

/***************************************************************************/
/***************************************************************************/
inline int u24::operator>(
const u32 i) const
{
	return((u32)*this > i);
}

/***************************************************************************/
/***************************************************************************/
inline int u24::operator<=(
const u32 i) const
{
	return((u32)*this <= i);
}

/***************************************************************************/
/***************************************************************************/
inline int u24::operator<(
const u32 i) const
{
	return((u32)*this < i);
}

