///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include "hud/HudPCH.h"

#include "hud/ipanel/instrument.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
Instrument::Instrument(
const char *name)
{
	ASSERT(name);
	ASSERT(strlen(name) > 0 && strlen(name) < sizeof(m_name) - 1);
	strcpy(m_name, name);

	m_hidden = false;
	m_active = true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool Instrument::Show(
bool show)
{
	if (m_hidden && show)
	{
		// Show it
		m_hidden = false;
	}
	else if (!m_hidden && !show)
	{
		// Hide!
		m_hidden = true;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool Instrument::Activate(
bool activate)
{
	if (m_active && !activate)
	{
		// We die!
		m_active = false;
	}
	else if (!m_active && activate)
	{
		// We are now active!
		m_active = true;
	}

	return true;
}


