///////////////////////////////////////////////////////////////////////////////
// Simple sprite based instrument
///////////////////////////////////////////////////////////////////////////////
#include "hud/HudPCH.h"

#include "hud/text.h"
#include "hud/ipanel/isprite.h"

#define BASE_PRIORITY 50

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
SpriteInstrument::SpriteInstrument(
const char *name) :
Instrument(name)
{
	m_sprite.SetPriority(BASE_PRIORITY);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
SpriteInstrument::~SpriteInstrument()
{
}

///////////////////////////////////////////////////////////////////////////////
// Create the sprite
///////////////////////////////////////////////////////////////////////////////
bool SpriteInstrument::SetupSprite(
t_Handle textureSet,
int index,
int cell,
int cols,
int rows)
{
	m_sprite.SetTextureSet(textureSet, index, cell, cols, rows);
	m_sprite.Reset();
	m_sprite.SetPriority(BASE_PRIORITY);

	return true;
}

///////////////////////////////////////////////////////////////////////////////
// Show/hide the instrument
///////////////////////////////////////////////////////////////////////////////
bool SpriteInstrument::Show(
bool show)
{
	if (show == m_hidden)
	{
		if (!show)
			m_sprite.Hide();
		else
		{
			if (m_active)
				m_sprite.Show();
		}
		m_hidden = !show;
	}

	return show;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool SpriteInstrument::Activate(
bool activate)
{
	if (activate != m_active)
	{
		if (!activate)
			m_sprite.Hide();
		else
		{
			if (!m_hidden)
				m_sprite.Show();
		}

		m_active = activate;
	}

	return activate;
}

///////////////////////////////////////////////////////////////////////////////
// Return the XY extent of this instrument (you write this!)
///////////////////////////////////////////////////////////////////////////////
Vector2 SpriteInstrument::Extents()
{
	Vector2 extents;
	extents.X(m_sprite.GetWidth());
	extents.Y(m_sprite.GetHeight());
	return extents;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void SpriteInstrument::Place(
float x,
float y)
{
	m_sprite.SetPosition(x, y);
}

