///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include "hud/HudPCH.h"

#include "enginehelper/timer.h"
#include "hud/ipanel/isys.h"

// There can be only one!
DeclareSingleton(InstrumentSystem);

// The basics
Vector2			InstrumentSystem::s_screenSize(640.0f, 480.0f);
float				InstrumentSystem::s_overdrawX = 0.075f;
float				InstrumentSystem::s_overdrawY = 0.075f;
float				InstrumentSystem::s_wideScreenOffset = 0.0f;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
InstrumentSystem::InstrumentSystem() :
m_panels(true)
{
}

///////////////////////////////////////////////////////////////////////////////
// Create a panel
///////////////////////////////////////////////////////////////////////////////
InstrumentPanel *InstrumentSystem::Create(
const char *panelName)
{
	InstrumentPanel *panel = new InstrumentPanel(panelName);
	ASSERT(panel);
	if (panel)
		m_panels.AddTail(panel);

	return panel;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
InstrumentPanel *InstrumentSystem::Find(
const char *panelName,
bool create)
{
	InstrumentPanel *panel = m_panels.Head();
	while (panel)
	{
		if (strcmpi(panelName, panel->Name()) == 0)
			return panel;
		panel = panel->next;
	}

	if (create)
		return Create(panelName);

	return NULL;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool InstrumentSystem::Remove(const char *panelName)
{
	InstrumentPanel *panel = Find(panelName, false);
	if (!panel)
		return false;

	m_panels.Remove(panel);
	return true;
}

///////////////////////////////////////////////////////////////////////////////
// How/hide a whole panel
///////////////////////////////////////////////////////////////////////////////
bool InstrumentSystem::Show(
const char *panelName,
bool show,
float transitionTime)
{
	InstrumentPanel *panel = Find(panelName, false);
	if (!panel)
		return false;

	return panel->ShowAll(show, transitionTime);
}

///////////////////////////////////////////////////////////////////////////////
// How/hide a whole panel
///////////////////////////////////////////////////////////////////////////////
bool InstrumentSystem::Activate(
const char *panelName,
bool activate)
{
	InstrumentPanel *panel = Find(panelName, false);
	if (!panel)
		return false;

	return panel->ActivateAll(activate);
}

///////////////////////////////////////////////////////////////////////////////
// Call this once per frame (updates all panels)
///////////////////////////////////////////////////////////////////////////////
void InstrumentSystem::Update()
{
	float dt = g_timer.GetFrameSec();

	InstrumentPanel *panel = m_panels.Head();
	while (panel)
	{
		panel->Update(dt);
		panel = panel->next;
	}
}

///////////////////////////////////////////////////////////////////////////////
// Globalized screen
///////////////////////////////////////////////////////////////////////////////
Vector2 InstrumentSystem::ScreenSize()
{
	return s_screenSize;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
Vector2 InstrumentSystem::TopLeft()
{
	Vector2 topLeft(s_screenSize.X() * s_overdrawX - s_wideScreenOffset, s_screenSize.Y() * s_overdrawY);
	return topLeft;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
Vector2 InstrumentSystem::BottomRight()
{
	Vector2 bottomRight(s_screenSize.X() * (1.0f - s_overdrawX) + s_wideScreenOffset, s_screenSize.Y() * (1.0f - s_overdrawY));
	return bottomRight;
}

