///////////////////////////////////////////////////////////////////////////////
// Simple text based instrument
///////////////////////////////////////////////////////////////////////////////
#include "hud/HudPCH.h"

#include "hud/text.h"
#include "hud/ipanel/itext.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
TextInstrument::TextInstrument(
const char *name) :
Instrument(name)
{
	m_pos.Clear();
	m_text.SetPriority(50);
}

///////////////////////////////////////////////////////////////////////////////
// Set the font
///////////////////////////////////////////////////////////////////////////////
void TextInstrument::SetFont(
const char *font,
float height)
{
	if (font)
		m_text.SetFont((char *)font);
	if (height > 0.0f)
		m_text.SetTextHeight(height);
}

///////////////////////////////////////////////////////////////////////////////
// Show/hide the instrument
///////////////////////////////////////////////////////////////////////////////
bool TextInstrument::Show(
bool show)
{
	if (show == m_hidden)
	{
		if (!show)
			m_text.Hide();
		else
		{
			if (m_active)
				m_text.Show();
		}
		m_hidden = !show;
	}

	return show;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool TextInstrument::Activate(
bool activate)
{
	if (activate != m_active)
	{
		if (!activate)
			m_text.Hide();
		else
		{
			if (!m_hidden)
				m_text.Show();
		}

		m_active = activate;
	}

	return activate;
}

///////////////////////////////////////////////////////////////////////////////
// Return the XY extent of this instrument (you write this!)
///////////////////////////////////////////////////////////////////////////////
Vector2 TextInstrument::Extents()
{
	Vector2 extents;
	extents.X(m_text.ComputeTextLength());
	extents.Y(m_text.ComputeTextHeight());
	return extents;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void TextInstrument::Place(
float x,
float y)
{
	m_pos.Set(x, y);
}

///////////////////////////////////////////////////////////////////////////////
// The update (called once per frame)
///////////////////////////////////////////////////////////////////////////////
void TextInstrument::Update(float dt)
{
	if (Hidden() || !Active())
		m_text.Hide();
	else
		m_text.Show();
}

///////////////////////////////////////////////////////////////////////////////
// Set the text
///////////////////////////////////////////////////////////////////////////////
bool TextInstrument::SetText(
const char *newText,
const char *font,
bool shadow)
{
	if (font)
		m_text.SetFont((char *)font);
	m_text.ShadowSettings(shadow);

	if (!newText)
		m_text.ClearText();
	else
	{
		m_text.SetPosition(m_pos.X(), m_pos.Y());
		m_text.SetText(newText);
	}

	return true;
}

