/***************************************************************************/
// Here is the implementation for determinants
/***************************************************************************/

/***************************************************************************/
// Return the det of a 2x2
/***************************************************************************/
inline float Determinant::Det(
float _11, float _12,
float _21, float _22)
{
	return(_11 * _22 - _21 * _12);
}

/***************************************************************************/
// Return the det of a 3x3
/***************************************************************************/
inline float Determinant::Det(
float _11, float _12, float _13,
float _21, float _22, float _23,
float _31, float _32, float _33)
{
	return(_11 * Det(_22, _23, _32, _33) -
			 _12 * Det(_21, _23, _31, _33) +
			 _13 * Det(_21, _22, _31, _32));
}

/***************************************************************************/
// Return the det of a 4x4
/***************************************************************************/
inline float Determinant::Det(
float _11, float _12, float _13, float _14,
float _21, float _22, float _23, float _24,
float _31, float _32, float _33, float _34,
float _41, float _42, float _43, float _44)
{
	return(_11 * Det(_22, _23, _24, _32, _33, _34, _42, _43, _44) -
			 _12 * Det(_21, _23, _24, _31, _33, _34, _41, _43, _44) +
			 _13 * Det(_21, _22, _24, _31, _32, _34, _41, _42, _44) -
			 _14 * Det(_21, _22, _23, _31, _32, _33, _41, _42, _43));
}










