///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline SemiSegment::SemiSegment()
{
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline SemiSegment::SemiSegment(Vector3CRef start, Vector3CRef end)
{
	SetEndPoints(start, end);
}

///////////////////////////////////////////////////////////////////////////////
// Set the endpoints
///////////////////////////////////////////////////////////////////////////////
inline void SemiSegment::SetEndPoints(Vector3CRef start, Vector3CRef end)
{
	m_center = (start + end) * 0.5f;
	m_half = end - m_center;
}

///////////////////////////////////////////////////////////////////////////////
// Get at the real start and end
///////////////////////////////////////////////////////////////////////////////
inline Vector3 SemiSegment::Start() const
{
	return m_center - m_half;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline Vector3 SemiSegment::End() const
{
	return m_center + m_half;
}
