//--------------------------------------------------------------//
// memcard_english_gcn.h
//
// Memory Card Standard Text - Gamecube
//
//--------------------------------------------------------------//

#ifndef _MEMCARD_ENGLISH_GCN_H_
#define _MEMCARD_ENGLISH_GCN_H_

// save files
#define MC_NO_VALID_SAVE_GAME			"The Memory Card in Slot %s does not have a valid saved %s."
#define MC_MEMCARD_FULL					"There is not enough space on the Memory Card in Slot %s. In order to save the %s, 1 file and %d blocks are required."
#define MC_MEMCARD_FULL_MULTIPLE		"There is not enough space on the Memory Card in Slot %s. In order to save the %s, 1 file and %d blocks are required."
#define MC_NO_CARD_SAVE					"No Memory Card found in Slot %s."
#define MC_NO_CARD_LOAD					"No Memory Card found in Slot %s."
#define MC_AUTOSAVE_REMOVED			"No Memory Card found in Slot %s.  The autosave function has been disabled."
#define MC_AUTOSAVE_NO_CARD			"No Memory Card found in Slot %s.  Please re-insert the Memory Card in Slot %s"
#define MC_SURE_LOAD						"Are you sure you want to load the saved %s?"
#define MC_SURE_SAVE						"Are you sure you want to save the %s?"
#define MC_SURE_DELETE					"Are you sure you want to delete the saved %s? All data will be lost."
#define MC_SURE_OVERWRITE				"Are you sure you want to overwrite the saved %s?"
#define MC_LOADING_FILE					"Loading saved %s."
#define MC_SAVING_FILE					"Saving %s. Do not remove the Memory Card in Slot %s or press the POWER Button."
#define MC_DELETE_FILE					"The saved %s is being deleted. Do not remove the Memory Card in Slot %s or press the POWER Button."
#define MC_OVERWRITE_FILE				"The saved %s is being deleted and recreated. Do not remove the Memory Card in Slot %s or press the POWER Button."

// common
#define MC_ACCESSING_CARD		"Please wait...\nDo not remove the Memory Card in Slot %s or press the POWER Button."
#define MC_FORMATTING			"Are you sure you want to format the Memory Card in Slot %s?"
#define MC_SURE_FORMAT			"Formatting the Memory Card in Slot %s will erase all previously saved data. Do you wish to proceed with formatting?"
#define MC_DETECT_CARD			"Please wait...\nDo not remove the Memory Card in Slot %s or press the POWER Button."	
#define MC_OTHER_MARKET			"The Memory Card in Slot %s is corrupted and needs to be formatted."
#define MC_UNFORMATTED_CARD	"The Memory Card in Slot %s is corrupted and needs to be formatted."
#define MC_UNFORMATTED_CARD_OK	"The Memory Card in Slot %s is corrupted and needs to be formatted."
#define MC_DAMAGED_CARD			"The Memory Card in Slot %s is damaged and cannot be used."
#define MC_CORRUPT_CARD			"The saved %s on the Memory Card in Slot %s is corrupt. This file needs to be deleted."
#define MC_LOADING_CANCELLED	"Loading Cancelled."
#define MC_SAVING_CANCELLED	"Saving Cancelled."
#define MC_DELETE_CANCELLED	"Deleting Cancelled."
#define MC_FORMAT_CANCELLED	"Format Cancelled."
#define MC_FORMAT_FAILED		"Format Failed."
#define MC_COMPLETED_OK			"Completed Successfully."
#define MC_FORMAT_COMPLETED_OK	"Format Completed Successfully."
#define MC_DELETE_COMPLETED_OK	"Delete Completed Successfully."
#define MC_LOAD_COMPLETED_OK	"Load Completed Successfully."
#define MC_SAVE_COMPLETED_OK	"Save Completed Successfully."

#endif	//_MEMCARD_ENGLISH_GCN_H_
