//--------------------------------------------------------------//
// memcard_english_xbox.h
//
// Memory Card Standard Text - xbox
//
//--------------------------------------------------------------//

#ifndef _MEMCARD_ENGLISH_XBOX_H_
#define _MEMCARD_ENGLISH_XBOX_H_

// game save
#define MC_NO_VALID_SAVE_GAME			"Unable to load saved %s."
#define MC_MEMCARD_FULL					"Your Xbox doesn't have enough free blocks to save the %s.  You need to free %s more blocks.  Continue without saving or use Xbox Dashboard to free more blocks."
#define MC_MEMCARD_FULL_STARTUP		"Your Xbox doesn't have enough free blocks to save the %s.  You need to free %s more blocks, or you may have to overwrite an existing %s.  Continue without saving or use Xbox Dashboard to free more blocks."
#define MC_MEMCARD_FULL_MULTIPLE		"Your Xbox doesn't have enough free blocks to save the %s.  You need to free %s more blocks.  Continue without saving or use Xbox Dashboard to free more blocks."
#define MC_CORRUPT_CARD					"Unable to load saved %s. Save game may be damaged."
#define MC_OTHER_MARKET					"Unable to load saved %s."
#define MC_DELETE_FILE					"The saved %s is being deleted. Do not turn off your Xbox console."
#define MC_LOADING_FILE					"Loading saved %s."
#define MC_SAVING_FILE					"Saving %s. Do not turn off your Xbox console."
#define MC_OVERWRITING_FILE			"Overwriting saved %s. Do not turn off your Xbox console."
#define MC_SURE_LOAD						"Are you sure you want to load the saved %s?"
#define MC_SURE_SAVE						"Are you sure you want to save the %s?"
#define MC_SURE_OVERWRITE				"Are you sure you want to overwrite the saved %s?"
#define MC_SURE_DELETE					"Are you sure you want to delete the saved %s?."
#define MC_NO_CARD_SAVE					"The memory unit is not inserted in controller %s, slot %s. Continue without saving"
#define MC_NO_CARD_LOAD					"The memory unit is not inserted in controller %s, slot %s. Please re-insert the memory unit."
#define MC_AUTOSAVE_NO_CARD			"The memory unit is not inserted in controller %s, slot %s. Please re-insert the memory unit."
#define MC_AUTOSAVE_REMOVED			"The memory unit in controller %s, slot %s has been removed. Autosave has been disabled."
#define MC_AUTOSAVE_REINSERT			"Please re-insert memory unit into controller %s, slot %s."
#define MC_DAMAGED_CARD					"The memory unit in controller %s, slot %s is unrecognized and cannot be used."
#define MC_CARD_CHANGED					"A memory unit has been inserted into controller %s, slot %s. Do you wish to enable autosave?"
#define MC_AUTOSAVING					"Do not turn off your Xbox console."
#define MC_MEMCARD_FULL_FILES			"You have reached the maximum saved games for \n%s. You must delete some saved games before you can save more games."
#define MC_ARE_YOU_SURE					"Are you sure?"

// common
#define MC_SAVE_FAILED			"Saving failed. The data was not written correctly."
#define MC_OVERWRITE_FAILED	"Overwrite failed. The data was not written correctly."
#define MC_ACCESSING_CARD		"Do not turn off your Xbox console."
#define MC_DETECT_CARD			"Please wait.\nDo not turn off power to the Xbox console."	
#define MC_COMPLETED_OK			"Completed Successfully."
#define MC_LOADING_CANCELLED	"Loading Cancelled."
#define MC_SAVING_CANCELLED	"Saving Cancelled."
#define MC_DELETE_CANCELLED	"Delete Cancelled."
#define MC_FORMAT_COMPLETED_OK	"Format Completed Successfully."
#define MC_DELETE_COMPLETED_OK	"Delete Completed Successfully."
#define MC_LOAD_COMPLETED_OK	"Load Completed Successfully."
#define MC_SAVE_COMPLETED_OK	"Save Completed Successfully."

#endif	//_MEMCARD_ENGLISH_XBOX_H_

