
#include "liblgkbm.h"
#include "hidkbcode.h"
#include "asciicode.h"
#include "ExtAsciiCode.h"


static lgKbdHidToAsciiTranslateTable USEnglishKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_GRAVE_ACCENT,   ASCII_TILDA,             0, 0},
    {{0}, HK_1,               ASCII_1         ,     ASCII_EXCLAMATION,       0, 0},
    {{0}, HK_2,               ASCII_2,              ASCII_AT,                0, 0},
    {{0}, HK_3,               ASCII_3,              ASCII_HASH,              0, 0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            0, 0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        0, 0},
    {{0}, HK_6,               ASCII_6,              ASCII_CIRCUM_ACCENT,     0, 0},
    {{0}, HK_7,               ASCII_7,              ASCII_AMPHERSAND,        0, 0},
    {{0}, HK_8,               ASCII_8,              ASCII_STAR,              0, 0},
    {{0}, HK_9,               ASCII_9,              ASCII_LEFT_PARENTHESIS,  0, 0},
    {{0}, HK_0,               ASCII_0,              ASCII_RIGHT_PARENTHESIS, 0, 0},
    {{0}, HK_MINUS,           ASCII_MINUS,          ASCII_UNDERSCORE,        0, 0},
    {{0}, HK_EQUAL,           ASCII_EQUAL,          ASCII_PLUS,              0, 0},
    {{0}, HK_KBD_KANJI3,      0,                    0,                       0, 0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0, 0},


    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0, 0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0, 0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0, 0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 0, 0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0, 0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0, 0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0, 0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0, 0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0, 0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0, 0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0, 0},
    {{0}, HK_SQ_OPEN_BRACKET, ASCII_SQ_BRACE_OPEN,  ASCII_CURLY_BRACE_OPEN,  0, 0},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_SQ_BRACE_CLOSE, ASCII_CURLY_BRACE_CLOSE, 0, 0},
    {{0}, HK_BACK_SLASH,      ASCII_BACK_SLASH,     ASCII_VERTICAL_LINE,     0, 0},


    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0, 0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0, 0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0, 0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0, 0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0, 0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0, 0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0, 0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0, 0},
    {{0}, HK_SEMICOLEN,       ASCII_SEMICOLEN,      ASCII_COLEN,             0, 0},
    {{0}, HK_QUOTE,           ASCII_APOSTROPHE,     ASCII_DOUBLE_QUOTE,      0, 0},
    {{0}, HK_NON_US_HASH,     0,                    0,                       0, 0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{0}, HK_NON_US_SLASH,    0,                    0,                       0, 0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0, 0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0, 0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0, 0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0, 0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 0, 0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_ANGLE_BRACE_OPEN,  0, 0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_ANGLE_BRACE_CLOSE, 0, 0},
    {{0}, HK_FORWARD_SLASH,   ASCII_FORWARD_SLASH,  ASCII_QUESTION_MARK,     0, 0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0, 0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0, 0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0, 0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0, 0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0, 0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0, 0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0, 0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0, 0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0, 0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0, 0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{2}, HK_KP_1,            ASCII_1         ,     0,                       0, 0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0, 0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0, 0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0, 0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0, 0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0, 0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0, 0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0, 0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0, 0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0, 0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0, 0},


};
#define szUSEnglishTable sizeof(USEnglishKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)



static lgKbdHidToAsciiTranslateTable GermanKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_CIRCUM_ACCENT,  EASCII_DEGREE,           0,                       0},
    {{0}, HK_1,               ASCII_1         ,     ASCII_EXCLAMATION,       0,                       0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      EASCII_SUPERSCRIPT_2,    0},
    {{0}, HK_3,               ASCII_3,              EASCII_SELECT_SIGN,      EASCII_SUPERSCRIPT_3,    0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            0,                       0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        0,                       0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND   ,     0,                       0},
    {{0}, HK_7,               ASCII_7,              ASCII_FORWARD_SLASH,     ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, ASCII_SQ_BRACE_CLOSE,    0},
    {{0}, HK_0,               ASCII_0,              ASCII_EQUAL,             ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_MINUS,           EASCII_SHARP_S,       ASCII_QUESTION_MARK,     ASCII_BACK_SLASH,	      0},
    {{0}, HK_EQUAL,           EASCII_ACUTE_ACCENT,  ASCII_GRAVE_ACCENT,      0,                       0},
    {{0}, HK_KBD_KANJI3,      0,                    0,                       0,                       0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0,                       0},

    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0,                       0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 ASCII_AT,                0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0,                       0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO,             0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0,                       0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0,                       0},
    {{1}, HK_Y,               ASCII_z,              ASCII_Z,                 0,                       0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0,                       0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0,                       0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0,                       0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0,                       0},
    {{0}, HK_SQ_OPEN_BRACKET, EASCII_u_DIAERESIS,   EASCII_U_DIAERESIS,      0,                       0},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_PLUS,           ASCII_STAR,              ASCII_TILDA,             0},

    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0,                       0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0,                       0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0,                       0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0,                       0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0,                       0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0,                       0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0,                       0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0,                       0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0,                       0},
    {{0}, HK_SEMICOLEN,       EASCII_o_DIAERESIS,   EASCII_O_DIAERESIS,      0,                       0},
    {{0}, HK_QUOTE,           EASCII_a_DIAERESIS,   EASCII_A_DIAERESIS,      0,                       0},
    {{0}, HK_NON_US_HASH,     ASCII_HASH,           ASCII_APOSTROPHE,        0,                       0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0,                       0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN,ASCII_ANGLE_BRACE_CLOSE, ASCII_VERTICAL_LINE,    0},
    {{1}, HK_Z,               ASCII_y,              ASCII_Y,                 0,                       0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0,                       0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0,                       0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0,                       0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0,                       0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0,                       0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 EASCII_MICRO,            0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0,                       0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             0,                       0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_UNDERSCORE,        0,                       0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0,                       0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0,                       0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0,                       0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0,                       0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0,                       0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0,                       0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0,                       0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0,                       0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0,                       0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0,                       0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0,                       0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0,                       0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0,                       0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0,                       0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0,                       0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0,                       0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0,                       0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0,                       0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0,                       0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0,                       0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0,                       0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0,                       0},

};
#define szGermanTable sizeof(GermanKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)



static lgKbdHidToAsciiTranslateTable SpanishKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    EASCII_MASCULINE_ORDINAL,    EASCII_FEMININE_ORDINAL, ASCII_BACK_SLASH, 0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       ASCII_VERTICAL_LINE,     0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      ASCII_AT,                0},
    {{0}, HK_3,               ASCII_3,              EASCII_MIDDLE_DOT,       ASCII_HASH,              0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            ASCII_TILDA,             0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        EASCII_EURO,             0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND,        EASCII_NOT_SIGN,         0},
    {{0}, HK_7,               ASCII_7,              ASCII_FORWARD_SLASH,     0,                       0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  0,                       0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, 0,                       0},
    {{0}, HK_0,               ASCII_0,              ASCII_EQUAL,             0,                       0},
    {{0}, HK_MINUS,           ASCII_APOSTROPHE,     ASCII_QUESTION_MARK,     0,                       0},
    {{0}, HK_EQUAL,           EASCII_INVERTED_EXCLAMATION, EASCII_INVERTED_QUESTION_MARK, 0,          0},
    {{0}, HK_KBD_KANJI3,      0,                    0,                       0,                       0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0,                       0},

    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0,                       0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0,                       0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0,                       0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO,             0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0,                       0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0,                       0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0,                       0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0,                       0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0,                       0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0,                       0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0,                       0},
    {{0}, HK_SQ_OPEN_BRACKET, ASCII_GRAVE_ACCENT,   ASCII_CIRCUM_ACCENT,     ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_PLUS,           ASCII_STAR,              ASCII_SQ_BRACE_CLOSE,    0},

    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0, 0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0, 0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0, 0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0, 0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0, 0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0, 0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0, 0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0, 0},
    {{0}, HK_SEMICOLEN,       EASCII_n_TILDA,       EASCII_N_TILDA,          0, 0},
    {{0}, HK_QUOTE,           EASCII_ACUTE_ACCENT,  EASCII_DIAERESIS,        ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_NON_US_HASH,     EASCII_c_CEDILLA,     EASCII_C_CEDILLA,        ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN,ASCII_ANGLE_BRACE_CLOSE,0, 0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0, 0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0, 0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0, 0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0, 0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 0, 0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0, 0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             0, 0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_UNDERSCORE,        0, 0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0, 0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0, 0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0, 0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0, 0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0, 0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0, 0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0, 0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0, 0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0, 0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0, 0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{2}, HK_KP_1,            ASCII_1         ,     0,                       0, 0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0, 0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0, 0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0, 0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0, 0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0, 0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0, 0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0, 0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0, 0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0, 0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0, 0}

};
#define szSpanishTable sizeof(SpanishKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)


static lgKbdHidToAsciiTranslateTable FrenchKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    EASCII_SUPERSCRIPT_2, 0,                       0,                       0},
    {{0}, HK_1,               ASCII_AMPHERSAND,     ASCII_1,                 0,                       0},
    {{0}, HK_2,               EASCII_e_ACUTE,       ASCII_2,                 ASCII_TILDA,             0},
    {{0}, HK_3,               ASCII_DOUBLE_QUOTE,   ASCII_3,                 ASCII_HASH,              0},
    {{0}, HK_4,               ASCII_APOSTROPHE,     ASCII_4,                 ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_5,               ASCII_LEFT_PARENTHESIS, ASCII_5,               ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_6,               ASCII_MINUS,          ASCII_6,                 ASCII_VERTICAL_LINE,     0},
    {{0}, HK_7,               EASCII_e_GRAVE,       ASCII_7,                 ASCII_GRAVE_ACCENT,      0},
    {{0}, HK_8,               ASCII_UNDERSCORE,     ASCII_8,                 ASCII_BACK_SLASH,        0},
    {{0}, HK_9,               EASCII_c_CEDILLA,     ASCII_9,                 ASCII_CIRCUM_ACCENT,     0},
    {{0}, HK_0,               EASCII_a_GRAVE,       ASCII_0,                 ASCII_AT,                0},
    {{0}, HK_MINUS,           ASCII_RIGHT_PARENTHESIS, EASCII_DEGREE,        ASCII_SQ_BRACE_CLOSE,    0},
    {{0}, HK_EQUAL,           ASCII_EQUAL,          ASCII_PLUS,              ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_KBD_KANJI3,      0,                    0,                       0,                       0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0,                       0},

    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0,                       0},
    {{1}, HK_Q,               ASCII_a,              ASCII_A,                 0,                       0},
    {{1}, HK_W,               ASCII_z,              ASCII_Z,                 0,                       0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO,             0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0,                       0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0,                       0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0,                       0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0,                       0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0,                       0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0,                       0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0,                       0},
    {{0}, HK_SQ_OPEN_BRACKET, ASCII_CIRCUM_ACCENT,  EASCII_DIAERESIS,        0,                       0},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_DOLLAR,         EASCII_POUND_SIGN,       EASCII_CURRENCY_SIGN,    0},
    {{0}, HK_BACK_SLASH,      0,                    0,                       0,                       0},

    {{1}, HK_A,               ASCII_q,              ASCII_Q,                 0,                       0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0,                       0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0,                       0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0,                       0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0,                       0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0,                       0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0,                       0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0,                       0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0,                       0},
    {{1}, HK_SEMICOLEN,       ASCII_m,              ASCII_M,                 0,                       0},
    {{0}, HK_QUOTE,           EASCII_u_GRAVE,       ASCII_PERCENTAGE,        0,                       0},
    {{0}, HK_NON_US_HASH,     ASCII_STAR,           EASCII_MICRO,            0,                       0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0,                       0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN, ASCII_ANGLE_BRACE_CLOSE, 0,                     0},
    {{1}, HK_Z,               ASCII_w,              ASCII_W,                 0,                       0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0,                       0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0,                       0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0,                       0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0,                       0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0,                       0},
    {{0}, HK_M,               ASCII_COMMA,          ASCII_QUESTION_MARK,     0,                       0},
    {{0}, HK_COMMA,           ASCII_SEMICOLEN,      ASCII_DOT,               0,                       0},
    {{0}, HK_DOT,             ASCII_COLEN,          ASCII_FORWARD_SLASH,     0,                       0},
    {{0}, HK_FORWARD_SLASH,   ASCII_EXCLAMATION,    EASCII_SELECT_SIGN,      0,                       0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0,                       0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0,                       0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0,                       0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0,                       0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0,                       0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0,                       0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0,                       0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0,                       0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0,                       0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0,                       0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0,                       0},

    {{2}, HK_KP_1,            ASCII_1,		    0,                       0,                       0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0,                       0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0,                       0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0,                       0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0,                       0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0,                       0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0,                       0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0,                       0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0,                       0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0,                       0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0,                       0}

};
#define szFrenchTable sizeof(FrenchKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)

#if 0 
static lgKbdHidToAsciiTranslateTable UKEnglishKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_GRAVE_ACCENT,   EASCII_NOT_SIGN,         EASCII_BROKEN_BAR,       0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       0,                       0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      0,                       0},
    {{0}, HK_3,               ASCII_3,              EASCII_POUND_SIGN,       0,                       0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            EASCII_EURO,             0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        0,                       0},
    {{0}, HK_6,               ASCII_6,              ASCII_CIRCUM_ACCENT,     0,                       0},
    {{0}, HK_7,               ASCII_7,              ASCII_AMPHERSAND,        0,                       0},
    {{0}, HK_8,               ASCII_8,              ASCII_STAR,              0,                       0},
    {{0}, HK_9,               ASCII_9,              ASCII_LEFT_PARENTHESIS,  0,                       0},
    {{0}, HK_0,               ASCII_0,              ASCII_RIGHT_PARENTHESIS, 0,                       0},
    {{0}, HK_MINUS,           ASCII_MINUS,          ASCII_UNDERSCORE,        0,                       0},
    {{0}, HK_EQUAL,           ASCII_EQUAL,          ASCII_PLUS,              0,                       0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0,                       0},

    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0,                       0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0,                       0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0,                       0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_e_ACUTE,          EASCII_E_ACUTE},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0,                       0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0,                       0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0,                       0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 EASCII_u_ACUTE,          EASCII_U_ACUTE},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 EASCII_i_ACUTE,          EASCII_I_ACUTE},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 EASCII_o_ACUTE,          EASCII_O_ACUTE},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0,                       0},
    {{0}, HK_SQ_OPEN_BRACKET, ASCII_SQ_BRACE_OPEN,  ASCII_CURLY_BRACE_OPEN,  0,                       0},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_SQ_BRACE_CLOSE, ASCII_CURLY_BRACE_CLOSE, 0,                       0},

    {{1}, HK_A,               ASCII_a,              ASCII_A,                 EASCII_a_ACUTE,          EASCII_A_ACUTE},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0,                       0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0,                       0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0,                       0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0,                       0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0,                       0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0,                       0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0,                       0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0,                       0},
    {{0}, HK_SEMICOLEN,       ASCII_SEMICOLEN,      ASCII_COLEN,             0,                       0},
    {{0}, HK_QUOTE,           ASCII_APOSTROPHE,     ASCII_AT,                0,                       0},
    {{0}, HK_NON_US_HASH,     ASCII_HASH,           ASCII_TILDA,             0,                       0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0,                       0},

    {{0}, HK_NON_US_SLASH,    ASCII_BACK_SLASH,     ASCII_VERTICAL_LINE,     0,                       0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0,                       0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0,                       0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0,                       0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0,                       0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0,                       0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0,                       0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 0,                       0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_ANGLE_BRACE_OPEN,  0,                       0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_ANGLE_BRACE_CLOSE, 0,                       0},
    {{0}, HK_FORWARD_SLASH,   ASCII_FORWARD_SLASH,  ASCII_QUESTION_MARK,     0,                       0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0,                       0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0,                       0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0,                       0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0,                       0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0,                       0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0,                       0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0,                       0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0,                       0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0,                       0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0,                       0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0,                       0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0,                       0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0,                       0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0,                       0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0,                       0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0,                       0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0,                       0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0,                       0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0,                       0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0,                       0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0,                       0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0,                       0}

};
#define szUKEnglishTable sizeof(UKEnglishKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)
#endif


static lgKbdHidToAsciiTranslateTable ItalianKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_BACK_SLASH,     ASCII_VERTICAL_LINE,     0, 0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       0, 0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      0, 0},
    {{0}, HK_3,               ASCII_3,              EASCII_POUND_SIGN,       0, 0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            0, 0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        EASCII_EURO, 0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND,        0, 0},
    {{0}, HK_7,               ASCII_7,              ASCII_FORWARD_SLASH,     0, 0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  0, 0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, 0, 0},
    {{0}, HK_0,               ASCII_0,              ASCII_EQUAL,             0, 0},
    {{0}, HK_MINUS,           ASCII_APOSTROPHE,     ASCII_QUESTION_MARK,     0, 0},
    {{0}, HK_EQUAL,           EASCII_i_GRAVE,       ASCII_CIRCUM_ACCENT,     0, 0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0, 0},

    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0, 0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0, 0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0, 0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO, 0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0, 0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0, 0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0, 0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0, 0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0, 0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0, 0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0, 0},
    {{0}, HK_SQ_OPEN_BRACKET, EASCII_e_GRAVE,       EASCII_e_ACUTE,          ASCII_SQ_BRACE_OPEN,  ASCII_CURLY_BRACE_OPEN},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_PLUS,           ASCII_STAR,              ASCII_SQ_BRACE_CLOSE, ASCII_CURLY_BRACE_CLOSE},

    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0, 0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0, 0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0, 0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0, 0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0, 0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0, 0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0, 0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0, 0},
    {{0}, HK_SEMICOLEN,       EASCII_o_GRAVE,       EASCII_c_CEDILLA,        ASCII_AT,   0},
    {{0}, HK_QUOTE,           EASCII_a_GRAVE,       EASCII_DEGREE,           ASCII_HASH, 0},
    {{0}, HK_NON_US_HASH,     EASCII_u_GRAVE,       EASCII_SELECT_SIGN,      0, 0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN, ASCII_ANGLE_BRACE_CLOSE, 0, 0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0, 0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0, 0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0, 0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0, 0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 0, 0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0, 0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             0, 0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_UNDERSCORE,        0, 0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0, 0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0, 0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0, 0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0, 0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0, 0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0, 0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0, 0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0, 0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0, 0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0, 0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0, 0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0, 0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0, 0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0, 0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0, 0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0, 0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0, 0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0, 0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0, 0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0, 0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0, 0}

};
#define szItalianTable sizeof(ItalianKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)

#if 0
static lgKbdHidToAsciiTranslateTable Italian142KbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_BACK_SLASH,     ASCII_VERTICAL_LINE,     0,                       0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       0,                       0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      0,                       0},
    {{0}, HK_3,               ASCII_3,              EASCII_POUND_SIGN,       ASCII_HASH,              0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            0,                       0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        EASCII_EURO,             0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND,        0,                       0},
    {{0}, HK_7,               ASCII_7,              ASCII_FORWARD_SLASH,     ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_0,               ASCII_0,              ASCII_EQUAL,             ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_MINUS,           ASCII_APOSTROPHE,     ASCII_QUESTION_MARK,     0,                       0},
    {{0}, HK_EQUAL,           EASCII_i_GRAVE,       ASCII_CIRCUM_ACCENT,     0,                       0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0,                       0},

    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0,                       0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 ASCII_AT,                0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0,                       0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO,             0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0,                       0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0,                       0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0,                       0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0,                       0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0,                       0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0,                       0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0,                       0},
    {{0}, HK_SQ_OPEN_BRACKET, EASCII_e_GRAVE,       EASCII_e_ACUTE,          0,                       0},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_PLUS,           ASCII_STAR,              ASCII_TILDA,             0},

    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0, 0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0, 0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0, 0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0, 0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0, 0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0, 0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0, 0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0, 0},
    {{0}, HK_SEMICOLEN,       EASCII_o_GRAVE,       EASCII_c_CEDILLA,        0, 0},
    {{0}, HK_QUOTE,           EASCII_a_GRAVE,       EASCII_DEGREE,           0, 0},
    {{0}, HK_NON_US_HASH,     EASCII_u_GRAVE,       EASCII_SELECT_SIGN,      ASCII_GRAVE_ACCENT, 0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0,                  0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN, ASCII_ANGLE_BRACE_CLOSE, 0, 0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0, 0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0, 0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0, 0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0, 0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 0, 0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0, 0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             0, 0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_UNDERSCORE,        0, 0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0, 0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0, 0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0, 0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0, 0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0, 0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0, 0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0, 0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0, 0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0, 0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0, 0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0, 0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0, 0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0, 0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0, 0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0, 0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0, 0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0, 0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0, 0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0, 0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0, 0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0, 0}

};
#define szItalian142Table sizeof(Italian142KbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)



static lgKbdHidToAsciiTranslateTable DutchKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_AT,             EASCII_SELECT_SIGN,      EASCII_NOT_SIGN,         0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       EASCII_SUPERSCRIPT_1,    0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      EASCII_SUPERSCRIPT_2,    0},
    {{0}, HK_3,               ASCII_3,              ASCII_HASH,              EASCII_SUPERSCRIPT_3,    0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            EASCII_ONE_QUARTER,      0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        EASCII_ONE_HALF,         0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND,        EASCII_THREE_QUARTERS,   0},
    {{0}, HK_7,               ASCII_7,              ASCII_UNDERSCORE,        EASCII_POUND_SIGN,       0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_0,               ASCII_0,              ASCII_APOSTROPHE,        0,                       0},
    {{0}, HK_MINUS,           ASCII_FORWARD_SLASH,  ASCII_QUESTION_MARK,     ASCII_BACK_SLASH,        0},
    {{0}, HK_EQUAL,           EASCII_DEGREE,        ASCII_TILDA,             EASCII_CEDILLA,          0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         ASCII_BACKSPACE,         0},

    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0,              0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0,              0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0,              0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO,    0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 EASCII_PILCROW, 0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0,              0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0,              0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0,              0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0,              0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0,              0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0,              0},
    {{0}, HK_SQ_OPEN_BRACKET, EASCII_DIAERESIS,     ASCII_CIRCUM_ACCENT,     0,              0},
    {{0}, HK_SQ_CLOSE_BRACKET,ASCII_STAR,           ASCII_VERTICAL_LINE,     0,              0},

    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0,              0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 EASCII_SHARP_S, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0,              0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0,              0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0,              0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0,              0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0,              0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0,              0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0,              0},
    {{0}, HK_SEMICOLEN,       ASCII_PLUS,           EASCII_PLUS_MINUS,       0,              0},
    {{0}, HK_QUOTE,           EASCII_ACUTE_ACCENT,  ASCII_GRAVE_ACCENT,      0,              0},
    {{0}, HK_NON_US_HASH,     ASCII_ANGLE_BRACE_OPEN,ASCII_ANGLE_BRACE_CLOSE,0,              0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0,              0},

    {{0}, HK_NON_US_SLASH,    ASCII_SQ_BRACE_CLOSE, ASCII_SQ_BRACE_OPEN,     EASCII_BROKEN_BAR,     0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 EASCII_LP_2_ANG_QUOTE, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 EASCII_RP_2_ANG_QUOTE, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 EASCII_CENT_SIGN,      0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0,                     0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0,                     0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0,                     0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 EASCII_MICRO,          0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0,                     0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             EASCII_MIDDLE_DOT,     0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_EQUAL,             0,              0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0,              0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0,              0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0,              0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0,              0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0,              0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0,              0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0,              0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0,              0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0,              0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0,              0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0,              0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0,              0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0,              0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0,              0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0,              0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0,              0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0,              0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0,              0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0,              0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0,              0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0,              0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0,              0}

};
#define szDutchTable sizeof(DutchKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)


static lgKbdHidToAsciiTranslateTable NorwegianKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_VERTICAL_LINE,  EASCII_SELECT_SIGN,      0,                       0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       0,                       0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      ASCII_AT,                0},
    {{0}, HK_3,               ASCII_3,              ASCII_HASH,              EASCII_POUND_SIGN,       0},
    {{0}, HK_4,               ASCII_4,              EASCII_CURRENCY_SIGN,    ASCII_DOLLAR,            0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        EASCII_EURO,             0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND,        0,                       0},
    {{0}, HK_7,               ASCII_7,              ASCII_FORWARD_SLASH,     ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, ASCII_SQ_BRACE_CLOSE,    0},
    {{0}, HK_0,               ASCII_0,              ASCII_EQUAL,             ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_MINUS,           ASCII_PLUS,           ASCII_QUESTION_MARK,     0,                       0},
    {{0}, HK_EQUAL,           ASCII_BACK_SLASH,     ASCII_GRAVE_ACCENT,      EASCII_ACUTE_ACCENT,     0},
    {{0}, HK_KBD_KANJI3,      0,                    0,                       0,                       0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0,                       0},


    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0,           0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0,           0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0,           0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO, 0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0,           0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0,           0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0,           0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0,           0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0,           0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0,           0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0,           0},
    {{0}, HK_SQ_OPEN_BRACKET, EASCII_a_RING,        EASCII_A_RING,           0,           0},
    {{0}, HK_SQ_CLOSE_BRACKET,EASCII_DIAERESIS,     ASCII_CIRCUM_ACCENT,     ASCII_TILDA, 0},
    {{0}, HK_BACK_SLASH,      0,                    0,                       0,           0},


    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0, 0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0, 0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0, 0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0, 0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0, 0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0, 0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0, 0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0, 0},
    {{0}, HK_SEMICOLEN,       EASCII_o_STROKE,      EASCII_O_STROKE,         0, 0},
    {{0}, HK_QUOTE,           EASCII_ae,            EASCII_AE,               0, 0},
    {{0}, HK_NON_US_HASH,     ASCII_APOSTROPHE,     ASCII_STAR,              0, 0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN, ASCII_ANGLE_BRACE_CLOSE,0,0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0, 0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0, 0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0, 0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0, 0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 EASCII_MICRO, 0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0, 0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             0, 0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_UNDERSCORE,        0, 0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0, 0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0, 0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0, 0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0, 0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0, 0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0, 0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0, 0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0, 0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0, 0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0, 0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0, 0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0, 0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0, 0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0, 0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0, 0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0, 0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0, 0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0, 0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0, 0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0, 0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0, 0},

};
#define szNorwegianTable sizeof(NorwegianKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)


static lgKbdHidToAsciiTranslateTable FinnishKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    EASCII_SELECT_SIGN,   EASCII_ONE_HALF,         0,                       0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       0,                       0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      ASCII_AT,                0},
    {{0}, HK_3,               ASCII_3,              ASCII_HASH,              EASCII_POUND_SIGN,       0},
    {{0}, HK_4,               ASCII_4,              EASCII_CURRENCY_SIGN,    ASCII_DOLLAR,            0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        EASCII_EURO,             0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND,        0,                       0},
    {{0}, HK_7,               ASCII_7,              ASCII_FORWARD_SLASH,     ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, ASCII_SQ_BRACE_CLOSE,    0},
    {{0}, HK_0,               ASCII_0,              ASCII_EQUAL,             ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_MINUS,           ASCII_PLUS,           ASCII_QUESTION_MARK,     ASCII_BACK_SLASH,        0},
    {{0}, HK_EQUAL,           EASCII_ACUTE_ACCENT,  ASCII_GRAVE_ACCENT,      0,                       0},
    {{0}, HK_KBD_KANJI3,      0,                    0,                       0,                       0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0,                       0},


    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0, 0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0, 0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0, 0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO, 0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0, 0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0, 0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0, 0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0, 0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0, 0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0, 0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0, 0},
    {{0}, HK_SQ_OPEN_BRACKET, EASCII_a_RING,        EASCII_A_RING,           0, 0},
    {{0}, HK_SQ_CLOSE_BRACKET,EASCII_DIAERESIS,     ASCII_CIRCUM_ACCENT,     ASCII_TILDA, 0},
    {{0}, HK_BACK_SLASH,      0,                    0,                       0, 0},


    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0, 0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0, 0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0, 0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0, 0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0, 0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0, 0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0, 0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0, 0},
    {{0}, HK_SEMICOLEN,       EASCII_o_DIAERESIS,   EASCII_O_DIAERESIS,      0, 0},
    {{0}, HK_QUOTE,           EASCII_a_DIAERESIS,   EASCII_A_DIAERESIS,      0, 0},
    {{0}, HK_NON_US_HASH,     ASCII_APOSTROPHE,     ASCII_STAR,              0, 0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN, ASCII_ANGLE_BRACE_CLOSE, ASCII_VERTICAL_LINE, 0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0, 0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0, 0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0, 0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0, 0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 EASCII_MICRO, 0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0, 0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             0, 0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_UNDERSCORE,        0, 0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0, 0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0, 0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0, 0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0, 0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0, 0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0, 0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0, 0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0, 0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0, 0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0, 0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0, 0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0, 0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0, 0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0, 0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0, 0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0, 0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0, 0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0, 0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0, 0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0, 0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0, 0},


};
#define szFinnishTable sizeof(FinnishKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)


static lgKbdHidToAsciiTranslateTable PortugueseKbdMapTable[] = {
    {{0}, HK_GRAVE_ACCENT,    ASCII_BACK_SLASH,     ASCII_VERTICAL_LINE,     0,                       0},
    {{0}, HK_1,               ASCII_1,              ASCII_EXCLAMATION,       0,                       0},
    {{0}, HK_2,               ASCII_2,              ASCII_DOUBLE_QUOTE,      ASCII_AT,                0},
    {{0}, HK_3,               ASCII_3,              ASCII_HASH,              EASCII_POUND_SIGN,       0},
    {{0}, HK_4,               ASCII_4,              ASCII_DOLLAR,            EASCII_SELECT_SIGN,      0},
    {{0}, HK_5,               ASCII_5,              ASCII_PERCENTAGE,        EASCII_EURO,             0},
    {{0}, HK_6,               ASCII_6,              ASCII_AMPHERSAND,        0,                       0},
    {{0}, HK_7,               ASCII_7,              ASCII_FORWARD_SLASH,     ASCII_CURLY_BRACE_OPEN,  0},
    {{0}, HK_8,               ASCII_8,              ASCII_LEFT_PARENTHESIS,  ASCII_SQ_BRACE_OPEN,     0},
    {{0}, HK_9,               ASCII_9,              ASCII_RIGHT_PARENTHESIS, ASCII_SQ_BRACE_CLOSE,    0},
    {{0}, HK_0,               ASCII_0,              ASCII_EQUAL,             ASCII_CURLY_BRACE_CLOSE, 0},
    {{0}, HK_MINUS,           ASCII_APOSTROPHE,     ASCII_QUESTION_MARK,     0, 0},
    {{0}, HK_EQUAL,           EASCII_LP_2_ANG_QUOTE,EASCII_RP_2_ANG_QUOTE,   0, 0},
    {{0}, HK_KBD_KANJI3,      0,                    0,                       0, 0},
    {{0}, HK_BACKSPACE,       ASCII_BACKSPACE,      ASCII_BACKSPACE,         0, 0},


    {{0}, HK_TAB,             ASCII_TAB,            ASCII_TAB,               0, 0},
    {{1}, HK_Q,               ASCII_q,              ASCII_Q,                 0, 0},
    {{1}, HK_W,               ASCII_w,              ASCII_W,                 0, 0},
    {{1}, HK_E,               ASCII_e,              ASCII_E,                 EASCII_EURO, 0},
    {{1}, HK_R,               ASCII_r,              ASCII_R,                 0, 0},
    {{1}, HK_T,               ASCII_t,              ASCII_T,                 0, 0},
    {{1}, HK_Y,               ASCII_y,              ASCII_Y,                 0, 0},
    {{1}, HK_U,               ASCII_u,              ASCII_U,                 0, 0},
    {{1}, HK_I,               ASCII_i,              ASCII_I,                 0, 0},
    {{1}, HK_O,               ASCII_o,              ASCII_O,                 0, 0},
    {{1}, HK_P,               ASCII_p,              ASCII_P,                 0, 0},
    {{0}, HK_SQ_OPEN_BRACKET, ASCII_PLUS,           ASCII_STAR,              EASCII_DIAERESIS,     0},
    {{0}, HK_SQ_CLOSE_BRACKET,EASCII_ACUTE_ACCENT,  ASCII_GRAVE_ACCENT,      ASCII_SQ_BRACE_CLOSE, 0},
    {{0}, HK_BACK_SLASH,      0,                    0,                       0, 0},


    {{1}, HK_A,               ASCII_a,              ASCII_A,                 0, 0},
    {{1}, HK_S,               ASCII_s,              ASCII_S,                 0, 0},
    {{1}, HK_D,               ASCII_d,              ASCII_D,                 0, 0},
    {{1}, HK_F,               ASCII_f,              ASCII_F,                 0, 0},
    {{1}, HK_G,               ASCII_g,              ASCII_G,                 0, 0},
    {{1}, HK_H,               ASCII_h,              ASCII_H,                 0, 0},
    {{1}, HK_J,               ASCII_j,              ASCII_J,                 0, 0},
    {{1}, HK_K,               ASCII_k,              ASCII_K,                 0, 0},
    {{1}, HK_L,               ASCII_l,              ASCII_L,                 0, 0},
    {{0}, HK_SEMICOLEN,       EASCII_c_CEDILLA,     EASCII_C_CEDILLA,        0, 0},
    {{0}, HK_QUOTE,           EASCII_MASCULINE_ORDINAL, EASCII_FEMININE_ORDINAL, 0, 0},
    {{0}, HK_NON_US_HASH,     ASCII_TILDA,          ASCII_CIRCUM_ACCENT,     0, 0},
    {{0}, HK_ENTER,           ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{0}, HK_NON_US_SLASH,    ASCII_ANGLE_BRACE_OPEN, ASCII_ANGLE_BRACE_CLOSE,0, 0},
    {{1}, HK_Z,               ASCII_z,              ASCII_Z,                 0, 0},
    {{1}, HK_X,               ASCII_x,              ASCII_X,                 0, 0},
    {{1}, HK_C,               ASCII_c,              ASCII_C,                 0, 0},
    {{1}, HK_V,               ASCII_v,              ASCII_V,                 0, 0},
    {{1}, HK_B,               ASCII_b,              ASCII_B,                 0, 0},
    {{1}, HK_N,               ASCII_n,              ASCII_N,                 0, 0},
    {{1}, HK_M,               ASCII_m,              ASCII_M,                 0, 0},
    {{0}, HK_COMMA,           ASCII_COMMA,          ASCII_SEMICOLEN,         0, 0},
    {{0}, HK_DOT,             ASCII_DOT,            ASCII_COLEN,             0, 0},
    {{0}, HK_FORWARD_SLASH,   ASCII_MINUS,          ASCII_UNDERSCORE,        0, 0},
    {{0}, HK_KBD_KANJI1,      0,                    0,                       0, 0},

    {{0}, HK_KBD_KANJI5,      0,                    0,                       0, 0},
    {{0}, HK_SPACEBAR,        ASCII_SPACE,          ASCII_SPACE,             0, 0},
    {{0}, HK_KBD_KANJI4,      0,                    0,                       0, 0},
    {{0}, HK_KBD_KANJI2,      0,                    0,                       0, 0},
    {{0}, HK_ESCAPE,          ASCII_ESCAPE,         ASCII_ESCAPE,            0, 0},

    {{2}, HK_KP_SLASH,        ASCII_FORWARD_SLASH,  ASCII_FORWARD_SLASH,     0, 0},
    {{2}, HK_KP_STAR,         ASCII_STAR,           ASCII_STAR,              0, 0},
    {{2}, HK_KP_MINUS,        ASCII_MINUS,          ASCII_MINUS,             0, 0},
    {{2}, HK_KP_PLUS,         ASCII_PLUS,           ASCII_PLUS,              0, 0},
    {{2}, HK_KP_ENTER,        ASCII_ENTER,          ASCII_ENTER,             0, 0},

    {{2}, HK_KP_1,            ASCII_1,              0,                       0, 0},
    {{2}, HK_KP_2,            ASCII_2,              0,                       0, 0},
    {{2}, HK_KP_3,            ASCII_3,              0,                       0, 0},
    {{2}, HK_KP_4,            ASCII_4,              0,                       0, 0},
    {{2}, HK_KP_5,            ASCII_5,              0,                       0, 0},
    {{2}, HK_KP_6,            ASCII_6,              0,                       0, 0},
    {{2}, HK_KP_7,            ASCII_7,              0,                       0, 0},
    {{2}, HK_KP_8,            ASCII_8,              0,                       0, 0},
    {{2}, HK_KP_9,            ASCII_9,              0,                       0, 0},
    {{2}, HK_KP_0,            ASCII_0,              0,                       0, 0},
    {{2}, HK_KP_DOT,          ASCII_DOT,            0,                       0, 0},


};
#define szPortugueseTable sizeof(PortugueseKbdMapTable)/sizeof(lgKbdHidToAsciiTranslateTable)
#endif

typedef struct _MapTables {
		lgKbdHidToAsciiTranslateTable	*Table;
		int							szTable;
}MapTables;


