// This is part of the Professional User Interface Suite library.
// Copyright (C) 2001-2004 FOSS Software, Inc.
// All rights reserved.
//
// http://www.prof-uis.com
// http://www.fossware.com
// mailto:support@fossware.com
//
// This source code can be used, modified and redistributed
// under the terms of the license agreement that is included
// in the Professional User Interface Suite package.
//
// Warranties and Disclaimers:
// THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND
// INCLUDING, BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
// IN NO EVENT WILL FOSS SOFTWARE INC. BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES,
// INCLUDING DAMAGES FOR LOSS OF PROFITS, LOSS OR INACCURACY OF DATA,
// INCURRED BY ANY PERSON FROM SUCH PERSON'S USAGE OF THIS SOFTWARE
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

#include "stdafx.h"

#if (!defined __EXT_PROF_UIS_ABOUT_DIALOG_H)
	#include <ExtProfUISAboutDialog.h>
#endif

#if (!defined __EXT_RESIZABLE_DIALOG_H)
	#include <ExtResizableDialog.h>
#endif

#if (!defined __EXT_LABEL_H)
	#include <ExtLabel.h>
#endif

#if (!defined __EXT_BUTTON_H)
	#include <ExtButton.h>
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#if (!defined __EXT_MFC_NO_PROF_UIS_ABOUT_DIALOG)

#define __URL_WWW			_T("www.prof-uis.com")
#define __URL_E_MAIL		_T("info@prof-uis.com")

#define __TOOLTIP_WWW		_T("Learn more about Prof-UIS")
#define __TOOLTIP_E_MAIL	_T("Contact us if you have any questions")

class CExtProfUISAboutDialog : public CExtResizableDialog 
{
	static BYTE g_arrBmpData[];

public:
	CExtProfUISAboutDialog( 
		LPCTSTR szApp,
		LPCTSTR szOtherStuff,
		HICON hIcon
		);
	
	// Dialog Data
	//{{AFX_DATA(CExtProfUISAboutDialog)
	//}}AFX_DATA
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CExtProfUISAboutDialog)
	//}}AFX_VIRTUAL
	
	// Implementation
protected:
	CExtButton	m_btnOk;
	CExtLabel	m_labelApp;
	CStatic		m_labelLogo;
	CStatic		m_labelAppIcon;
	CExtLabel	m_labelOtherStuff;
	CStatic		m_labelSeparator;
	CExtLabel	m_labelCopyright;
	CExtLabel	m_labelWebSite;
	CExtLabel	m_labelEMail;
	CExtHyperLinkButton	m_wndWebSite;
	CExtHyperLinkButton	m_wndEMail;
	
	LPCTSTR		m_szApp;
	LPCTSTR		m_szOtherStuff;
	HICON		m_hIcon;
		
	// Generated message map functions
	//{{AFX_MSG(CExtProfUISAboutDialog)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

BYTE CExtProfUISAboutDialog::g_arrBmpData[] = 
{	
	0x42, 0x4D, 0x3E, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x28, 0x00,
		0x00, 0x00, 0x54, 0x01, 0x00, 0x00, 0x3D, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x08, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
		0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5A, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x57, 0x02, 0x57, 0x02,
		0x57, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5B, 0x02, 0x5C, 0x02, 0x5C, 0x02, 0x5C, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5B, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3D, 0x02, 0x7E, 0x12,
		0x7E, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E,
		0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x7E, 0x12,
		0x7D, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x7A, 0x12,
		0x79, 0x12, 0x79, 0x12, 0x7A, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0xFE, 0x3A, 0xBF, 0x6F, 0xBF, 0x6F, 0xBF, 0x6F, 0xBF, 0x6F, 0x9F, 0x67, 0x5F, 0x57, 0x5F, 0x57,
		0x5F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x3E, 0x3F, 0xBD, 0x22, 0x35, 0x63, 0x55, 0x6F,
		0x56, 0x6B, 0x57, 0x67, 0x58, 0x63, 0x57, 0x63, 0x37, 0x5F, 0x16, 0x5F, 0xF6, 0x5A, 0xF5, 0x5A,
		0xD5, 0x56, 0xD5, 0x56, 0xF5, 0x56, 0xF5, 0x5A, 0xF5, 0x5A, 0xF5, 0x5A, 0xF5, 0x5A, 0xF5, 0x5A,
		0xF5, 0x5A, 0xD5, 0x56, 0xD5, 0x56, 0xD5, 0x56, 0xD5, 0x56, 0xF5, 0x5A, 0xF6, 0x5E, 0x16, 0x63,
		0x35, 0x67, 0x55, 0x6F, 0x54, 0x6F, 0x53, 0x73, 0x52, 0x73, 0x52, 0x73, 0x31, 0x73, 0x30, 0x73,
		0x0F, 0x73, 0xED, 0x6E, 0xCA, 0x6E, 0xEA, 0x72, 0x2A, 0x77, 0x4B, 0x7B, 0x6C, 0x7F, 0x8E, 0x7F,
		0xB0, 0x7F, 0xB1, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xF6, 0x7F,
		0x56, 0x6B, 0x73, 0x46, 0x0F, 0x42, 0xCB, 0x3D, 0xCA, 0x45, 0xC9, 0x4D, 0x09, 0x56, 0x4A, 0x62,
		0x8A, 0x6A, 0xAA, 0x6E, 0xEA, 0x72, 0x0B, 0x77, 0x2B, 0x77, 0x2B, 0x7B, 0x2C, 0x7B, 0x2C, 0x7B,
		0x2D, 0x77, 0x0E, 0x73, 0x0F, 0x73, 0x11, 0x6F, 0x13, 0x6B, 0x34, 0x67, 0x36, 0x67, 0x58, 0x67,
		0x7A, 0x67, 0x9B, 0x67, 0xBC, 0x6F, 0xD8, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD4, 0x7F, 0xD3, 0x7F, 0xB2, 0x7F, 0xB0, 0x7F, 0x8F, 0x7F, 0x6F, 0x7B, 0x4F, 0x7B, 0x10, 0x6F,
		0xD1, 0x62, 0xD3, 0x56, 0xF6, 0x5A, 0x38, 0x5F, 0x7A, 0x67, 0x9B, 0x6B, 0x9B, 0x6B, 0x9B, 0x6B,
		0x9B, 0x6B, 0x9A, 0x67, 0x79, 0x63, 0x38, 0x5F, 0x16, 0x5B, 0xD4, 0x56, 0x92, 0x52, 0x2F, 0x4A,
		0xED, 0x45, 0xCB, 0x41, 0x89, 0x3D, 0x68, 0x39, 0x47, 0x39, 0x27, 0x35, 0x26, 0x31, 0x06, 0x31,
		0x05, 0x31, 0x05, 0x2D, 0xE5, 0x2C, 0xE5, 0x2C, 0xE5, 0x2C, 0xE5, 0x2C, 0xE4, 0x30, 0xE5, 0x30,
		0x05, 0x31, 0x05, 0x35, 0x05, 0x35, 0x25, 0x39, 0xA6, 0x51, 0x68, 0x6E, 0x0A, 0x7B, 0x4B, 0x7B,
		0x4B, 0x7B, 0x4B, 0x7B, 0x2A, 0x7B, 0xEA, 0x76, 0xA9, 0x72, 0x89, 0x6E, 0x48, 0x66, 0x28, 0x62,
		0x08, 0x5E, 0xE7, 0x55, 0xC7, 0x55, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5C, 0x02, 0x5C, 0x02, 0x5C, 0x02,
		0x5C, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3C, 0x02,
		0x3C, 0x02, 0x3D, 0x02, 0x3D, 0x02, 0x7E, 0x12, 0x7E, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E,
		0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x0E, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x9D, 0x22, 0x9F, 0x67, 0xBF, 0x6F, 0xBF, 0x6F,
		0xBF, 0x6F, 0xBF, 0x6B, 0x7F, 0x5B, 0x5F, 0x57, 0x5F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x5F, 0x4F, 0xBE, 0x1E, 0x17, 0x4B, 0x34, 0x6F, 0x36, 0x6B, 0x36, 0x67, 0x37, 0x63, 0x37, 0x63,
		0x16, 0x5F, 0x16, 0x5F, 0xF6, 0x5A, 0xF5, 0x5A, 0xD5, 0x56, 0xD5, 0x56, 0xD5, 0x56, 0xD5, 0x5A,
		0xF5, 0x5A, 0xF5, 0x5A, 0xD5, 0x56, 0xD5, 0x5A, 0xD5, 0x56, 0xD5, 0x56, 0xD5, 0x56, 0xD5, 0x56,
		0xF6, 0x5A, 0x17, 0x5F, 0x37, 0x63, 0x57, 0x6B, 0x77, 0x6F, 0x76, 0x73, 0x96, 0x77, 0x94, 0x77,
		0x71, 0x7B, 0x71, 0x7B, 0x70, 0x7B, 0x4F, 0x7B, 0x2D, 0x77, 0x2C, 0x77, 0x2A, 0x77, 0x4A, 0x7B,
		0x4B, 0x7B, 0x6C, 0x7B, 0x8D, 0x7B, 0x8F, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xD2, 0x7F, 0xD3, 0x7F,
		0xD4, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xF6, 0x7F, 0x35, 0x67, 0x52, 0x46, 0x0F, 0x42, 0xAB, 0x3D,
		0xA9, 0x45, 0xE9, 0x4D, 0x09, 0x5A, 0x49, 0x66, 0x8A, 0x6A, 0xCA, 0x6E, 0xEB, 0x76, 0x0B, 0x77,
		0x2B, 0x77, 0x2B, 0x7B, 0x2C, 0x77, 0x2C, 0x77, 0x2D, 0x77, 0x2F, 0x73, 0x30, 0x73, 0x32, 0x6F,
		0x33, 0x6B, 0x35, 0x67, 0x56, 0x67, 0x58, 0x63, 0x9A, 0x67, 0x9C, 0x6B, 0xBC, 0x73, 0xD8, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7F, 0xD4, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F,
		0x90, 0x7F, 0x6F, 0x7B, 0x4E, 0x7B, 0x0F, 0x73, 0xB0, 0x66, 0xB2, 0x56, 0xD5, 0x56, 0x17, 0x5F,
		0x59, 0x63, 0x7A, 0x67, 0x9B, 0x6B, 0x9B, 0x6B, 0x9A, 0x6B, 0x7A, 0x67, 0x79, 0x63, 0x38, 0x5F,
		0x16, 0x5B, 0xD5, 0x56, 0x92, 0x52, 0x50, 0x4E, 0x0E, 0x4A, 0xEB, 0x45, 0xAA, 0x41, 0x68, 0x3D,
		0x47, 0x39, 0x47, 0x39, 0x26, 0x35, 0x06, 0x31, 0x05, 0x31, 0x05, 0x2D, 0xE5, 0x2C, 0xE5, 0x2C,
		0xE5, 0x2C, 0xE4, 0x30, 0x04, 0x31, 0x05, 0x31, 0x05, 0x35, 0x05, 0x35, 0x05, 0x35, 0x25, 0x39,
		0xA6, 0x51, 0x67, 0x6A, 0xEA, 0x76, 0x4B, 0x7B, 0x6C, 0x7B, 0x6D, 0x7B, 0x6C, 0x7B, 0x6C, 0x7B,
		0x4B, 0x7B, 0x2A, 0x7B, 0xEA, 0x76, 0xCA, 0x72, 0x89, 0x6E, 0x68, 0x6A, 0x48, 0x66, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5B, 0x02, 0x5A, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5C, 0x02, 0x5C, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5B, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3C, 0x02, 0x3D, 0x02, 0x3D, 0x02, 0x7E, 0x12,
		0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E,
		0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E,
		0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x7C, 0x12, 0x5C, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x9F, 0x63, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63,
		0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x3F, 0x47, 0x3B, 0x4B, 0x77, 0x6F,
		0x78, 0x6F, 0x78, 0x6F, 0x79, 0x6B, 0x79, 0x6B, 0x59, 0x6B, 0x59, 0x6B, 0x58, 0x67, 0x38, 0x67,
		0x38, 0x63, 0x38, 0x63, 0x38, 0x63, 0x38, 0x63, 0x38, 0x63, 0x38, 0x67, 0x38, 0x63, 0x38, 0x63,
		0x38, 0x63, 0x38, 0x63, 0x38, 0x63, 0x59, 0x63, 0x59, 0x67, 0x7A, 0x6B, 0x9A, 0x6F, 0xBA, 0x73,
		0xBA, 0x77, 0xBA, 0x7B, 0xDA, 0x7B, 0xD8, 0x7B, 0xB6, 0x7B, 0xB4, 0x7B, 0xB4, 0x7B, 0x93, 0x7F,
		0x92, 0x7F, 0x91, 0x7F, 0x91, 0x7F, 0x91, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB3, 0x7F, 0xB4, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F,
		0x78, 0x6B, 0xD6, 0x56, 0xB4, 0x56, 0x71, 0x52, 0x70, 0x56, 0x90, 0x5E, 0xB0, 0x66, 0xF0, 0x6E,
		0x10, 0x73, 0x30, 0x77, 0x51, 0x77, 0x51, 0x7B, 0x71, 0x7B, 0x71, 0x7B, 0x72, 0x7B, 0x72, 0x7B,
		0x73, 0x7B, 0x74, 0x77, 0x75, 0x77, 0x76, 0x73, 0x77, 0x73, 0x78, 0x6F, 0x79, 0x6F, 0x9B, 0x6B,
		0xBC, 0x6F, 0xDD, 0x73, 0xDD, 0x7B, 0xDA, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F,
		0xD8, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xB4, 0x7F, 0xB3, 0x7F, 0x73, 0x7B, 0x53, 0x77,
		0x14, 0x6B, 0xF5, 0x62, 0x17, 0x63, 0x59, 0x67, 0x7A, 0x6B, 0x9B, 0x6B, 0x9B, 0x6F, 0xBC, 0x6F,
		0x9C, 0x6F, 0x9B, 0x6F, 0x9B, 0x6B, 0x7A, 0x6B, 0x59, 0x67, 0x38, 0x67, 0x17, 0x63, 0xF5, 0x5E,
		0xD4, 0x5E, 0x92, 0x5A, 0x71, 0x56, 0x4F, 0x52, 0x2F, 0x52, 0x2E, 0x4E, 0x0E, 0x4E, 0xED, 0x49,
		0xED, 0x49, 0xED, 0x49, 0xED, 0x49, 0xED, 0x49, 0xED, 0x49, 0xED, 0x49, 0xED, 0x49, 0xED, 0x4D,
		0xED, 0x4D, 0xED, 0x4D, 0xED, 0x4D, 0xED, 0x4D, 0x4D, 0x5E, 0xCE, 0x6E, 0x30, 0x77, 0x71, 0x7B,
		0x92, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0x92, 0x7F, 0x92, 0x7F, 0x71, 0x7F,
		0x71, 0x7B, 0x50, 0x7B, 0x30, 0x77, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5A, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x9C, 0x12, 0x1D, 0x37, 0xDD, 0x2A, 0x9C, 0x12,
		0x5E, 0x4F, 0x1E, 0x3B, 0xBC, 0x16, 0x7B, 0x0A, 0x5B, 0x02, 0x5C, 0x02, 0x3C, 0x02, 0x3C, 0x02,
		0x3C, 0x02, 0x3D, 0x02, 0x3D, 0x02, 0x7D, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5C, 0x12, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E, 0x5C, 0x0E,
		0x5C, 0x0E, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x3D, 0x12, 0x3D, 0x12, 0x3D, 0x12, 0x3D, 0x12, 0x3D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x9D, 0x12, 0x7D, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0xFE, 0x3A, 0xBF, 0x6F, 0xBF, 0x6F,
		0xBF, 0x6F, 0xBF, 0x6F, 0x9F, 0x67, 0x5F, 0x57, 0x5F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x3E, 0x3F, 0xBD, 0x1A, 0xF3, 0x5E, 0x12, 0x67, 0x13, 0x67, 0x14, 0x67, 0x14, 0x67,
		0x15, 0x63, 0x15, 0x63, 0x15, 0x5F, 0xF5, 0x5A, 0xF5, 0x5A, 0xD5, 0x5A, 0xF5, 0x5A, 0xD5, 0x5A,
		0xD5, 0x56, 0xD5, 0x56, 0xD5, 0x56, 0xD4, 0x56, 0xD4, 0x56, 0xD4, 0x56, 0xD5, 0x56, 0xF6, 0x5A,
		0x37, 0x5F, 0x58, 0x63, 0x79, 0x6B, 0x99, 0x73, 0xBA, 0x77, 0xB9, 0x77, 0xB9, 0x7B, 0xB8, 0x7B,
		0xB4, 0x7B, 0x90, 0x7F, 0x8E, 0x7F, 0x8E, 0x7B, 0x8D, 0x7B, 0x8C, 0x7B, 0x6C, 0x7B, 0x8D, 0x7B,
		0x8D, 0x7B, 0x8E, 0x7F, 0x8F, 0x7F, 0xAF, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F,
		0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD5, 0x7B, 0xD4, 0x7B, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xF5, 0x7F, 0x35, 0x63, 0x52, 0x42, 0x0F, 0x42, 0xCB, 0x41,
		0xA9, 0x45, 0xE9, 0x51, 0x29, 0x5E, 0x69, 0x6A, 0xAA, 0x6E, 0xCA, 0x72, 0x0B, 0x77, 0x0B, 0x7B,
		0x2B, 0x7B, 0x2B, 0x7B, 0x2C, 0x7B, 0x2D, 0x7B, 0x2E, 0x77, 0x2F, 0x73, 0x31, 0x73, 0x32, 0x6F,
		0x13, 0x6B, 0x35, 0x67, 0x37, 0x63, 0x79, 0x63, 0x9A, 0x67, 0xBC, 0x6B, 0xDB, 0x77, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD2, 0x7F, 0xB1, 0x7F,
		0x8F, 0x7F, 0x6E, 0x7B, 0x2C, 0x7B, 0xCC, 0x72, 0x8D, 0x62, 0x6F, 0x56, 0x92, 0x52, 0xD5, 0x5A,
		0x17, 0x5B, 0x38, 0x5F, 0x58, 0x63, 0x59, 0x63, 0x59, 0x63, 0x58, 0x63, 0x38, 0x5F, 0x37, 0x5F,
		0x16, 0x5F, 0xF5, 0x5A, 0xD4, 0x56, 0x92, 0x56, 0x70, 0x52, 0x0D, 0x4A, 0xEB, 0x45, 0xA9, 0x41,
		0x88, 0x3D, 0x47, 0x3D, 0x46, 0x39, 0x26, 0x35, 0x26, 0x35, 0x05, 0x35, 0x05, 0x35, 0x05, 0x35,
		0x05, 0x35, 0x05, 0x35, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x35, 0x25, 0x39,
		0x86, 0x49, 0x07, 0x5E, 0x88, 0x6E, 0x0A, 0x77, 0x4B, 0x7B, 0x6C, 0x7B, 0x6D, 0x7B, 0x8E, 0x7B,
		0x8E, 0x7B, 0x8E, 0x7B, 0x8D, 0x7B, 0x6D, 0x7F, 0x6C, 0x7F, 0x4B, 0x7B, 0x0A, 0x77, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02,
		0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x9C, 0x16, 0x1D, 0x37,
		0x9E, 0x5F, 0xFF, 0x7B, 0x3D, 0x43, 0xBC, 0x1A, 0xDF, 0x73, 0xFF, 0x7B, 0xBF, 0x6B, 0x5E, 0x53,
		0x1D, 0x37, 0xBD, 0x1E, 0x5C, 0x0E, 0x3C, 0x02, 0x3D, 0x02, 0x3D, 0x02, 0x3D, 0x02, 0x7D, 0x12,
		0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0xBD, 0x2A, 0x3E, 0x47,
		0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B,
		0xFE, 0x3A, 0x9E, 0x1E, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x9D, 0x1E, 0xBD, 0x2E,
		0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x47, 0x3E, 0x47, 0x5C, 0x0E, 0xFD, 0x3A, 0x3E, 0x47, 0x3E, 0x47,
		0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47,
		0x3E, 0x4B, 0x9C, 0x1E, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x1E, 0x4B, 0x1E, 0x4B, 0x1E, 0x4B,
		0x1E, 0x4B, 0xDE, 0x3A, 0x3D, 0x12, 0xDE, 0x3A, 0x1E, 0x4B, 0x1E, 0x4B, 0x3E, 0x4B, 0xFE, 0x3A,
		0x7D, 0x12, 0x1E, 0x3B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x1E, 0x3B, 0x3E, 0x43, 0x9F, 0x5F,
		0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0x7F, 0x57, 0x1E, 0x3B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B,
		0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0xDD, 0x2E, 0x5D, 0x12, 0x5D, 0x12, 0xBD, 0x26,
		0x3E, 0x4B, 0x7F, 0x5F, 0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0x5E, 0x53, 0xDD, 0x2E, 0x7D, 0x12,
		0xFE, 0x3A, 0x7F, 0x5F, 0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0x1E, 0x43, 0xDE, 0x2E,
		0x3E, 0x4B, 0x5E, 0x4F, 0xDF, 0x77, 0xDF, 0x77, 0xDF, 0x77, 0xDF, 0x77, 0xDF, 0x73, 0x9F, 0x67,
		0xBF, 0x6B, 0xBF, 0x6B, 0xBF, 0x6B, 0xBF, 0x67, 0x7F, 0x57, 0xBF, 0x6B, 0x5F, 0x4F, 0x5A, 0x67,
		0x78, 0x77, 0x99, 0x77, 0x99, 0x77, 0x9A, 0x77, 0x9A, 0x73, 0x36, 0x6B, 0x15, 0x63, 0x15, 0x5F,
		0xF5, 0x5E, 0xF5, 0x5A, 0xF5, 0x5A, 0xD5, 0x5A, 0xD5, 0x5A, 0xD4, 0x56, 0xD4, 0x56, 0xD4, 0x56,
		0xD4, 0x56, 0xD4, 0x5A, 0xF5, 0x5A, 0x16, 0x5F, 0x58, 0x63, 0x79, 0x67, 0x9A, 0x6F, 0xBA, 0x73,
		0xBB, 0x77, 0xBB, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD6, 0x7B, 0xB2, 0x7F, 0xAF, 0x7F, 0xAE, 0x7F,
		0x8E, 0x7F, 0x8E, 0x7F, 0x8E, 0x7F, 0x8E, 0x7F, 0x8E, 0x7F, 0x8F, 0x7F, 0xAF, 0x7F, 0xAF, 0x7F,
		0xB0, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD5, 0x7F,
		0x35, 0x63, 0x31, 0x42, 0x0F, 0x42, 0xCB, 0x41, 0xC9, 0x49, 0xE9, 0x51, 0x29, 0x5E, 0x69, 0x6A,
		0xAA, 0x6E, 0xEA, 0x72, 0x0B, 0x77, 0x2B, 0x7B, 0x2B, 0x7B, 0x2C, 0x77, 0x2C, 0x7B, 0x2D, 0x77,
		0x2E, 0x77, 0x2F, 0x77, 0x31, 0x73, 0x32, 0x6F, 0x34, 0x6B, 0x35, 0x67, 0x37, 0x63, 0x58, 0x63,
		0x9A, 0x67, 0xBC, 0x6B, 0xDA, 0x7B, 0xD7, 0x7F, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD5, 0x7B, 0xD4, 0x7F, 0xB2, 0x7F, 0xB0, 0x7F, 0x8E, 0x7B, 0x6D, 0x7B, 0x2B, 0x7B, 0xCC, 0x6E,
		0x6D, 0x5E, 0x6E, 0x56, 0x90, 0x52, 0xB3, 0x56, 0xF5, 0x5A, 0xF6, 0x5A, 0x17, 0x5F, 0x37, 0x5F,
		0x37, 0x5F, 0x37, 0x5F, 0x37, 0x5F, 0x37, 0x5F, 0x17, 0x5F, 0x16, 0x5F, 0xF5, 0x5A, 0xB3, 0x56,
		0x91, 0x52, 0x4E, 0x4E, 0xEC, 0x49, 0xAA, 0x45, 0x88, 0x41, 0x67, 0x3D, 0x47, 0x39, 0x26, 0x39,
		0x26, 0x39, 0x26, 0x35, 0x25, 0x39, 0x25, 0x39, 0x25, 0x39, 0x25, 0x39, 0x25, 0x3D, 0x25, 0x39,
		0x25, 0x39, 0x25, 0x39, 0x25, 0x39, 0x46, 0x3D, 0x86, 0x45, 0xE7, 0x55, 0x48, 0x66, 0xC9, 0x72,
		0x0A, 0x77, 0x2B, 0x7B, 0x4C, 0x7B, 0x6C, 0x7B, 0x6C, 0x7B, 0x6D, 0x7B, 0x6D, 0x7B, 0x6D, 0x7B,
		0x6C, 0x7F, 0x6C, 0x7B, 0x4B, 0x7B, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5A, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x12, 0x9A, 0x16, 0x79, 0x06, 0xDB, 0x22,
		0xBA, 0x1A, 0x79, 0x06, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x7A, 0x0A,
		0xDB, 0x26, 0x5D, 0x4B, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3F, 0xBC, 0x1A,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x9F, 0x5F, 0x3E, 0x47,
		0xDE, 0x2E, 0x9D, 0x16, 0x5D, 0x06, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5C, 0x12, 0x3E, 0x4B, 0xDA, 0x4A, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21,
		0xDA, 0x4A, 0xDA, 0x4A, 0xD4, 0x25, 0x37, 0x36, 0x9F, 0x67, 0x7F, 0x57, 0x5D, 0x63, 0xB4, 0x25,
		0xB4, 0x21, 0x5C, 0x63, 0xBD, 0x2E, 0x3E, 0x4B, 0xDA, 0x4A, 0xB4, 0x21, 0xB4, 0x21, 0xFF, 0x7F,
		0x5C, 0x0E, 0x9F, 0x67, 0x37, 0x36, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21,
		0x5C, 0x63, 0xDA, 0x4A, 0xB4, 0x21, 0xB4, 0x21, 0xFF, 0x7F, 0xBF, 0x6B, 0x5C, 0x63, 0xB4, 0x25,
		0xB4, 0x21, 0x37, 0x36, 0x37, 0x36, 0xB4, 0x21, 0x37, 0x36, 0x9F, 0x67, 0x3D, 0x12, 0xFE, 0x42,
		0x37, 0x36, 0xB4, 0x25, 0x37, 0x36, 0xFF, 0x7F, 0x9D, 0x1A, 0xFF, 0x7B, 0x37, 0x36, 0xD4, 0x25,
		0x37, 0x36, 0xBF, 0x6B, 0xBE, 0x73, 0x16, 0x2E, 0x30, 0x11, 0xEF, 0x08, 0x52, 0x15, 0x57, 0x36,
		0xFF, 0x7F, 0xDA, 0x4A, 0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0xB4, 0x25, 0xB4, 0x25, 0xDA, 0x4A,
		0x3E, 0x4B, 0x5C, 0x12, 0x5C, 0x12, 0xFF, 0x7F, 0x1B, 0x57, 0xD4, 0x25, 0x10, 0x11, 0xEF, 0x08,
		0x93, 0x1D, 0xDA, 0x4A, 0xFF, 0x7F, 0x5E, 0x53, 0xFF, 0x7F, 0x37, 0x36, 0x10, 0x11, 0xEF, 0x08,
		0xEF, 0x08, 0xF6, 0x2D, 0xBE, 0x73, 0xBF, 0x6B, 0xDA, 0x4A, 0xD4, 0x25, 0x15, 0x3A, 0x15, 0x3E,
		0x15, 0x3E, 0x1A, 0x5F, 0xFF, 0x7B, 0xFF, 0x7B, 0x97, 0x4A, 0x15, 0x3A, 0x97, 0x4A, 0xFF, 0x7B,
		0x9F, 0x63, 0xFF, 0x7F, 0xF5, 0x31, 0xF4, 0x31, 0xF2, 0x3D, 0xF2, 0x3D, 0x13, 0x3E, 0x13, 0x3E,
		0x7C, 0x6F, 0x9A, 0x77, 0x78, 0x6F, 0x78, 0x6F, 0x58, 0x6B, 0x58, 0x6B, 0x58, 0x6B, 0x38, 0x67,
		0x38, 0x67, 0x38, 0x67, 0x37, 0x67, 0x37, 0x67, 0x37, 0x67, 0x38, 0x67, 0x58, 0x67, 0x79, 0x6B,
		0x9B, 0x6F, 0xBB, 0x73, 0xBC, 0x77, 0xDC, 0x7B, 0xDD, 0x7B, 0xDD, 0x7B, 0xDC, 0x7B, 0xDC, 0x7B,
		0xDA, 0x7F, 0xD8, 0x7F, 0xD5, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0x79, 0x6B, 0xF7, 0x56, 0xB4, 0x56, 0x71, 0x56,
		0x70, 0x5A, 0x90, 0x62, 0xD0, 0x6A, 0xF0, 0x72, 0x10, 0x77, 0x31, 0x77, 0x51, 0x7B, 0x71, 0x7B,
		0x71, 0x7B, 0x72, 0x7B, 0x72, 0x7B, 0x72, 0x7B, 0x73, 0x7B, 0x74, 0x7B, 0x76, 0x77, 0x77, 0x73,
		0x78, 0x6F, 0x79, 0x6F, 0x7A, 0x6B, 0x9B, 0x6B, 0xBC, 0x6B, 0xBD, 0x73, 0xDB, 0x7B, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F,
		0xB3, 0x7F, 0x92, 0x7F, 0x51, 0x7B, 0x11, 0x73, 0xF2, 0x66, 0xD3, 0x62, 0xF4, 0x62, 0xF5, 0x62,
		0x16, 0x63, 0x17, 0x63, 0x38, 0x63, 0x38, 0x67, 0x58, 0x67, 0x59, 0x67, 0x59, 0x6B, 0x7A, 0x6B,
		0x7A, 0x6B, 0x7A, 0x6B, 0x59, 0x6B, 0x38, 0x67, 0x16, 0x63, 0xD4, 0x5E, 0xB2, 0x5A, 0x71, 0x56,
		0x4F, 0x56, 0x2F, 0x52, 0x2E, 0x52, 0x0E, 0x4E, 0x0E, 0x4E, 0x0D, 0x4E, 0x0D, 0x52, 0x0D, 0x52,
		0x0D, 0x52, 0x0D, 0x52, 0x0D, 0x52, 0x0D, 0x52, 0x0D, 0x52, 0x0D, 0x52, 0x2E, 0x52, 0x2E, 0x52,
		0x4E, 0x56, 0x6E, 0x5E, 0xAF, 0x6A, 0xF0, 0x72, 0x30, 0x77, 0x51, 0x7B, 0x71, 0x7B, 0x71, 0x7B,
		0x71, 0x7B, 0x92, 0x7F, 0x93, 0x7F, 0x93, 0x7F, 0x93, 0x7F, 0x93, 0x7F, 0x92, 0x7F, 0x59, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5A, 0x02, 0x79, 0x06, 0xBA, 0x1A, 0x3C, 0x3F,
		0xBE, 0x6B, 0x5D, 0x4B, 0x9A, 0x16, 0xBE, 0x6B, 0xDF, 0x73, 0x7D, 0x57, 0x3C, 0x3F, 0xDB, 0x22,
		0x9A, 0x12, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x79, 0x06, 0x9A, 0x16, 0x1C, 0x3B, 0x9E, 0x5F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3F, 0xBC, 0x1A, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6F, 0x7E, 0x57, 0x3E, 0x4B,
		0xDE, 0x32, 0x9D, 0x1E, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5C, 0x12, 0x3E, 0x4B, 0xB4, 0x21,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25, 0xD4, 0x25, 0x4A, 0x00, 0xEF, 0x08,
		0x9F, 0x67, 0xFF, 0x7F, 0x52, 0x15, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xBD, 0x2A, 0x3E, 0x47,
		0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x5C, 0x0E, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00,
		0xFF, 0x7F, 0xBE, 0x73, 0xCE, 0x04, 0x4A, 0x00, 0x4A, 0x00, 0xBA, 0x4A, 0xEF, 0x08, 0x4A, 0x00,
		0xEF, 0x08, 0x9F, 0x67, 0x3D, 0x12, 0xFE, 0x42, 0xF6, 0x2D, 0x4A, 0x00, 0x4A, 0x00, 0xBE, 0x73,
		0xBF, 0x6B, 0xFF, 0x7F, 0x6C, 0x00, 0x4A, 0x00, 0x93, 0x1D, 0xBE, 0x73, 0xCE, 0x04, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25, 0x3E, 0x4B, 0x5C, 0x12, 0x5C, 0x12, 0xFF, 0x7F,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xFF, 0x7F,
		0x93, 0x1D, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xCE, 0x04, 0xFF, 0x7F,
		0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x15, 0x3A, 0xDF, 0x77, 0xFF, 0x7B,
		0x0F, 0x15, 0x4A, 0x00, 0x30, 0x15, 0xDF, 0x77, 0x7F, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xF8, 0x5E, 0x77, 0x73, 0x34, 0x6B, 0x35, 0x6B,
		0x35, 0x67, 0x15, 0x67, 0x15, 0x63, 0x15, 0x5F, 0xF4, 0x5E, 0xF4, 0x5E, 0xF4, 0x5E, 0xF4, 0x5E,
		0xF4, 0x5E, 0xF4, 0x5E, 0x15, 0x63, 0x37, 0x63, 0x78, 0x67, 0x9A, 0x6B, 0xBB, 0x73, 0xBC, 0x77,
		0xDC, 0x7B, 0xDC, 0x7B, 0xDC, 0x7B, 0xDB, 0x7B, 0xD9, 0x7B, 0xD7, 0x7B, 0xD3, 0x7F, 0xD1, 0x7F,
		0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F,
		0xB0, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F,
		0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xB3, 0x7F,
		0x36, 0x5F, 0x94, 0x4A, 0x50, 0x46, 0xCB, 0x41, 0xC9, 0x49, 0xE9, 0x55, 0x49, 0x62, 0x89, 0x6A,
		0xCA, 0x6E, 0xEA, 0x76, 0x0B, 0x77, 0x2B, 0x7B, 0x2B, 0x7B, 0x2B, 0x7B, 0x2C, 0x7B, 0x2D, 0x77,
		0x2E, 0x77, 0x30, 0x73, 0x32, 0x73, 0x33, 0x6B, 0x34, 0x67, 0x36, 0x63, 0x58, 0x63, 0x79, 0x67,
		0x9B, 0x67, 0xBB, 0x6F, 0xD8, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F,
		0xD3, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0x8E, 0x7B, 0x6C, 0x7B, 0x2B, 0x77, 0xCA, 0x6E,
		0x6B, 0x5E, 0x6D, 0x5A, 0x6E, 0x56, 0x6F, 0x52, 0x91, 0x52, 0x92, 0x52, 0x92, 0x52, 0xB3, 0x52,
		0xD4, 0x56, 0xF5, 0x5A, 0x16, 0x5F, 0x37, 0x63, 0x57, 0x63, 0x38, 0x63, 0x37, 0x63, 0xF5, 0x5E,
		0xB3, 0x56, 0x70, 0x52, 0x0D, 0x4E, 0xCA, 0x45, 0x88, 0x41, 0x67, 0x3D, 0x46, 0x3D, 0x46, 0x39,
		0x26, 0x39, 0x26, 0x3D, 0x45, 0x3D, 0x46, 0x3D, 0x45, 0x3D, 0x45, 0x3D, 0x46, 0x3D, 0x45, 0x41,
		0x46, 0x41, 0x66, 0x41, 0x66, 0x41, 0x86, 0x45, 0xA6, 0x45, 0xC7, 0x4D, 0x07, 0x56, 0x48, 0x62,
		0x69, 0x6A, 0xA9, 0x6E, 0xCA, 0x72, 0xEB, 0x72, 0x0B, 0x77, 0x2C, 0x7B, 0x6E, 0x7B, 0x6F, 0x7B,
		0x6F, 0x7B, 0x8F, 0x7B, 0x8F, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x7B, 0x0E,
		0xFC, 0x2E, 0x5D, 0x53, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4F, 0x9A, 0x16, 0xDF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBE, 0x67, 0x5D, 0x4B, 0xFB, 0x2E, 0xBA, 0x1A,
		0x7A, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x1E, 0x5D, 0x4F, 0xDF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3F, 0xBC, 0x1A,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x9F, 0x63, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x3E, 0x4B, 0x5C, 0x63, 0xF5, 0x2D, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A,
		0x5D, 0x63, 0xD4, 0x25, 0x4A, 0x00, 0xEF, 0x08, 0x9F, 0x67, 0x1B, 0x57, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xDA, 0x4A, 0xBD, 0x2A, 0x3E, 0x47, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0x5C, 0x0E, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00, 0x51, 0x15, 0xDA, 0x4A, 0xDA, 0x4A, 0xDA, 0x4A,
		0xBE, 0x73, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x51, 0x15, 0x4A, 0x00, 0x4A, 0x00,
		0xF6, 0x2D, 0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00, 0xEF, 0x08, 0x9F, 0x67, 0x3D, 0x12, 0xFE, 0x42,
		0x5C, 0x63, 0x4A, 0x00, 0x4A, 0x00, 0xAE, 0x04, 0xEF, 0x08, 0xCE, 0x04, 0x4A, 0x00, 0x4A, 0x00,
		0x1B, 0x57, 0x52, 0x15, 0x4A, 0x00, 0x4A, 0x00, 0x30, 0x11, 0xDA, 0x4A, 0x57, 0x36, 0x8D, 0x04,
		0xD4, 0x25, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xDA, 0x4A, 0xDA, 0x4A, 0x5C, 0x63,
		0x3E, 0x4B, 0x7D, 0x12, 0x7D, 0x12, 0xFF, 0x7F, 0x4A, 0x00, 0x52, 0x15, 0xDA, 0x4A, 0xDA, 0x4A,
		0x30, 0x11, 0x4A, 0x00, 0xEF, 0x08, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xCE, 0x04, 0x98, 0x42,
		0x30, 0x11, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0x5C, 0x63, 0x16, 0x2E, 0x4A, 0x00, 0x4A, 0x00,
		0x56, 0x42, 0x9D, 0x6F, 0xDF, 0x77, 0xFF, 0x7B, 0x2F, 0x19, 0x4A, 0x00, 0x30, 0x15, 0xDF, 0x77,
		0x7F, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x70, 0x21, 0xF7, 0x5E, 0xF8, 0x5E, 0xF8, 0x5E,
		0xBD, 0x77, 0x77, 0x77, 0x54, 0x6F, 0x54, 0x6F, 0x34, 0x6B, 0x34, 0x6B, 0x34, 0x67, 0x15, 0x67,
		0x14, 0x63, 0xF4, 0x62, 0xF4, 0x62, 0xF4, 0x62, 0xF4, 0x62, 0x15, 0x63, 0x36, 0x67, 0x57, 0x67,
		0x78, 0x67, 0x9A, 0x6B, 0xBB, 0x73, 0xBC, 0x77, 0xDC, 0x7B, 0xDC, 0x7B, 0xDC, 0x7B, 0xDB, 0x7B,
		0xDA, 0x7B, 0xD8, 0x7B, 0xD5, 0x7B, 0xD3, 0x7F, 0xB2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xB1, 0x7F,
		0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F,
		0xB0, 0x7F, 0x90, 0x7F, 0x90, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F,
		0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB2, 0x7B, 0xF5, 0x5A, 0x93, 0x46, 0x51, 0x4A, 0xEB, 0x45,
		0xC8, 0x49, 0x09, 0x56, 0x49, 0x62, 0x89, 0x6A, 0xCA, 0x72, 0xEB, 0x76, 0x2B, 0x7B, 0x2B, 0x7B,
		0x2C, 0x7B, 0x2B, 0x7B, 0x2C, 0x77, 0x2D, 0x7B, 0x2E, 0x77, 0x30, 0x77, 0x32, 0x6F, 0x33, 0x6B,
		0x35, 0x67, 0x37, 0x67, 0x58, 0x63, 0x7A, 0x67, 0x9B, 0x67, 0xBB, 0x6F, 0xD6, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7B, 0xD4, 0x7F, 0xD3, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xAF, 0x7F,
		0x8E, 0x7F, 0x6C, 0x7B, 0x4B, 0x7B, 0xEB, 0x72, 0xAB, 0x6A, 0xAD, 0x66, 0xAE, 0x62, 0x8F, 0x5E,
		0x8F, 0x5A, 0x70, 0x52, 0x71, 0x52, 0x92, 0x52, 0xB3, 0x52, 0xD5, 0x5A, 0x16, 0x5F, 0x37, 0x63,
		0x37, 0x63, 0x37, 0x63, 0x16, 0x5F, 0xF5, 0x5E, 0xB2, 0x5A, 0x70, 0x52, 0x0D, 0x4E, 0xCA, 0x45,
		0x88, 0x41, 0x67, 0x3D, 0x46, 0x3D, 0x46, 0x3D, 0x46, 0x3D, 0x46, 0x3D, 0x45, 0x3D, 0x45, 0x41,
		0x45, 0x41, 0x46, 0x41, 0x46, 0x41, 0x66, 0x41, 0x66, 0x45, 0x86, 0x45, 0x87, 0x45, 0xA7, 0x49,
		0xC7, 0x49, 0xC7, 0x49, 0xE7, 0x51, 0x28, 0x5A, 0x49, 0x62, 0x69, 0x66, 0x69, 0x66, 0xAA, 0x6A,
		0xEB, 0x72, 0x2D, 0x77, 0x4E, 0x7B, 0x6F, 0x7B, 0x90, 0x7B, 0x91, 0x7B, 0xB1, 0x7F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x7A, 0x06, 0xBB, 0x1E, 0x3D, 0x3F, 0x9E, 0x5F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5D, 0x4B, 0x9A, 0x16, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x6B, 0x7E, 0x5B, 0x3C, 0x3F, 0xDB, 0x26, 0x9A, 0x12,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x16, 0xBE, 0x67,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3F, 0xBC, 0x1A, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7B, 0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x9D, 0x1E, 0x1E, 0x43,
		0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x3E, 0x4B, 0xD4, 0x25, 0x4A, 0x00, 0xEF, 0x08,
		0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xBD, 0x2A, 0x3E, 0x47,
		0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x5C, 0x0E, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00,
		0xB4, 0x21, 0xDF, 0x73, 0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00,
		0xF5, 0x2D, 0x4A, 0x00, 0x4A, 0x00, 0x52, 0x15, 0xFF, 0x7F, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00,
		0xEF, 0x08, 0xFF, 0x7B, 0x9F, 0x67, 0x9F, 0x67, 0xFF, 0x7F, 0xAE, 0x04, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0xFF, 0x7F, 0x6C, 0x00, 0x4A, 0x00, 0xCE, 0x04,
		0xFF, 0x7F, 0x9F, 0x5F, 0xDF, 0x73, 0x9E, 0x6B, 0x5C, 0x63, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00,
		0xFF, 0x7F, 0x9F, 0x67, 0xBF, 0x67, 0xBF, 0x67, 0xDE, 0x2A, 0x9D, 0x12, 0x9D, 0x12, 0xFF, 0x7F,
		0x5C, 0x63, 0xFF, 0x7F, 0xBE, 0x73, 0x98, 0x42, 0xCE, 0x04, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0x16, 0x2E, 0xBF, 0x6B, 0x1B, 0x57, 0x4A, 0x00, 0x4A, 0x00, 0x16, 0x2E,
		0x3E, 0x4B, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x1A, 0x5F, 0xFF, 0x7B, 0xDF, 0x77, 0xFF, 0x7F,
		0x30, 0x19, 0x4A, 0x00, 0x30, 0x19, 0xFF, 0x7B, 0x9F, 0x63, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00,
		0xF4, 0x31, 0xFE, 0x7F, 0xDD, 0x7F, 0xDD, 0x7F, 0xDB, 0x7F, 0x97, 0x77, 0x97, 0x77, 0x97, 0x77,
		0x97, 0x73, 0x77, 0x73, 0x78, 0x73, 0x78, 0x6F, 0x57, 0x6F, 0x57, 0x6F, 0x57, 0x6F, 0x57, 0x6F,
		0x58, 0x6F, 0x78, 0x6F, 0x79, 0x6F, 0x7A, 0x6F, 0x9A, 0x6F, 0xBB, 0x73, 0xBC, 0x73, 0xDD, 0x77,
		0xDD, 0x7B, 0xDD, 0x7B, 0xDD, 0x7F, 0xDC, 0x7B, 0xDB, 0x7F, 0xDB, 0x7F, 0xD9, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F,
		0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xD4, 0x7F, 0xB6, 0x7B,
		0x38, 0x63, 0xD6, 0x56, 0xB4, 0x56, 0x71, 0x56, 0x70, 0x5A, 0xB0, 0x62, 0xD0, 0x6A, 0x10, 0x73,
		0x31, 0x77, 0x51, 0x7B, 0x71, 0x7B, 0x71, 0x7B, 0x72, 0x7B, 0x72, 0x7B, 0x72, 0x7B, 0x73, 0x7B,
		0x73, 0x7B, 0x75, 0x77, 0x76, 0x73, 0x77, 0x73, 0x78, 0x6F, 0x79, 0x6F, 0x7A, 0x6B, 0x9B, 0x6B,
		0xBC, 0x6F, 0xDC, 0x77, 0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD4, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0x92, 0x7F, 0x71, 0x7B,
		0x52, 0x7B, 0x52, 0x77, 0x53, 0x77, 0x34, 0x73, 0x34, 0x6F, 0x14, 0x6B, 0x15, 0x67, 0xF5, 0x62,
		0x16, 0x5F, 0x17, 0x63, 0x38, 0x67, 0x59, 0x67, 0x59, 0x6B, 0x59, 0x6B, 0x58, 0x6B, 0x37, 0x67,
		0x15, 0x63, 0xD4, 0x62, 0xB2, 0x5A, 0x70, 0x5A, 0x4F, 0x56, 0x2E, 0x52, 0x2E, 0x52, 0x2E, 0x52,
		0x0D, 0x52, 0x0D, 0x52, 0x2D, 0x56, 0x2D, 0x56, 0x2D, 0x56, 0x2D, 0x56, 0x2E, 0x56, 0x4E, 0x56,
		0x4E, 0x5A, 0x6E, 0x5A, 0x6E, 0x5A, 0x6E, 0x5A, 0x8F, 0x5E, 0x8F, 0x5E, 0x8F, 0x5E, 0xAF, 0x62,
		0xAF, 0x62, 0xB0, 0x62, 0xD0, 0x66, 0xF1, 0x6E, 0x32, 0x73, 0x73, 0x7B, 0x94, 0x7B, 0xB5, 0x7F,
		0xB5, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x7A, 0x0A, 0xFC, 0x32, 0x7E, 0x57, 0xDF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4B, 0x9A, 0x16, 0xBF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0xBE, 0x6B, 0x1C, 0x3B, 0x79, 0x06, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x57, 0x02, 0x57, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xDB, 0x22, 0xDF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3F, 0xBC, 0x1A,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0xDE, 0x2E, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0x3E, 0x4B, 0xB4, 0x21, 0x4A, 0x00, 0xEF, 0x08, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xD9, 0x4A, 0xDD, 0x2A, 0x3E, 0x47, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0x5C, 0x0E, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00, 0x8D, 0x00, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08,
		0xFF, 0x7F, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xF6, 0x2D,
		0xFF, 0x7F, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00, 0x6C, 0x00, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08,
		0xFF, 0x7F, 0x37, 0x36, 0x4A, 0x00, 0x6C, 0x00, 0xFF, 0x7F, 0x8D, 0x00, 0x4A, 0x00, 0x93, 0x1D,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25, 0xBF, 0x6B, 0x7D, 0x12, 0x7D, 0x1A, 0x9D, 0x1E,
		0x3E, 0x4B, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0x1B, 0x57,
		0xDE, 0x2E, 0x9D, 0x12, 0x9D, 0x12, 0xBF, 0x67, 0xBE, 0x73, 0x30, 0x11, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0xCE, 0x04, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0x1E, 0x43,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25, 0x3E, 0x4B, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00,
		0x1A, 0x5F, 0xDF, 0x73, 0xBF, 0x6F, 0xFF, 0x7B, 0x30, 0x19, 0x4A, 0x00, 0x30, 0x15, 0xDF, 0x77,
		0x7F, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xAD, 0x04, 0x0D, 0x19, 0x0D, 0x1D, 0xD0, 0x35,
		0xDC, 0x7F, 0x52, 0x77, 0x53, 0x77, 0x53, 0x73, 0x53, 0x73, 0x53, 0x6F, 0x34, 0x6F, 0x34, 0x6B,
		0x34, 0x6B, 0x14, 0x67, 0x14, 0x67, 0x14, 0x67, 0x34, 0x67, 0x35, 0x67, 0x36, 0x67, 0x57, 0x6B,
		0x58, 0x67, 0x79, 0x6B, 0x9A, 0x6F, 0xBB, 0x73, 0xBC, 0x77, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B,
		0xDA, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0x8F, 0x7F, 0x8F, 0x7F,
		0x8E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B,
		0x6E, 0x7B, 0x6E, 0x7B, 0x8E, 0x7F, 0x72, 0x77, 0xD5, 0x52, 0x72, 0x46, 0x2F, 0x46, 0xCA, 0x45,
		0xC9, 0x4D, 0x09, 0x56, 0x49, 0x62, 0xAA, 0x6E, 0xCA, 0x72, 0x0B, 0x77, 0x2B, 0x7B, 0x2B, 0x7B,
		0x4C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x2D, 0x77, 0x2E, 0x77, 0x30, 0x73, 0x32, 0x6F, 0x34, 0x6B,
		0x35, 0x67, 0x37, 0x63, 0x58, 0x63, 0x7A, 0x67, 0x9B, 0x67, 0xB9, 0x77, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7B, 0xD3, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F,
		0x8F, 0x7F, 0x8E, 0x7B, 0x6D, 0x7B, 0x6C, 0x7B, 0x4C, 0x7B, 0x4D, 0x7B, 0x4E, 0x7B, 0x2E, 0x77,
		0x0F, 0x77, 0xEF, 0x6E, 0xD0, 0x6A, 0xB0, 0x5E, 0x91, 0x56, 0x92, 0x52, 0xB3, 0x56, 0xD4, 0x5A,
		0xD4, 0x5A, 0xD4, 0x5A, 0xD3, 0x5A, 0xB1, 0x5A, 0x6F, 0x56, 0x2D, 0x52, 0xEB, 0x4D, 0xC9, 0x49,
		0x88, 0x45, 0x67, 0x41, 0x66, 0x41, 0x66, 0x41, 0x46, 0x41, 0x46, 0x41, 0x46, 0x41, 0x45, 0x41,
		0x46, 0x41, 0x66, 0x45, 0x86, 0x45, 0x86, 0x49, 0xA6, 0x49, 0xC7, 0x4D, 0xC7, 0x4D, 0xE7, 0x4D,
		0xE8, 0x51, 0x08, 0x52, 0x08, 0x52, 0x09, 0x52, 0x09, 0x52, 0x29, 0x56, 0x6A, 0x5E, 0xAB, 0x66,
		0xED, 0x72, 0x2E, 0x77, 0x6F, 0x7B, 0x91, 0x7B, 0xB2, 0x7B, 0xB3, 0x7F, 0xB4, 0x7F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5D, 0x4B, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5D, 0x4B, 0x9A, 0x16, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDF, 0x73, 0x9A, 0x16, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x57, 0x02, 0x57, 0x02,
		0x57, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xDF, 0x73,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3F, 0xBC, 0x1A, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7E, 0x12, 0xDE, 0x2E,
		0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x3E, 0x47, 0xB4, 0x21, 0x4A, 0x00, 0xEF, 0x08,
		0x8D, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0xDD, 0x2A, 0x3E, 0x47,
		0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x5C, 0x0E, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00,
		0xD3, 0x25, 0xEE, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x1B, 0x57, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0xBE, 0x73, 0x4A, 0x00, 0x4A, 0x00,
		0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x1B, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x93, 0x1D,
		0xDF, 0x73, 0x7C, 0x12, 0xBD, 0x26, 0xDD, 0x2E, 0x3E, 0x4B, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xDE, 0x2E, 0x7D, 0x12, 0x7D, 0x12, 0xFF, 0x7F,
		0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x52, 0x15, 0xBE, 0x73, 0xDA, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xDD, 0x2E, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25,
		0x3E, 0x4B, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x1A, 0x5B, 0xDF, 0x73, 0xBF, 0x6F, 0xFF, 0x7B,
		0x30, 0x1D, 0x4A, 0x00, 0x30, 0x15, 0xDF, 0x77, 0x7F, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x0D, 0x1D, 0xDC, 0x7F, 0x51, 0x77, 0x52, 0x77, 0x52, 0x73,
		0x53, 0x73, 0x53, 0x73, 0x53, 0x6F, 0x33, 0x6F, 0x33, 0x6B, 0x33, 0x6B, 0x34, 0x6B, 0x34, 0x6B,
		0x34, 0x6B, 0x35, 0x6B, 0x36, 0x6B, 0x57, 0x6B, 0x58, 0x6B, 0x78, 0x6B, 0x79, 0x6B, 0x9A, 0x6F,
		0xBB, 0x77, 0xDB, 0x7B, 0xDB, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD5, 0x7B,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F,
		0xB0, 0x7F, 0xB0, 0x7F, 0x8F, 0x7F, 0x8E, 0x7B, 0x6E, 0x7B, 0x2D, 0x7B, 0x2D, 0x77, 0x2D, 0x7B,
		0x2D, 0x77, 0x2D, 0x77, 0x4D, 0x7B, 0x4D, 0x7B, 0x4D, 0x7B, 0x4D, 0x7B, 0x6C, 0x7F, 0x31, 0x6F,
		0x93, 0x4A, 0x30, 0x42, 0x2F, 0x46, 0xEB, 0x49, 0xE9, 0x51, 0x09, 0x5A, 0x69, 0x66, 0xAA, 0x6E,
		0xEA, 0x72, 0x0B, 0x77, 0x2B, 0x7B, 0x2B, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x2D, 0x7B,
		0x2F, 0x77, 0x30, 0x73, 0x32, 0x6F, 0x34, 0x6B, 0x36, 0x67, 0x57, 0x63, 0x7A, 0x67, 0x9B, 0x6B,
		0x9C, 0x67, 0xB7, 0x77, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F,
		0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xAF, 0x7F, 0x8F, 0x7F, 0x8E, 0x7B, 0x8D, 0x7B,
		0x6D, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B, 0x4E, 0x7B, 0x2F, 0x77, 0x10, 0x73, 0xD0, 0x66,
		0xB0, 0x5E, 0x90, 0x56, 0x91, 0x52, 0x92, 0x56, 0xB2, 0x56, 0xB1, 0x56, 0x91, 0x5A, 0x6F, 0x56,
		0x4E, 0x56, 0x2C, 0x52, 0xEA, 0x51, 0xC8, 0x4D, 0xA7, 0x49, 0x86, 0x45, 0x66, 0x45, 0x66, 0x41,
		0x45, 0x41, 0x45, 0x41, 0x65, 0x45, 0x66, 0x45, 0x86, 0x49, 0xA6, 0x4D, 0xC6, 0x51, 0xC6, 0x51,
		0xE7, 0x51, 0xE7, 0x51, 0x07, 0x52, 0x08, 0x52, 0x08, 0x56, 0x28, 0x56, 0x28, 0x56, 0x29, 0x52,
		0x29, 0x56, 0x4A, 0x5E, 0x8B, 0x66, 0xED, 0x6E, 0x2E, 0x77, 0x50, 0x7B, 0x71, 0x7B, 0x92, 0x7B,
		0xB3, 0x7B, 0xB4, 0x7F, 0xB4, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x5A, 0x02, 0xDF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4B, 0x9A, 0x16, 0xBF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0xBA, 0x16, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x58, 0x02, 0x57, 0x02, 0x77, 0x0A, 0x57, 0x06, 0x78, 0x0A, 0x9A, 0x0E, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3F, 0xBC, 0x1A,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x12, 0x7D, 0x12,
		0x7C, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x5D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7E, 0x12, 0x7E, 0x12, 0xBE, 0x22, 0x3E, 0x43, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0x3E, 0x47, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x5C, 0x63, 0x4A, 0x00,
		0x4A, 0x00, 0xD9, 0x4A, 0x3E, 0x47, 0x9F, 0x67, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0x3E, 0x47, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00, 0x51, 0x15, 0xDA, 0x4A, 0xDA, 0x4A, 0xDA, 0x4A,
		0xFF, 0x7F, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00,
		0xB4, 0x21, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00, 0xEF, 0x08, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x10, 0x0D, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0xFF, 0x7F,
		0xFF, 0x7F, 0x8D, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0xFF, 0x7F, 0x9F, 0x67, 0xFF, 0x7B, 0x1B, 0x57,
		0xDA, 0x4A, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xDA, 0x4A, 0xDA, 0x4A, 0xBE, 0x73,
		0xDE, 0x2E, 0x7D, 0x12, 0x7D, 0x12, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xCE, 0x04, 0x98, 0x42,
		0xFF, 0x7F, 0xFF, 0x7F, 0x1B, 0x53, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xDD, 0x2E,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25, 0x3E, 0x4B, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00,
		0x1A, 0x5B, 0xFF, 0x7B, 0xFF, 0x7B, 0xFF, 0x7F, 0x30, 0x1D, 0x4A, 0x00, 0x30, 0x19, 0xFF, 0x7F,
		0xDF, 0x73, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x92, 0x21, 0xF9, 0x56, 0xF8, 0x5E, 0x3A, 0x67,
		0xDD, 0x7F, 0x96, 0x7B, 0x95, 0x7B, 0x96, 0x7B, 0x96, 0x77, 0x96, 0x77, 0x77, 0x77, 0x77, 0x73,
		0x77, 0x73, 0x77, 0x73, 0x77, 0x73, 0x77, 0x73, 0x78, 0x73, 0x78, 0x6F, 0x78, 0x6F, 0x79, 0x6F,
		0x9A, 0x6F, 0x9A, 0x6F, 0x9B, 0x6F, 0xBB, 0x6F, 0xBC, 0x77, 0xDC, 0x7B, 0xDC, 0x7B, 0xDB, 0x7B,
		0xDB, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD4, 0x7F, 0xD5, 0x7F, 0xB4, 0x7F, 0x93, 0x7B,
		0x73, 0x7B, 0x52, 0x77, 0x52, 0x77, 0x52, 0x77, 0x52, 0x77, 0x52, 0x77, 0x52, 0x77, 0x52, 0x7B,
		0x52, 0x7B, 0x72, 0x7B, 0x72, 0x7B, 0x55, 0x73, 0xF6, 0x5A, 0xB3, 0x52, 0x93, 0x56, 0x91, 0x5A,
		0x90, 0x5E, 0xB0, 0x66, 0xF0, 0x6E, 0x10, 0x73, 0x51, 0x7B, 0x51, 0x7B, 0x71, 0x7B, 0x72, 0x7B,
		0x72, 0x7B, 0x92, 0x7B, 0x72, 0x7B, 0x73, 0x7B, 0x74, 0x7B, 0x75, 0x77, 0x76, 0x73, 0x78, 0x6F,
		0x79, 0x6F, 0x7A, 0x6B, 0xBC, 0x6F, 0xBD, 0x73, 0xBD, 0x73, 0xB8, 0x7B, 0xD4, 0x7F, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB3, 0x7F, 0xB4, 0x7F,
		0xB4, 0x7F, 0x94, 0x7B, 0x74, 0x7B, 0x54, 0x77, 0x14, 0x6F, 0xF4, 0x66, 0xD4, 0x5E, 0xD4, 0x5E,
		0xF4, 0x62, 0xF4, 0x62, 0xD3, 0x62, 0xD3, 0x62, 0xB1, 0x62, 0xB0, 0x62, 0x8F, 0x5E, 0x6F, 0x5E,
		0x6E, 0x5A, 0x4E, 0x5A, 0x4E, 0x5A, 0x2D, 0x56, 0x2D, 0x56, 0x2D, 0x56, 0x4E, 0x5A, 0x6E, 0x62,
		0x8E, 0x66, 0xAE, 0x6A, 0xCE, 0x6A, 0xCF, 0x6E, 0xEF, 0x6E, 0xEF, 0x6E, 0xEF, 0x6E, 0xEF, 0x6A,
		0xF0, 0x6A, 0xF0, 0x6A, 0xD0, 0x66, 0xD0, 0x66, 0xF0, 0x6A, 0x11, 0x6F, 0x32, 0x73, 0x73, 0x77,
		0x94, 0x7B, 0xB5, 0x7B, 0xB6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBF, 0x6B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5D, 0x4B, 0x9A, 0x16, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDF, 0x73, 0x9A, 0x16, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x12, 0x1B, 0x37, 0x9D, 0x5F,
		0xB9, 0x1E, 0xFB, 0x32, 0xBE, 0x6B, 0x5D, 0x4B, 0xFC, 0x32, 0x7A, 0x0A, 0xBB, 0x1E, 0xDF, 0x73,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x1C, 0x3F, 0xBB, 0x1A, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x5D, 0x12, 0x5D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x3F, 0x4B, 0x5D, 0x63,
		0xF6, 0x2D, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0x5C, 0x63, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x51, 0x15, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0xB4, 0x21, 0xB4, 0x21,
		0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0xB4, 0x21, 0xB4, 0x21, 0xD9, 0x4A, 0xEF, 0x08, 0x4A, 0x00,
		0xEF, 0x08, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0x5C, 0x63, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00,
		0xD3, 0x25, 0x51, 0x15, 0x4A, 0x00, 0x4A, 0x00, 0xB4, 0x21, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00,
		0x8D, 0x00, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0x5C, 0x63, 0x7F, 0x5F, 0x37, 0x36, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x93, 0x1D, 0xDF, 0x73, 0xDF, 0x73, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00,
		0xEF, 0x08, 0x98, 0x42, 0x93, 0x1D, 0x6C, 0x00, 0xD4, 0x25, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00,
		0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0xDA, 0x4A, 0x3E, 0x4B, 0x7D, 0x12, 0x7D, 0x12, 0xFF, 0x7F,
		0xEF, 0x08, 0x4A, 0x00, 0xCE, 0x04, 0x98, 0x42, 0x16, 0x2E, 0xEF, 0x08, 0xEF, 0x08, 0xDA, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xFE, 0x2E, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25,
		0x5C, 0x63, 0x16, 0x2E, 0x4A, 0x00, 0x4A, 0x00, 0x36, 0x36, 0x1A, 0x5F, 0x15, 0x3A, 0x15, 0x3A,
		0xCD, 0x0C, 0x4A, 0x00, 0xAD, 0x08, 0x15, 0x36, 0x15, 0x36, 0x7D, 0x6B, 0x4A, 0x00, 0x4A, 0x00,
		0x0F, 0x11, 0xD4, 0x25, 0xF1, 0x3D, 0xF1, 0x3D, 0x7B, 0x6F, 0x74, 0x7B, 0x50, 0x77, 0x51, 0x77,
		0x51, 0x73, 0x52, 0x73, 0x32, 0x73, 0x33, 0x6F, 0x33, 0x6F, 0x33, 0x6B, 0x33, 0x6B, 0x34, 0x6B,
		0x34, 0x6B, 0x35, 0x67, 0x35, 0x67, 0x36, 0x67, 0x57, 0x67, 0x57, 0x67, 0x58, 0x67, 0x78, 0x6B,
		0x98, 0x73, 0xB9, 0x77, 0xB9, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B,
		0xD4, 0x7B, 0xD4, 0x7B, 0xD4, 0x7B, 0xD3, 0x7F, 0xD3, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F,
		0xB0, 0x7F, 0xB0, 0x7F, 0x8F, 0x7B, 0x6D, 0x7B, 0x2D, 0x77, 0x0C, 0x73, 0xCC, 0x6E, 0xEC, 0x6E,
		0xEC, 0x6E, 0xCC, 0x6E, 0xCB, 0x6E, 0xCC, 0x6E, 0xCB, 0x6E, 0xEB, 0x6E, 0xEB, 0x72, 0xF0, 0x66,
		0x93, 0x4A, 0x0F, 0x42, 0xCB, 0x41, 0xEA, 0x49, 0x09, 0x56, 0x49, 0x62, 0x69, 0x6A, 0xAA, 0x6E,
		0xEA, 0x76, 0x0B, 0x77, 0x2B, 0x7B, 0x2C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x2D, 0x7B, 0x2E, 0x7B,
		0x2F, 0x77, 0x31, 0x73, 0x33, 0x6F, 0x35, 0x6B, 0x36, 0x67, 0x57, 0x63, 0x7A, 0x67, 0xBC, 0x6B,
		0xBB, 0x6F, 0x92, 0x7B, 0x8E, 0x7F, 0x8F, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F,
		0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F,
		0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0x90, 0x7F, 0x90, 0x7B, 0x70, 0x7B, 0x30, 0x77,
		0xCF, 0x6A, 0x6E, 0x5E, 0x2D, 0x4E, 0x2D, 0x4E, 0x2C, 0x52, 0x2C, 0x56, 0x2B, 0x56, 0x2A, 0x56,
		0x09, 0x56, 0x08, 0x56, 0xE7, 0x55, 0xC7, 0x55, 0xC6, 0x51, 0xA6, 0x4D, 0x86, 0x4D, 0x86, 0x49,
		0x66, 0x49, 0xA6, 0x4D, 0xE6, 0x59, 0x27, 0x62, 0x68, 0x6A, 0xA8, 0x6E, 0xC9, 0x72, 0xE9, 0x72,
		0xE9, 0x72, 0xE9, 0x72, 0xEA, 0x72, 0xCA, 0x72, 0xCA, 0x6E, 0xCA, 0x6E, 0xAA, 0x6A, 0xAA, 0x6A,
		0xCB, 0x6A, 0xED, 0x72, 0x0E, 0x73, 0x4F, 0x77, 0x70, 0x7B, 0x91, 0x7B, 0x93, 0x7B, 0xB4, 0x7F,
		0xB4, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4B, 0x9A, 0x16, 0xBF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9A, 0x16, 0x79, 0x0A, 0xDB, 0x26,
		0x5D, 0x4B, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xDA, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x1C, 0x3F, 0xBA, 0x1A, 0xDF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1C, 0x3F, 0xBB, 0x1A,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12,
		0x7E, 0x12, 0x7D, 0x12, 0x3E, 0x4B, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0xB4, 0x21, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x6B, 0x00, 0xBE, 0x73, 0xFF, 0x7F, 0x4A, 0x00,
		0x4A, 0x00, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xB4, 0x21, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0xD9, 0x4A, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x6B, 0x00,
		0x5C, 0x63, 0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0xBA, 0x4A, 0xDE, 0x3A, 0xBE, 0x73, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x1B, 0x57, 0x5E, 0x4F,
		0x3E, 0x4B, 0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0xD4, 0x25, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25,
		0x3E, 0x4B, 0x7D, 0x12, 0x7D, 0x12, 0x9F, 0x67, 0x1B, 0x57, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0xDE, 0x2E,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x25, 0xD4, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xB2, 0x29, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xFA, 0x56, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0xF7, 0x5E, 0x73, 0x7B, 0x50, 0x77, 0x30, 0x77, 0x31, 0x73, 0x51, 0x73, 0x32, 0x6F, 0x32, 0x6F,
		0x32, 0x6F, 0x33, 0x6B, 0x33, 0x6B, 0x34, 0x6B, 0x34, 0x67, 0x35, 0x67, 0x35, 0x67, 0x36, 0x67,
		0x36, 0x67, 0x37, 0x63, 0x57, 0x67, 0x77, 0x6F, 0x97, 0x73, 0xB7, 0x7B, 0xB7, 0x7B, 0xD7, 0x7B,
		0xD6, 0x7B, 0xD5, 0x7B, 0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD3, 0x7B, 0xD3, 0x7F,
		0xD3, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xAF, 0x7F, 0x8E, 0x7B, 0x6E, 0x7B,
		0x4D, 0x7B, 0x0C, 0x77, 0xEC, 0x72, 0xEC, 0x6E, 0xEC, 0x6E, 0xCB, 0x6E, 0xCB, 0x6E, 0xCB, 0x6E,
		0xCB, 0x6E, 0xCB, 0x6A, 0xCB, 0x6E, 0xF1, 0x62, 0x95, 0x4A, 0x2F, 0x46, 0xCB, 0x45, 0xCA, 0x49,
		0x09, 0x56, 0x49, 0x62, 0x89, 0x6A, 0xCA, 0x72, 0x0B, 0x77, 0x2B, 0x7B, 0x2C, 0x7B, 0x4C, 0x7F,
		0x4C, 0x7B, 0x4D, 0x7B, 0x4D, 0x7B, 0x4E, 0x7B, 0x50, 0x77, 0x31, 0x73, 0x33, 0x6F, 0x35, 0x6B,
		0x36, 0x67, 0x57, 0x63, 0x7A, 0x67, 0xBC, 0x6B, 0x9A, 0x6F, 0x6F, 0x7B, 0x6C, 0x7B, 0x8E, 0x7B,
		0x8F, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F,
		0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F,
		0xB1, 0x7F, 0xB1, 0x7F, 0x91, 0x7B, 0x50, 0x7B, 0xEF, 0x72, 0x8E, 0x62, 0x2D, 0x52, 0xEB, 0x4D,
		0xEA, 0x4D, 0xE9, 0x51, 0x08, 0x56, 0x08, 0x5A, 0x07, 0x5A, 0x07, 0x5E, 0x06, 0x5E, 0xE6, 0x59,
		0xE6, 0x59, 0xC6, 0x55, 0xA6, 0x51, 0x86, 0x49, 0xA6, 0x4D, 0xE6, 0x59, 0x27, 0x66, 0x88, 0x6E,
		0xC9, 0x72, 0x0A, 0x77, 0x2A, 0x7B, 0x4B, 0x7B, 0x4B, 0x7B, 0x2B, 0x7B, 0x2B, 0x7B, 0x2B, 0x7B,
		0x2B, 0x77, 0x0B, 0x77, 0x0B, 0x73, 0x0C, 0x73, 0x0C, 0x73, 0x2E, 0x77, 0x2F, 0x77, 0x50, 0x7B,
		0x70, 0x7B, 0x91, 0x7B, 0x92, 0x7B, 0xB3, 0x7F, 0xB4, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5E, 0x4B, 0x9B, 0x16, 0xBE, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDF, 0x6F, 0x9A, 0x12, 0x3C, 0x3F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0xBB, 0x1E, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3C, 0x43, 0xBA, 0x1A, 0xBF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x1C, 0x3F, 0xBB, 0x1A, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7E, 0x12,
		0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x3E, 0x4B, 0xDA, 0x4A,
		0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0xDA, 0x4A, 0xDA, 0x4A, 0xB4, 0x21, 0xB4, 0x21,
		0x78, 0x3E, 0xFF, 0x7B, 0xFF, 0x7F, 0xB4, 0x21, 0xB4, 0x21, 0x5C, 0x63, 0xB4, 0x21, 0xB4, 0x21,
		0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xDA, 0x4A, 0x37, 0x36, 0xB4, 0x21,
		0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0x5C, 0x63, 0xDA, 0x4A, 0xB4, 0x21, 0xB4, 0x21,
		0xB4, 0x21, 0xB4, 0x21, 0xDA, 0x4A, 0xBE, 0x73, 0xFF, 0x7B, 0x9F, 0x67, 0x37, 0x36, 0xB4, 0x21,
		0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0xB4, 0x21, 0x5C, 0x63, 0x9D, 0x2A, 0xFF, 0x7F, 0x37, 0x36,
		0xD4, 0x21, 0xD4, 0x21, 0xFF, 0x7F, 0xBC, 0x26, 0x5C, 0x0E, 0x9F, 0x67, 0xFF, 0x7F, 0x98, 0x3E,
		0xD4, 0x21, 0xD4, 0x21, 0xD4, 0x25, 0xDA, 0x4A, 0xFF, 0x7F, 0xDA, 0x4A, 0xD4, 0x25, 0xD4, 0x25,
		0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0xDA, 0x4A, 0x3E, 0x4B, 0x7D, 0x12, 0x7D, 0x12, 0xBD, 0x26,
		0xFF, 0x7F, 0x5C, 0x63, 0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0x57, 0x36, 0xBE, 0x73, 0x5D, 0x63,
		0xD4, 0x25, 0xD4, 0x25, 0x5D, 0x63, 0xDE, 0x2E, 0xFF, 0x7F, 0xD4, 0x25, 0xD4, 0x25, 0xDA, 0x4A,
		0xDA, 0x4A, 0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0xD4, 0x25, 0xB8, 0x4E, 0x15, 0x3E, 0x15, 0x3E,
		0x15, 0x3E, 0x15, 0x3E, 0x15, 0x3A, 0x15, 0x3A, 0x15, 0x3A, 0x7D, 0x6F, 0x15, 0x3A, 0x15, 0x3A,
		0x15, 0x3A, 0xF5, 0x31, 0xF4, 0x31, 0x12, 0x3E, 0x7C, 0x6F, 0x97, 0x7B, 0x74, 0x7B, 0x75, 0x77,
		0x75, 0x77, 0x76, 0x77, 0x76, 0x73, 0x76, 0x73, 0x56, 0x73, 0x57, 0x73, 0x57, 0x6F, 0x57, 0x6F,
		0x57, 0x6F, 0x58, 0x6B, 0x58, 0x6B, 0x58, 0x6B, 0x79, 0x6F, 0x79, 0x6F, 0x99, 0x73, 0xB9, 0x77,
		0xB9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F,
		0xD5, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB3, 0x7B, 0x93, 0x7F, 0x72, 0x7B, 0x72, 0x7B, 0x52, 0x7B,
		0x52, 0x7B, 0x52, 0x77, 0x52, 0x77, 0x51, 0x77, 0x31, 0x77, 0x51, 0x77, 0x51, 0x7B, 0x35, 0x6B,
		0xD6, 0x56, 0x92, 0x56, 0x70, 0x56, 0x6F, 0x5A, 0x8F, 0x62, 0xAF, 0x66, 0xCF, 0x6A, 0xEF, 0x6E,
		0xEF, 0x72, 0x10, 0x73, 0x30, 0x77, 0x51, 0x77, 0x51, 0x7B, 0x52, 0x7B, 0x72, 0x7B, 0x73, 0x7B,
		0x74, 0x7B, 0x96, 0x77, 0x98, 0x73, 0x99, 0x73, 0x7A, 0x6F, 0x9A, 0x6B, 0xBC, 0x6F, 0xDE, 0x73,
		0xBB, 0x77, 0x72, 0x7B, 0x71, 0x7B, 0x92, 0x7F, 0xB3, 0x7F, 0xB4, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F,
		0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xB6, 0x7F, 0xB5, 0x7B,
		0x75, 0x7B, 0x13, 0x6F, 0xB2, 0x62, 0x91, 0x5E, 0x8F, 0x5E, 0x8F, 0x62, 0x8E, 0x66, 0xAE, 0x6A,
		0xAE, 0x6A, 0xCE, 0x6E, 0xCE, 0x6E, 0xAE, 0x6A, 0xAE, 0x6A, 0x8E, 0x66, 0x6E, 0x62, 0x6E, 0x5E,
		0x6E, 0x62, 0xCE, 0x6E, 0x0F, 0x73, 0x50, 0x7B, 0x71, 0x7B, 0x91, 0x7F, 0x92, 0x7F, 0xB2, 0x7F,
		0xB2, 0x7F, 0x92, 0x7F, 0x92, 0x7F, 0x92, 0x7F, 0x92, 0x7F, 0x92, 0x7B, 0x72, 0x7B, 0x72, 0x7B,
		0x73, 0x7B, 0x73, 0x7B, 0x94, 0x7B, 0x94, 0x7B, 0x95, 0x7B, 0xB6, 0x7F, 0xB6, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5E, 0x4B, 0x9C, 0x16, 0xBF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6F, 0x9A, 0x12, 0x7D, 0x57, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x3C, 0x3F, 0xBA, 0x1A, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3C, 0x43, 0xBB, 0x1A,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x9D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7D, 0x12, 0x5C, 0x12, 0xDD, 0x2E, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B,
		0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0xDD, 0x32, 0x3E, 0x47, 0x3E, 0x47,
		0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47,
		0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47,
		0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0xDD, 0x2A,
		0x7C, 0x16, 0xFD, 0x3A, 0x1E, 0x47, 0x1E, 0x47, 0x1E, 0x47, 0x1E, 0x47, 0x1E, 0x47, 0x1E, 0x47,
		0x1E, 0x47, 0x7D, 0x1E, 0xFD, 0x3A, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0xDD, 0x2A,
		0x7C, 0x16, 0x5C, 0x0E, 0xFD, 0x32, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47,
		0xDD, 0x2E, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B,
		0xDD, 0x2E, 0xBD, 0x26, 0xDD, 0x2E, 0xDD, 0x2E, 0xDD, 0x2E, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B,
		0x3E, 0x4B, 0x3E, 0x4B, 0x1E, 0x3F, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0xBE, 0x22,
		0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B, 0x3E, 0x4B,
		0x3E, 0x4B, 0x9F, 0x63, 0xFF, 0x77, 0xFF, 0x77, 0xFF, 0x77, 0xFF, 0x77, 0xDF, 0x73, 0xBF, 0x6B,
		0xBF, 0x6B, 0xBF, 0x6B, 0xBF, 0x6B, 0xBF, 0x6B, 0xBF, 0x6B, 0x9F, 0x5F, 0x5D, 0x53, 0x98, 0x77,
		0x97, 0x7B, 0x73, 0x77, 0x54, 0x77, 0x31, 0x73, 0x31, 0x73, 0x11, 0x6F, 0x54, 0x73, 0x55, 0x6F,
		0x56, 0x6F, 0x56, 0x6F, 0x56, 0x6F, 0x14, 0x67, 0xF4, 0x62, 0x14, 0x63, 0x15, 0x63, 0x35, 0x67,
		0x56, 0x6F, 0x76, 0x73, 0x96, 0x77, 0xB6, 0x7B, 0xB6, 0x7B, 0xB6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD4, 0x7B, 0xD4, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD2, 0x7F, 0xD2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0x8F, 0x7F, 0x8F, 0x7B, 0x8E, 0x7B,
		0x6D, 0x7B, 0x4D, 0x7B, 0x4D, 0x7B, 0x2D, 0x7B, 0x2C, 0x7B, 0x2C, 0x7B, 0x2C, 0x77, 0x4C, 0x7B,
		0x4C, 0x7F, 0x0C, 0x7B, 0xCB, 0x6E, 0x0B, 0x52, 0x89, 0x3D, 0x87, 0x45, 0xA7, 0x49, 0xC7, 0x51,
		0xE7, 0x55, 0x07, 0x5A, 0x27, 0x5E, 0x48, 0x62, 0x48, 0x66, 0x48, 0x66, 0x68, 0x66, 0x68, 0x6A,
		0x68, 0x6A, 0x69, 0x66, 0x69, 0x66, 0x6A, 0x66, 0x6B, 0x66, 0x8D, 0x66, 0xD0, 0x66, 0x15, 0x67,
		0x58, 0x67, 0x79, 0x67, 0x9B, 0x67, 0xBD, 0x6F, 0x77, 0x6F, 0xEB, 0x72, 0x0B, 0x77, 0x4C, 0x7B,
		0x6E, 0x7B, 0x8E, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xB2, 0x7F, 0xD2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7F, 0xD4, 0x7B, 0xD4, 0x7B, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xB3, 0x7F, 0x92, 0x7B, 0x51, 0x77, 0xCF, 0x6A, 0x4D, 0x56, 0x0A, 0x52,
		0x09, 0x56, 0x08, 0x5A, 0x27, 0x62, 0x47, 0x62, 0x47, 0x66, 0x67, 0x6A, 0x67, 0x6A, 0x47, 0x66,
		0x27, 0x62, 0x06, 0x5E, 0xE6, 0x59, 0xC6, 0x51, 0x07, 0x5E, 0x88, 0x6E, 0xE9, 0x76, 0x4B, 0x7B,
		0x6C, 0x7B, 0x8D, 0x7B, 0x8E, 0x7F, 0x8E, 0x7F, 0x8E, 0x7F, 0x8E, 0x7F, 0x8E, 0x7B, 0x8E, 0x7B,
		0x6E, 0x7B, 0x6D, 0x7B, 0x6D, 0x7B, 0x4D, 0x7B, 0x4E, 0x7B, 0x4F, 0x7B, 0x4F, 0x7B, 0x70, 0x7B,
		0x71, 0x7B, 0x91, 0x7B, 0x92, 0x7B, 0x93, 0x7F, 0xB3, 0x7F, 0xB4, 0x7B, 0xB4, 0x7B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5E, 0x4B, 0x9C, 0x16, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xBF, 0x6F, 0x9A, 0x12, 0x5D, 0x53, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3C, 0x43, 0xBA, 0x1A, 0xBF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x1C, 0x37, 0x9A, 0x0E, 0xBE, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDF, 0x77, 0x9E, 0x16, 0x9E, 0x16, 0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12, 0x7E, 0x12,
		0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x7C, 0x12, 0xDD, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xDD, 0x2A, 0x5C, 0x0E, 0x5C, 0x0E, 0xDD, 0x2A, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x3A, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7E, 0x5F,
		0xFF, 0x7F, 0xBE, 0x73, 0xD9, 0x4A, 0xD9, 0x4A, 0x1B, 0x57, 0xFF, 0x7F, 0xBF, 0x6B, 0xDD, 0x2A,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5C, 0x0E, 0x5C, 0x0E, 0xBD, 0x2A, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xFF, 0x7F,
		0x1B, 0x57, 0xD9, 0x4A, 0xD9, 0x4A, 0xBE, 0x73, 0xFF, 0x7F, 0x5E, 0x4F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDA, 0x4A, 0xDA, 0x4A, 0xDA, 0x4A, 0xFF, 0x7F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x9F, 0x67, 0xFF, 0x7F, 0x1B, 0x57, 0xDA, 0x4A,
		0xDA, 0x4A, 0xBE, 0x73, 0xFF, 0x7F, 0x5E, 0x53, 0x9F, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x3E, 0x4B, 0x9F, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDE, 0x2A, 0x7F, 0x57, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x7F, 0x57, 0x7F, 0x57,
		0x9F, 0x5F, 0xFF, 0x7B, 0xFF, 0x7F, 0x3A, 0x63, 0xF7, 0x5E, 0xF7, 0x5E, 0xBD, 0x77, 0xFF, 0x7F,
		0x98, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0x39, 0x67, 0xF8, 0x5A, 0xF8, 0x5A, 0xBD, 0x77, 0xFF, 0x7F,
		0x7A, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xD7, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFE, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F,
		0xB1, 0x7F, 0xB0, 0x7F, 0x8F, 0x7F, 0x8F, 0x7F, 0x8E, 0x7B, 0x6E, 0x7B, 0x6D, 0x7B, 0x6D, 0x7B,
		0x4D, 0x7B, 0x4D, 0x7B, 0x4D, 0x7F, 0x2C, 0x7B, 0x8A, 0x66, 0xC9, 0x49, 0x88, 0x3D, 0x47, 0x39,
		0x67, 0x41, 0xA7, 0x49, 0xC7, 0x51, 0xE7, 0x55, 0x07, 0x5E, 0x27, 0x62, 0x48, 0x66, 0x68, 0x6A,
		0x88, 0x6A, 0x88, 0x6E, 0x88, 0x6E, 0x88, 0x6E, 0x89, 0x6A, 0x68, 0x6A, 0x69, 0x6A, 0x49, 0x66,
		0x29, 0x5E, 0x2A, 0x5A, 0x2B, 0x56, 0x2D, 0x56, 0x91, 0x56, 0x37, 0x5F, 0x9B, 0x67, 0xDE, 0x73,
		0x75, 0x6F, 0xCA, 0x6E, 0x0B, 0x77, 0x4C, 0x7B, 0x6D, 0x7B, 0x8E, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F,
		0xB2, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD4, 0x7B, 0xB4, 0x7F, 0xB3, 0x7F,
		0x71, 0x7B, 0xF0, 0x6E, 0x4D, 0x5A, 0x0B, 0x52, 0x09, 0x5A, 0x28, 0x5E, 0x48, 0x66, 0x68, 0x6A,
		0x88, 0x6E, 0x88, 0x6E, 0x88, 0x6E, 0x67, 0x6A, 0x47, 0x6A, 0x27, 0x62, 0xE7, 0x5D, 0xE7, 0x59,
		0x48, 0x66, 0xC9, 0x72, 0x2B, 0x7B, 0x6C, 0x7B, 0x8E, 0x7B, 0xAF, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F,
		0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xAF, 0x7F, 0x8F, 0x7B, 0x8E, 0x7B, 0x6E, 0x7B, 0x6E, 0x7B,
		0x6E, 0x7B, 0x6F, 0x7B, 0x70, 0x7B, 0x70, 0x7B, 0x71, 0x7B, 0x92, 0x7B, 0x92, 0x7B, 0x92, 0x7B,
		0xB3, 0x7B, 0xB3, 0x7F, 0xB3, 0x7F, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5E, 0x4F, 0x9C, 0x16, 0xDF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6F, 0x9A, 0x12, 0x5D, 0x53, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x3C, 0x43, 0xBA, 0x1A, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x6B, 0x1C, 0x3F, 0x7A, 0x0A, 0x59, 0x02,
		0xBB, 0x1A, 0x5D, 0x4B, 0x9E, 0x63, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x9E, 0x16, 0x9E, 0x16,
		0x9E, 0x16, 0x9E, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x5C, 0x12, 0x7C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12, 0x5C, 0x12,
		0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0xDD, 0x2A, 0x5C, 0x0E,
		0x5C, 0x0E, 0xDD, 0x2A, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0xFF, 0x7B, 0x37, 0x36,
		0x4A, 0x00, 0x4A, 0x00, 0x10, 0x0D, 0xFF, 0x7F, 0xD4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xCE, 0x04, 0x1B, 0x57, 0xDF, 0x73, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0x5C, 0x0E, 0x5C, 0x0E, 0xDD, 0x2A, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xEF, 0x08, 0x37, 0x36, 0x6B, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x93, 0x1D, 0xFF, 0x7F, 0x93, 0x1D, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x6B, 0x00,
		0x1B, 0x57, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xBF, 0x6B,
		0xBE, 0x73, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x93, 0x1D, 0xFF, 0x7F,
		0x9F, 0x67, 0xEF, 0x08, 0x4A, 0x00, 0xD4, 0x25, 0x3E, 0x4B, 0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00,
		0x4A, 0x00, 0x98, 0x42, 0x4A, 0x00, 0x4A, 0x00, 0x1B, 0x57, 0x7F, 0x57, 0xDF, 0x73, 0x52, 0x15,
		0x4A, 0x00, 0x6C, 0x00, 0x1A, 0x5B, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x30, 0x19, 0xFF, 0x7B, 0x9F, 0x63, 0x9F, 0x63, 0xFF, 0x7B, 0x3B, 0x63, 0xAD, 0x08, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xF2, 0x3D, 0xFF, 0x7F, 0x75, 0x4E, 0x8B, 0x04, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xF3, 0x39, 0xFF, 0x7F, 0x13, 0x3E, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x2E, 0x1D, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x19, 0x5F,
		0xFE, 0x7F, 0x5A, 0x67, 0x8B, 0x04, 0x4A, 0x00, 0xCC, 0x0C, 0xBD, 0x77, 0xD8, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD4, 0x7F,
		0xB4, 0x7F, 0xB4, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0x92, 0x7F, 0xD2, 0x62,
		0x51, 0x4E, 0x51, 0x4A, 0x30, 0x4E, 0x30, 0x4E, 0x4F, 0x52, 0x4F, 0x56, 0x6F, 0x5E, 0x8F, 0x62,
		0xAF, 0x66, 0xCF, 0x6A, 0xEF, 0x6E, 0x10, 0x73, 0x10, 0x77, 0x30, 0x77, 0x30, 0x77, 0x30, 0x77,
		0x30, 0x77, 0x10, 0x77, 0x10, 0x73, 0xF0, 0x72, 0xF0, 0x6E, 0xD1, 0x6A, 0xB1, 0x66, 0xB1, 0x62,
		0xB2, 0x5E, 0xD4, 0x5E, 0x38, 0x63, 0xBD, 0x6F, 0x97, 0x77, 0x50, 0x7B, 0x71, 0x7B, 0x92, 0x7B,
		0x92, 0x7F, 0xB3, 0x7F, 0xD4, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0x96, 0x7B, 0x54, 0x77, 0xF3, 0x66, 0xB1, 0x62,
		0xB0, 0x66, 0xCF, 0x6A, 0xEF, 0x6E, 0xEF, 0x72, 0x0F, 0x77, 0x0F, 0x77, 0x0F, 0x77, 0x0F, 0x73,
		0xEF, 0x72, 0xCF, 0x6E, 0xAE, 0x6A, 0xAF, 0x6A, 0x0F, 0x73, 0x71, 0x7B, 0x92, 0x7F, 0xB3, 0x7F,
		0xB4, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F,
		0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0x94, 0x7B, 0x95, 0x7B, 0x95, 0x7B, 0x96, 0x7B,
		0xB6, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B, 0xB7, 0x7F, 0xB7, 0x7F, 0xD7, 0x7F, 0xB7, 0x7F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5D, 0x4B, 0x9B, 0x0E, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xBF, 0x6F, 0x9A, 0x12, 0x5D, 0x53, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3C, 0x43, 0xBA, 0x1A, 0xBF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x7D, 0x53, 0xDB, 0x2A,
		0x9A, 0x0E, 0x9A, 0x16, 0x1C, 0x3F, 0x7D, 0x53, 0xDB, 0x2A, 0x7A, 0x06, 0x7A, 0x0A, 0xBC, 0x1A,
		0xFD, 0x2E, 0x3E, 0x4B, 0xBF, 0x67, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDF, 0x77, 0x9E, 0x16, 0x9E, 0x16, 0x9D, 0x16, 0x9D, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0x7C, 0x12, 0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x5C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0xD9, 0x4A, 0x1D, 0x43, 0xDD, 0x2A, 0x9C, 0x1E, 0xDD, 0x2A, 0xD9, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0xD9, 0x4A, 0x1B, 0x57, 0x6B, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0xBE, 0x73, 0x37, 0x36,
		0x4A, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0xBE, 0x73,
		0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x5C, 0x0E, 0x5C, 0x0E, 0xDD, 0x2A, 0xD9, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0x93, 0x1D, 0xD4, 0x21, 0x4A, 0x00,
		0x8D, 0x00, 0x10, 0x0D, 0x10, 0x0D, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0xEF, 0x08, 0x4A, 0x00,
		0xEF, 0x08, 0x93, 0x1D, 0x8D, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0x1B, 0x57, 0xEF, 0x08, 0x4A, 0x00,
		0x4A, 0x00, 0x8D, 0x00, 0x93, 0x1D, 0xFF, 0x7F, 0xCE, 0x04, 0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08,
		0x8D, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xB4, 0x21, 0xFF, 0x7B, 0xEF, 0x08, 0x4A, 0x00, 0xB4, 0x25,
		0xDF, 0x73, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x6C, 0x00, 0x4A, 0x00,
		0x52, 0x15, 0xDA, 0x4A, 0xDA, 0x4A, 0x8D, 0x04, 0x4A, 0x00, 0x52, 0x15, 0xFA, 0x56, 0x4A, 0x00,
		0x4A, 0x00, 0xEE, 0x14, 0x30, 0x1D, 0x30, 0x19, 0xD3, 0x2D, 0xDF, 0x77, 0x7F, 0x57, 0x7F, 0x57,
		0xFF, 0x7F, 0x30, 0x15, 0x4A, 0x00, 0x4A, 0x00, 0xEC, 0x14, 0x8B, 0x04, 0x4A, 0x00, 0x4A, 0x00,
		0x39, 0x67, 0xF1, 0x39, 0x4A, 0x00, 0xCC, 0x10, 0x6F, 0x29, 0x0D, 0x19, 0x4A, 0x00, 0x4A, 0x00,
		0x7C, 0x6F, 0x12, 0x3E, 0x4A, 0x00, 0x4A, 0x00, 0x2E, 0x1D, 0x2E, 0x1D, 0x2E, 0x1D, 0xF1, 0x35,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x18, 0x5F, 0xBD, 0x77, 0xED, 0x14, 0x4A, 0x00, 0x8B, 0x04,
		0x5A, 0x67, 0xFE, 0x7F, 0xD5, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F,
		0xAF, 0x7F, 0x8F, 0x7F, 0xF1, 0x62, 0x74, 0x42, 0x95, 0x46, 0x72, 0x46, 0xEE, 0x3D, 0xAB, 0x39,
		0x89, 0x39, 0x88, 0x3D, 0x88, 0x41, 0xA9, 0x49, 0xC9, 0x4D, 0xE9, 0x55, 0x29, 0x5E, 0x49, 0x62,
		0x69, 0x66, 0x89, 0x6A, 0xAA, 0x6E, 0xCA, 0x72, 0xCA, 0x72, 0xCB, 0x72, 0xCB, 0x72, 0xCB, 0x72,
		0xAB, 0x6E, 0x8C, 0x66, 0x6C, 0x62, 0x4C, 0x5A, 0x2D, 0x56, 0x2E, 0x4E, 0x4F, 0x4E, 0xB4, 0x52,
		0xF3, 0x62, 0x2E, 0x77, 0x4B, 0x7F, 0x6C, 0x7B, 0x8E, 0x7B, 0x8E, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F,
		0xB2, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xB5, 0x7B, 0xB3, 0x7B,
		0x72, 0x7B, 0x10, 0x73, 0x8E, 0x5E, 0x2C, 0x56, 0x4A, 0x5E, 0x69, 0x66, 0x88, 0x6A, 0xA8, 0x6E,
		0xA9, 0x72, 0xC9, 0x72, 0xC9, 0x72, 0xA8, 0x72, 0x88, 0x6E, 0x68, 0x6A, 0x27, 0x62, 0x48, 0x66,
		0xCA, 0x72, 0x4B, 0x7B, 0x6D, 0x7B, 0xAF, 0x7F, 0xB1, 0x7F, 0xB2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7F, 0xD3, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0x90, 0x7F, 0x90, 0x7B,
		0x91, 0x7B, 0x92, 0x7B, 0x92, 0x7B, 0x93, 0x7B, 0x94, 0x77, 0x94, 0x7B, 0x94, 0x7B, 0x94, 0x7B,
		0x94, 0x7B, 0x94, 0x7B, 0x92, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x9E, 0x63, 0xBC, 0x1E, 0x5B, 0x02, 0xDC, 0x2A,
		0x9E, 0x5F, 0xDF, 0x73, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6F, 0x9A, 0x12, 0x5D, 0x53, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x3C, 0x43, 0xBA, 0x1A, 0xDF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBE, 0x67,
		0x1C, 0x3F, 0xBA, 0x1A, 0x9A, 0x0E, 0xDB, 0x22, 0x5D, 0x4B, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x9E, 0x63, 0x9A, 0x12, 0x1C, 0x3F, 0x3D, 0x47, 0xBC, 0x1E, 0x9C, 0x12, 0x9D, 0x16, 0xBD, 0x1E,
		0x1E, 0x3B, 0x7F, 0x5B, 0xDF, 0x6F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7B, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xF5, 0x2D, 0xD9, 0x4A, 0x5C, 0x63,
		0xFF, 0x7F, 0x7E, 0x57, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x98, 0x3E, 0xCE, 0x04, 0x4A, 0x00,
		0x6B, 0x00, 0x1B, 0x57, 0xFF, 0x7F, 0x8D, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0xBE, 0x73, 0xFF, 0x7F,
		0x15, 0x2E, 0x4A, 0x00, 0x4A, 0x00, 0x37, 0x36, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0x3E, 0x47, 0x3E, 0x47, 0x3E, 0x47, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x9E, 0x63,
		0x9E, 0x63, 0x9E, 0x63, 0x37, 0x36, 0xF5, 0x29, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x73, 0x6B, 0x00,
		0x4A, 0x00, 0x51, 0x15, 0xD4, 0x21, 0x1B, 0x57, 0xFF, 0x7F, 0xFF, 0x7F, 0x37, 0x36, 0x4A, 0x00,
		0x4A, 0x00, 0x1B, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xDF, 0x73, 0xDA, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xFF, 0x7F, 0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00, 0x6C, 0x00,
		0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00, 0xB4, 0x21, 0xFF, 0x7F, 0x8D, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xFF, 0x7F, 0x52, 0x15, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x98, 0x42, 0xDA, 0x52, 0x4A, 0x00, 0x4A, 0x00, 0x1A, 0x5F, 0xFF, 0x7F, 0xFF, 0x7B,
		0xDF, 0x77, 0xDF, 0x6F, 0x7F, 0x57, 0x7F, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x72, 0x19,
		0xFF, 0x7F, 0x39, 0x67, 0x4A, 0x00, 0x4A, 0x00, 0xF1, 0x39, 0x54, 0x4A, 0x54, 0x4A, 0xFF, 0x7F,
		0xFF, 0x7F, 0xBD, 0x77, 0x4A, 0x00, 0x4A, 0x00, 0x90, 0x2D, 0x12, 0x3E, 0x4A, 0x00, 0x4A, 0x00,
		0xFF, 0x7F, 0xFD, 0x7F, 0xFD, 0x7F, 0xFD, 0x7F, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x18, 0x5F,
		0xB0, 0x2D, 0x4A, 0x00, 0x4A, 0x00, 0x95, 0x4E, 0xFF, 0x7F, 0xD7, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F,
		0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB3, 0x7B, 0x38, 0x5B, 0xB5, 0x4A,
		0x30, 0x42, 0xCD, 0x39, 0x6A, 0x31, 0x69, 0x31, 0x49, 0x31, 0x48, 0x35, 0x68, 0x39, 0x88, 0x3D,
		0x88, 0x41, 0xA8, 0x49, 0xC9, 0x4D, 0xC8, 0x51, 0xE8, 0x55, 0x09, 0x5A, 0x29, 0x5E, 0x29, 0x62,
		0x49, 0x62, 0x6A, 0x66, 0x6B, 0x66, 0x8B, 0x66, 0x8C, 0x6A, 0x8D, 0x66, 0xAE, 0x66, 0x8E, 0x62,
		0x6F, 0x5A, 0x6F, 0x52, 0x70, 0x4E, 0x72, 0x4E, 0xD6, 0x52, 0x37, 0x63, 0x72, 0x77, 0x6D, 0x7F,
		0x8E, 0x7F, 0x8F, 0x7F, 0xB0, 0x7F, 0xB1, 0x7F, 0xB2, 0x7F, 0xD3, 0x7F, 0xD4, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD5, 0x7B, 0xB5, 0x7F, 0xB3, 0x7B, 0x72, 0x7B, 0x10, 0x6F, 0x8E, 0x5E, 0x4C, 0x5A,
		0x4A, 0x62, 0x69, 0x66, 0x89, 0x6E, 0xA9, 0x72, 0xC9, 0x72, 0xE9, 0x72, 0xC9, 0x72, 0xC9, 0x72,
		0xA8, 0x6E, 0x68, 0x6A, 0x27, 0x62, 0x68, 0x6A, 0x0A, 0x77, 0x6C, 0x7F, 0x8E, 0x7B, 0xB0, 0x7F,
		0xB2, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD3, 0x7F, 0xD3, 0x7F, 0xB2, 0x7F,
		0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0x92, 0x7B, 0x93, 0x7B, 0x93, 0x7B, 0x94, 0x7B, 0x94, 0x77,
		0x95, 0x77, 0x95, 0x77, 0x95, 0x77, 0x95, 0x77, 0x94, 0x7B, 0x94, 0x7B, 0x73, 0x7B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6F, 0x5D, 0x4F, 0xDC, 0x26,
		0x7B, 0x0E, 0xBC, 0x1E, 0x1D, 0x37, 0xBC, 0x1A, 0x7B, 0x0A, 0x9C, 0x16, 0xFD, 0x2A, 0x5D, 0x4B,
		0x9E, 0x63, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xBF, 0x6F, 0x9A, 0x12, 0x5D, 0x53, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3C, 0x3F, 0xBB, 0x1A, 0xDF, 0x73,
		0xDF, 0x73, 0x5D, 0x53, 0xDB, 0x26, 0x9A, 0x0E, 0xBA, 0x1A, 0x1C, 0x37, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x9A, 0x12, 0x9E, 0x5F, 0xFF, 0x7F,
		0xFF, 0x7B, 0xBF, 0x6B, 0x5E, 0x53, 0xFD, 0x32, 0x9C, 0x1A, 0x7C, 0x12, 0x9C, 0x16, 0x1D, 0x37,
		0x9E, 0x5F, 0x9F, 0x5F, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x51, 0x15, 0xFF, 0x7F, 0xD9, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xFF, 0x7B, 0xFF, 0x7F, 0x4A, 0x00,
		0x4A, 0x00, 0xD4, 0x21, 0xDF, 0x73, 0x3C, 0x43, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21,
		0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xD4, 0x21, 0xD4, 0x21, 0xD9, 0x4A, 0xD9, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0xD9, 0x4A, 0xD9, 0x4A, 0x5C, 0x63, 0xBF, 0x6B, 0xFF, 0x7F,
		0xF5, 0x29, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x93, 0x1D, 0xFF, 0x7B, 0x5C, 0x63,
		0x93, 0x1D, 0xCE, 0x04, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x5C, 0x63, 0xFF, 0x7F, 0x4A, 0x00,
		0x4A, 0x00, 0xD4, 0x21, 0x3E, 0x47, 0xD4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x5C, 0x63, 0x1E, 0x47,
		0x9F, 0x67, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x1B, 0x57, 0xEF, 0x08, 0x4A, 0x00, 0xB4, 0x21,
		0x37, 0x36, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x98, 0x3E, 0x4A, 0x00,
		0x4A, 0x00, 0x51, 0x15, 0xCE, 0x04, 0x4A, 0x00, 0x6B, 0x00, 0xFF, 0x7F, 0xDA, 0x4E, 0x4A, 0x00,
		0x4A, 0x00, 0x1A, 0x5F, 0xFF, 0x77, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xF5, 0x31, 0xBE, 0x6F, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00,
		0xF2, 0x39, 0xDE, 0x7F, 0xFF, 0x7F, 0x54, 0x46, 0x2E, 0x1D, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x54, 0x46, 0x13, 0x3E, 0x4A, 0x00, 0x4A, 0x00, 0x19, 0x5F, 0x19, 0x5F, 0x19, 0x5F, 0x9C, 0x6F,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x2E, 0x1D, 0xFF, 0x7F,
		0xFB, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xD7, 0x7B, 0x17, 0x5F, 0x52, 0x4A, 0x30, 0x46, 0x10, 0x46, 0x0F, 0x46, 0x0F, 0x46,
		0x0F, 0x4A, 0x2F, 0x4A, 0x2F, 0x4E, 0x2F, 0x4E, 0x4F, 0x52, 0x4F, 0x56, 0x6F, 0x5A, 0x6F, 0x5E,
		0x6F, 0x5E, 0x8F, 0x5E, 0x90, 0x62, 0x90, 0x62, 0xB0, 0x66, 0xB0, 0x66, 0xB1, 0x66, 0xB1, 0x66,
		0xD1, 0x66, 0xD1, 0x66, 0xD2, 0x66, 0xD2, 0x66, 0xD3, 0x62, 0xD4, 0x5E, 0xD4, 0x5E, 0xD5, 0x5A,
		0xF7, 0x5A, 0x5A, 0x63, 0xBC, 0x6F, 0xD9, 0x7B, 0xB4, 0x7F, 0xB4, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F,
		0x96, 0x7B, 0x55, 0x77, 0xF3, 0x6A, 0xD2, 0x66, 0xD0, 0x6A, 0xF0, 0x72, 0x10, 0x73, 0x30, 0x77,
		0x50, 0x77, 0x50, 0x7B, 0x50, 0x77, 0x30, 0x77, 0x0F, 0x77, 0xEF, 0x72, 0xCF, 0x6E, 0x10, 0x73,
		0x71, 0x7B, 0xB3, 0x7F, 0xB4, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD8, 0x7B, 0xB8, 0x7B, 0xB8, 0x7B, 0xB9, 0x7B, 0xB9, 0x7B, 0xB9, 0x77, 0xB9, 0x77, 0xB9, 0x77,
		0xB8, 0x7B, 0x98, 0x7B, 0x97, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x9E, 0x5F,
		0x1C, 0x37, 0x9B, 0x16, 0x9B, 0x12, 0xDC, 0x26, 0x5D, 0x4F, 0xDF, 0x77, 0xFF, 0x7F, 0xBF, 0x6B,
		0x9B, 0x12, 0xBC, 0x1E, 0xFD, 0x2E, 0x9B, 0x16, 0x9A, 0x12, 0xBB, 0x1E, 0x1C, 0x3B, 0x7D, 0x53,
		0xBE, 0x6B, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9A, 0x16, 0x5D, 0x4F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBB, 0x22, 0x1B, 0x37, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5C, 0x47, 0x9A, 0x0E, 0x1C, 0x3B, 0xDB, 0x2A, 0xBA, 0x16, 0xFB, 0x2A, 0x5D, 0x4B,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x9E, 0x5F, 0x9A, 0x12, 0x7D, 0x57, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDF, 0x73, 0x9E, 0x63, 0x3E, 0x4B, 0x1D, 0x3B, 0xBC, 0x1E, 0xBC, 0x1A, 0x9C, 0x12, 0x9C, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7D, 0x12, 0x7D, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x30, 0x0D, 0xCE, 0x04, 0x4A, 0x00,
		0x4A, 0x00, 0xF5, 0x29, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x6B, 0x00, 0x5C, 0x63, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0x5E, 0x4F, 0x99, 0x1A,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xD4, 0x21, 0xFF, 0x7F, 0xCE, 0x04, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0xCE, 0x04, 0x5C, 0x63, 0x98, 0x3E, 0x6B, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x93, 0x1D, 0xFF, 0x7F, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0x3E, 0x47, 0xD4, 0x21,
		0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0x9D, 0x26, 0x1E, 0x47, 0x78, 0x3E, 0x4A, 0x00, 0x4A, 0x00,
		0xBA, 0x4A, 0xEF, 0x08, 0x4A, 0x00, 0x73, 0x1D, 0x8D, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0xFF, 0x7F, 0xFF, 0x7F, 0x6B, 0x00, 0x4A, 0x00, 0x57, 0x36, 0xCE, 0x04, 0x4A, 0x00,
		0x51, 0x15, 0xFF, 0x7B, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x1A, 0x5F, 0xDF, 0x73, 0xDF, 0x6F,
		0x9F, 0x63, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xF5, 0x2D,
		0x5E, 0x53, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xF2, 0x39, 0xBD, 0x77, 0xEC, 0x14, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xED, 0x14, 0x9C, 0x6F, 0x12, 0x3E, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x12, 0x3E, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD7, 0x56, 0xFE, 0x7F, 0xD6, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7B, 0xD4, 0x7B, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0x8E, 0x5A, 0x28, 0x2D,
		0x48, 0x31, 0x48, 0x35, 0x69, 0x35, 0x8A, 0x39, 0xAB, 0x3D, 0xAA, 0x41, 0xA9, 0x45, 0xC8, 0x49,
		0xE8, 0x51, 0xE8, 0x55, 0x08, 0x5A, 0x09, 0x5A, 0x29, 0x5E, 0x29, 0x5E, 0x29, 0x5E, 0x2A, 0x5A,
		0x2A, 0x5A, 0x2A, 0x5A, 0x2B, 0x56, 0x0B, 0x56, 0x0B, 0x56, 0x0B, 0x52, 0x0B, 0x4E, 0xEC, 0x4D,
		0xEC, 0x49, 0xEC, 0x45, 0xED, 0x41, 0x0E, 0x42, 0x51, 0x46, 0x73, 0x46, 0xF7, 0x52, 0x9C, 0x6B,
		0xB6, 0x7B, 0xB0, 0x7F, 0xB1, 0x7F, 0xB2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xB4, 0x7B, 0xB3, 0x7B, 0x71, 0x7B, 0x10, 0x6F, 0x8E, 0x62, 0x4C, 0x5E,
		0x6A, 0x66, 0x89, 0x6A, 0xA9, 0x6E, 0xC9, 0x72, 0xE9, 0x76, 0x09, 0x77, 0xE9, 0x76, 0xC9, 0x72,
		0xA9, 0x72, 0x68, 0x6A, 0x48, 0x66, 0xCA, 0x72, 0x4B, 0x7B, 0x8D, 0x7B, 0xB0, 0x7F, 0xB2, 0x7F,
		0xD3, 0x7F, 0xD4, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD3, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB5, 0x7B, 0xB6, 0x7B, 0xB6, 0x7B, 0x97, 0x77, 0x97, 0x77,
		0x97, 0x73, 0x97, 0x73, 0x77, 0x73, 0x77, 0x73, 0x76, 0x73, 0x55, 0x6F, 0x54, 0x6F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xDF, 0x77, 0xFF, 0x7F,
		0xBE, 0x6B, 0x5D, 0x47, 0xBB, 0x1E, 0x7A, 0x0A, 0x9B, 0x16, 0x1C, 0x3F, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9B, 0x16, 0x5E, 0x4F, 0xFF, 0x7F, 0xBF, 0x6B,
		0x7E, 0x53, 0x1C, 0x37, 0xBA, 0x1A, 0x9A, 0x0E, 0x9A, 0x12, 0xBB, 0x22, 0x3C, 0x3F, 0x9E, 0x63,
		0x9E, 0x63, 0x9A, 0x0E, 0x5D, 0x53, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0xBB, 0x22, 0x1B, 0x37, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x6B, 0x9A, 0x16, 0x59, 0x02,
		0x9A, 0x12, 0x7D, 0x53, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x5F, 0x9A, 0x12, 0x7E, 0x57, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0x5E, 0x4B,
		0xBC, 0x1E, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0xDA, 0x4A, 0xFF, 0x7F, 0xCE, 0x04, 0x4A, 0x00, 0xEF, 0x08, 0xD9, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0xD9, 0x4A, 0xBE, 0x73, 0x8D, 0x00, 0x4A, 0x00, 0x93, 0x1D, 0xFF, 0x7F, 0x4A, 0x00,
		0x4A, 0x00, 0x93, 0x1D, 0xFF, 0x7B, 0x7D, 0x57, 0xBE, 0x73, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21,
		0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xD4, 0x21, 0xD4, 0x21, 0xD9, 0x4A, 0xD9, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0x37, 0x36, 0xD9, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0x6B, 0x00, 0x93, 0x1D, 0x98, 0x3E, 0xFF, 0x7F, 0xBF, 0x6B, 0x30, 0x0D, 0x4A, 0x00,
		0x4A, 0x00, 0xCE, 0x04, 0xD4, 0x21, 0x1B, 0x57, 0xFF, 0x7F, 0x7E, 0x5F, 0xFF, 0x7F, 0x4A, 0x00,
		0x4A, 0x00, 0xD4, 0x21, 0x3E, 0x47, 0x15, 0x2A, 0x4A, 0x00, 0x4A, 0x00, 0x1B, 0x57, 0x7F, 0x5F,
		0xDF, 0x73, 0xB4, 0x21, 0x4A, 0x00, 0x4A, 0x00, 0x5C, 0x63, 0xEF, 0x08, 0x4A, 0x00, 0x6C, 0x00,
		0x4A, 0x00, 0x6C, 0x00, 0x78, 0x3E, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0xFF, 0x7B, 0x51, 0x15,
		0x4A, 0x00, 0xCE, 0x04, 0x4A, 0x00, 0x4A, 0x00, 0x98, 0x3E, 0x7E, 0x57, 0xDA, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0x1A, 0x5F, 0xDF, 0x73, 0xDF, 0x6F, 0xBF, 0x6B, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xF5, 0x31, 0x5F, 0x4F, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00,
		0x12, 0x3E, 0xB6, 0x56, 0x4A, 0x00, 0x4A, 0x00, 0xAC, 0x0C, 0xD1, 0x35, 0xD6, 0x56, 0xFF, 0x7F,
		0xFE, 0x7F, 0x12, 0x3E, 0x4A, 0x00, 0x4A, 0x00, 0x2E, 0x1D, 0x2E, 0x1D, 0x2E, 0x1D, 0x95, 0x4E,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x18, 0x5F, 0xFF, 0x7F, 0x6F, 0x25, 0x4A, 0x00, 0xED, 0x14,
		0xFF, 0x7F, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F,
		0xD5, 0x7B, 0xF5, 0x7F, 0xB2, 0x7B, 0x4B, 0x56, 0x68, 0x3D, 0xCD, 0x41, 0x93, 0x52, 0x92, 0x56,
		0x6F, 0x56, 0x0B, 0x52, 0xE9, 0x51, 0xE8, 0x55, 0x08, 0x5A, 0x28, 0x5E, 0x28, 0x62, 0x49, 0x66,
		0x69, 0x6A, 0x89, 0x6E, 0x89, 0x6E, 0x89, 0x6E, 0x89, 0x6E, 0x8A, 0x6A, 0x6A, 0x66, 0x4B, 0x62,
		0x2B, 0x5A, 0x2C, 0x52, 0x0C, 0x4E, 0xEC, 0x49, 0xEC, 0x41, 0xCC, 0x3D, 0xCD, 0x3D, 0xEE, 0x3D,
		0x51, 0x42, 0xD5, 0x52, 0x17, 0x57, 0x5A, 0x5B, 0xBA, 0x73, 0xD3, 0x7F, 0xB2, 0x7F, 0xD3, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xB3, 0x7F, 0x92, 0x7B,
		0x71, 0x7B, 0xEF, 0x6E, 0x8D, 0x62, 0x4C, 0x5E, 0x6A, 0x66, 0x89, 0x6A, 0xA9, 0x72, 0xC9, 0x72,
		0xE9, 0x76, 0x09, 0x77, 0xE9, 0x76, 0xC9, 0x72, 0xA9, 0x72, 0x68, 0x6A, 0x69, 0x6A, 0xCA, 0x72,
		0x4B, 0x7B, 0x8D, 0x7B, 0xB0, 0x7F, 0xD2, 0x7F, 0xD3, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xB4, 0x7F, 0xB5, 0x7B, 0xB6, 0x7B,
		0xB7, 0x7B, 0xB7, 0x77, 0x98, 0x77, 0x98, 0x73, 0x98, 0x6F, 0x78, 0x6F, 0x78, 0x6B, 0x77, 0x6B,
		0x57, 0x6B, 0x56, 0x6B, 0x34, 0x6B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x7D, 0x53, 0x1C, 0x3F, 0x9A, 0x16, 0x9A, 0x12, 0xDB, 0x2A, 0x5D, 0x53,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x6F,
		0x9B, 0x12, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9E, 0x5F,
		0x3D, 0x47, 0xFB, 0x2E, 0xBB, 0x22, 0xBA, 0x1A, 0x9A, 0x16, 0x7A, 0x0A, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x5F, 0xFB, 0x2A, 0xBA, 0x1A, 0xBB, 0x1E, 0xFB, 0x2A, 0x3C, 0x43,
		0x9E, 0x5F, 0xDF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x9E, 0x5F, 0x9A, 0x12, 0x7E, 0x57, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6F,
		0x5E, 0x4B, 0xDC, 0x2A, 0x7B, 0x0E, 0x9C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xDA, 0x4A, 0x1B, 0x57, 0x6B, 0x00,
		0x4A, 0x00, 0x30, 0x0D, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0x5C, 0x63, 0x8D, 0x00,
		0x4A, 0x00, 0xEF, 0x08, 0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00, 0x6B, 0x00, 0x1B, 0x57, 0xFF, 0x7F,
		0x51, 0x15, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x98, 0x3E, 0xFF, 0x7F, 0xBE, 0x73,
		0x93, 0x1D, 0x37, 0x36, 0x30, 0x0D, 0x4A, 0x00, 0xCE, 0x04, 0xFF, 0x7F, 0xFF, 0x7F, 0xD9, 0x4A,
		0x30, 0x0D, 0xFF, 0x7F, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0xFF, 0x7F, 0x1B, 0x57,
		0x4A, 0x00, 0x4A, 0x00, 0x10, 0x0D, 0xFF, 0x7F, 0x5C, 0x63, 0x8D, 0x00, 0x4A, 0x00, 0x8D, 0x00,
		0xFF, 0x7F, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xB4, 0x21, 0xBA, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0xFF, 0x7F, 0x7E, 0x57, 0x98, 0x3E, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x6B, 0x00,
		0xFF, 0x7F, 0xFD, 0x32, 0xDA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x1A, 0x5F, 0xFF, 0x77, 0xDF, 0x73,
		0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x15, 0x3A,
		0x9F, 0x63, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x13, 0x3E, 0x96, 0x4E, 0x4A, 0x00, 0x4A, 0x00,
		0x19, 0x5F, 0xFF, 0x7F, 0xBE, 0x77, 0xF2, 0x35, 0x5A, 0x67, 0x33, 0x3E, 0x4A, 0x00, 0x4A, 0x00,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x19, 0x5F,
		0xBE, 0x77, 0x70, 0x25, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xD7, 0x7F,
		0x53, 0x73, 0x37, 0x67, 0xF6, 0x62, 0xB3, 0x5E, 0x71, 0x5A, 0x6F, 0x5A, 0x6F, 0x5A, 0x6F, 0x5A,
		0x6F, 0x5E, 0x8F, 0x5E, 0x8F, 0x62, 0x8F, 0x62, 0xAF, 0x66, 0xAF, 0x66, 0xAF, 0x6A, 0xD0, 0x6A,
		0xD0, 0x6E, 0xF0, 0x6E, 0xF1, 0x6E, 0xF1, 0x6E, 0xF1, 0x6E, 0xF2, 0x6A, 0xF3, 0x66, 0xD3, 0x62,
		0xB3, 0x5A, 0x93, 0x56, 0x93, 0x52, 0xB4, 0x56, 0xF7, 0x5A, 0x7A, 0x67, 0xBC, 0x6F, 0xBD, 0x6F,
		0xBB, 0x73, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xB6, 0x7F, 0x74, 0x7B, 0x33, 0x73, 0xF2, 0x6A, 0xD1, 0x6A,
		0xF0, 0x6E, 0xF0, 0x72, 0x10, 0x77, 0x30, 0x77, 0x50, 0x7B, 0x50, 0x7B, 0x50, 0x77, 0x30, 0x77,
		0x0F, 0x73, 0xEF, 0x6E, 0xEF, 0x6E, 0x50, 0x77, 0x91, 0x7F, 0xB3, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F,
		0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xBA, 0x77, 0xBB, 0x77,
		0xBB, 0x73, 0x9B, 0x6F, 0x9A, 0x6F, 0x9A, 0x6F, 0x7A, 0x6F, 0x79, 0x6B, 0x58, 0x6B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x79, 0x0A, 0x9A, 0x0E,
		0x3C, 0x43, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x6F, 0x9B, 0x12, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4F, 0x7A, 0x0E,
		0x59, 0x02, 0x1C, 0x3B, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xBB, 0x22, 0x1C, 0x37, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x77,
		0xBE, 0x67, 0x5D, 0x4B, 0xFB, 0x2E, 0xBA, 0x16, 0x9A, 0x12, 0xBA, 0x1A, 0xFC, 0x32, 0x5D, 0x53,
		0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x9A, 0x12, 0x9E, 0x5B, 0xFF, 0x7F,
		0xFF, 0x7B, 0x9E, 0x5F, 0xFC, 0x36, 0x9B, 0x16, 0x5B, 0x02, 0x3B, 0x02, 0x3B, 0x02, 0x7C, 0x12,
		0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0xDD, 0x2E, 0xDA, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x98, 0x3E, 0xD9, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x15, 0x2A, 0x9E, 0x63, 0xD9, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xFF, 0x7F,
		0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xD9, 0x4A,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xFF, 0x7F, 0xEF, 0x08,
		0x4A, 0x00, 0x4A, 0x00, 0x8D, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD4, 0x21, 0x5C, 0x63, 0x4A, 0x00,
		0x4A, 0x00, 0x6B, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xD9, 0x4A, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0xEF, 0x08, 0xFF, 0x7F, 0x51, 0x15, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00,
		0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x78, 0x3E, 0xDF, 0x73, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00,
		0x8D, 0x00, 0xBE, 0x73, 0xBA, 0x4A, 0x4A, 0x00, 0x4A, 0x00, 0xFF, 0x7F, 0xFD, 0x32, 0xFF, 0x7F,
		0x6B, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x51, 0x15, 0xFF, 0x7B, 0xDD, 0x2A, 0xDA, 0x4A, 0x4A, 0x00,
		0x4A, 0x00, 0x1A, 0x5F, 0xDF, 0x73, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x63, 0x7F, 0x57, 0x7F, 0x57,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x15, 0x36, 0x9F, 0x5B, 0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00,
		0x12, 0x3E, 0xFF, 0x7F, 0xED, 0x14, 0x4A, 0x00, 0x4A, 0x00, 0xAC, 0x0C, 0x4A, 0x00, 0x4A, 0x00,
		0x18, 0x5F, 0x13, 0x3E, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x2E, 0x1D,
		0xFF, 0x7F, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x6F, 0x25,
		0xFF, 0x7F, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xF7, 0x7F, 0x73, 0x73, 0xEB, 0x49, 0xA9, 0x41,
		0x0C, 0x4E, 0x2D, 0x52, 0x4C, 0x56, 0x2A, 0x5A, 0x28, 0x5E, 0x49, 0x62, 0x69, 0x66, 0x89, 0x6A,
		0x69, 0x66, 0x69, 0x66, 0x69, 0x66, 0x69, 0x66, 0x49, 0x62, 0x4A, 0x62, 0x2A, 0x5E, 0x2B, 0x5E,
		0x2B, 0x5E, 0x4C, 0x5A, 0x4C, 0x5A, 0x6D, 0x5A, 0x8F, 0x5A, 0xB2, 0x56, 0xB3, 0x52, 0x93, 0x4E,
		0xD5, 0x56, 0x58, 0x5F, 0x9A, 0x67, 0x7A, 0x63, 0x97, 0x73, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD4, 0x7F, 0xB4, 0x7F, 0xB3, 0x7F, 0x71, 0x7B,
		0x2F, 0x77, 0xCE, 0x6A, 0x6C, 0x5E, 0x4B, 0x5E, 0x49, 0x66, 0x89, 0x6A, 0xA9, 0x72, 0xC9, 0x72,
		0xE9, 0x76, 0xE9, 0x76, 0xE9, 0x76, 0xC9, 0x72, 0x88, 0x6E, 0x68, 0x6A, 0x88, 0x6A, 0xEA, 0x76,
		0x4C, 0x7B, 0x8E, 0x7B, 0xB0, 0x7F, 0xB2, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B,
		0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD5, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B,
		0xB8, 0x7B, 0xB9, 0x77, 0x99, 0x73, 0x99, 0x6F, 0x79, 0x6B, 0x79, 0x67, 0x79, 0x67, 0x79, 0x63,
		0x58, 0x63, 0x37, 0x5F, 0x16, 0x5F, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x7A, 0x0A, 0xFC, 0x32, 0x5D, 0x4F, 0xBE, 0x67, 0xDF, 0x77,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x6F,
		0x9B, 0x12, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6F,
		0x3D, 0x47, 0xBB, 0x22, 0x9A, 0x16, 0xDB, 0x2A, 0x7D, 0x53, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7E, 0x5B, 0x7A, 0x0A, 0x9A, 0x12, 0x9E, 0x5F, 0xFF, 0x77,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xDF, 0x6F,
		0x9E, 0x5B, 0x3C, 0x3F, 0xDB, 0x22, 0x9A, 0x0E, 0x9A, 0x12, 0xDB, 0x2A, 0x3D, 0x47, 0xBE, 0x6B,
		0x7E, 0x5B, 0x9A, 0x12, 0x5D, 0x4B, 0x7D, 0x53, 0xDB, 0x26, 0x7A, 0x0A, 0x3A, 0x02, 0x3A, 0x02,
		0x3A, 0x02, 0x3B, 0x02, 0x3B, 0x02, 0x7C, 0x0E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0xDD, 0x2E, 0x1B, 0x57, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08,
		0x37, 0x36, 0xFF, 0x7F, 0x1B, 0x57, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08,
		0x15, 0x2A, 0xFF, 0x7F, 0x1D, 0x43, 0xFF, 0x7F, 0xD9, 0x4A, 0xEF, 0x08, 0x4A, 0x00, 0x4A, 0x00,
		0x6B, 0x00, 0xD4, 0x21, 0xBE, 0x73, 0x9E, 0x63, 0x1B, 0x57, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08,
		0xEF, 0x08, 0xEF, 0x08, 0x93, 0x1D, 0x1B, 0x57, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08,
		0xEF, 0x08, 0x93, 0x1D, 0x9E, 0x63, 0x1B, 0x57, 0x30, 0x0D, 0x4A, 0x00, 0x4A, 0x00, 0x6B, 0x00,
		0x30, 0x0D, 0xD9, 0x4A, 0xFF, 0x7F, 0x37, 0x36, 0x8D, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xCE, 0x04,
		0x93, 0x1D, 0x1B, 0x57, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0xEF, 0x08, 0x93, 0x1D, 0x9E, 0x63,
		0xFF, 0x7F, 0xB4, 0x21, 0x8D, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0xAE, 0x04, 0x78, 0x3E, 0xFF, 0x7F,
		0x9F, 0x67, 0x73, 0x1D, 0xEF, 0x08, 0xEF, 0x08, 0x78, 0x3E, 0xDF, 0x73, 0x1B, 0x57, 0xEF, 0x08,
		0xEF, 0x08, 0xFF, 0x7F, 0x7C, 0x0E, 0xFF, 0x7B, 0xD4, 0x21, 0xEF, 0x08, 0xEF, 0x08, 0xD9, 0x4A,
		0x7E, 0x57, 0xDD, 0x2A, 0x1B, 0x57, 0xEF, 0x08, 0x0F, 0x0D, 0x5B, 0x67, 0xDF, 0x73, 0xDF, 0x6F,
		0xDF, 0x6F, 0xBF, 0x6B, 0x7F, 0x57, 0x7F, 0x57, 0xFF, 0x7F, 0x30, 0x15, 0x30, 0x15, 0x77, 0x46,
		0xBF, 0x67, 0xFF, 0x7F, 0x0E, 0x19, 0x2E, 0x1D, 0x75, 0x4E, 0xFD, 0x7F, 0x3A, 0x67, 0x4E, 0x25,
		0x4A, 0x00, 0x4A, 0x00, 0x8B, 0x04, 0x6F, 0x25, 0x9C, 0x6F, 0x96, 0x4E, 0x2E, 0x1D, 0x2E, 0x1D,
		0x2E, 0x1D, 0x2E, 0x1D, 0x2E, 0x1D, 0xF2, 0x35, 0xFF, 0x7F, 0x2E, 0x1D, 0x2E, 0x1D, 0x2E, 0x1D,
		0x2E, 0x1D, 0x2E, 0x1D, 0xF2, 0x35, 0xBE, 0x77, 0xFD, 0x7F, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xF8, 0x7F, 0xF6, 0x7F, 0xEE, 0x6A, 0xB1, 0x56, 0x16, 0x5F, 0xF4, 0x5E, 0x8F, 0x5A, 0x09, 0x5A,
		0x28, 0x62, 0x69, 0x6A, 0xA9, 0x6E, 0xCA, 0x72, 0xEA, 0x76, 0xEA, 0x76, 0xEA, 0x76, 0xEA, 0x76,
		0xEA, 0x76, 0xCB, 0x72, 0xAB, 0x6E, 0x8B, 0x6A, 0x6C, 0x62, 0x4C, 0x5E, 0x2C, 0x56, 0x2C, 0x52,
		0x2D, 0x52, 0x6F, 0x52, 0xD4, 0x5A, 0x58, 0x63, 0x58, 0x63, 0x37, 0x63, 0x57, 0x63, 0x77, 0x6F,
		0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F,
		0xD4, 0x7B, 0xB3, 0x7F, 0xB2, 0x7F, 0x70, 0x7B, 0x0E, 0x73, 0x8D, 0x66, 0x4B, 0x5A, 0x2A, 0x5A,
		0x49, 0x62, 0x68, 0x6A, 0x89, 0x6E, 0xC9, 0x72, 0xC9, 0x72, 0xC9, 0x72, 0xC9, 0x72, 0xA8, 0x72,
		0x88, 0x6E, 0x48, 0x6A, 0x88, 0x6A, 0xEA, 0x76, 0x4B, 0x7B, 0x8D, 0x7B, 0xB0, 0x7F, 0xB2, 0x7F,
		0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xB3, 0x7F, 0xB4, 0x7F,
		0xD5, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B, 0xB8, 0x7B, 0xB8, 0x7B, 0xB9, 0x77, 0xBA, 0x73, 0x9A, 0x6F,
		0x9A, 0x6B, 0x9A, 0x67, 0x7A, 0x67, 0x7A, 0x67, 0x79, 0x63, 0x58, 0x63, 0x37, 0x5F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x7A, 0x0A, 0xBB, 0x1E, 0x1C, 0x3F, 0x7D, 0x57, 0xBF, 0x6F, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9B, 0x12, 0x5D, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDF, 0x77, 0x9E, 0x5F, 0x1D, 0x3B, 0x9B, 0x12, 0x7A, 0x0E, 0xFB, 0x32, 0x9E, 0x5F, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x57, 0xFB, 0x2E, 0x7A, 0x0E,
		0x9A, 0x16, 0xBA, 0x1A, 0x7A, 0x0E, 0xDB, 0x22, 0x1C, 0x37, 0x5D, 0x53, 0xBE, 0x6B, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x3C, 0x43,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x7A, 0x0E, 0x9A, 0x12, 0x59, 0x02, 0x7A, 0x0A, 0x5A, 0x06,
		0x59, 0x02, 0x5A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3B, 0x02, 0x7B, 0x0E,
		0x7C, 0x0E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0xBD, 0x26, 0x9F, 0x67, 0x9F, 0x67,
		0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0x9F, 0x67, 0x1D, 0x3B, 0x9F, 0x67, 0x9E, 0x63,
		0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x1D, 0x43, 0x7C, 0x0E, 0xDC, 0x2A,
		0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x3E, 0x47, 0xBC, 0x26,
		0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63,
		0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x67, 0x9E, 0x67, 0x9E, 0x67, 0x5E, 0x4F, 0x9E, 0x5F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x9E, 0x5F, 0x1D, 0x3B, 0xDF, 0x73,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63,
		0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x5E, 0x4F, 0x3E, 0x47, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0xBD, 0x32, 0x3E, 0x4F, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63,
		0x9F, 0x63, 0xBD, 0x32, 0x9F, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x7C, 0x0E, 0x3E, 0x47,
		0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0xDD, 0x2A, 0xBC, 0x26, 0x9F, 0x67, 0x9F, 0x67,
		0xBF, 0x67, 0xFF, 0x7B, 0xDF, 0x77, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63,
		0xFF, 0x7B, 0xFF, 0x7B, 0xFF, 0x7B, 0xFF, 0x7B, 0xBF, 0x6B, 0xDF, 0x6F, 0xDE, 0x77, 0xFE, 0x7F,
		0xFE, 0x7F, 0xDB, 0x7F, 0xFD, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFD, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F,
		0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFE, 0x7F, 0xFD, 0x7F,
		0xFB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDB, 0x7F,
		0xDA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xDB, 0x77,
		0x38, 0x63, 0xD5, 0x5E, 0x91, 0x5E, 0x6F, 0x5E, 0xAF, 0x66, 0xD0, 0x6A, 0xF0, 0x72, 0x10, 0x73,
		0x30, 0x77, 0x30, 0x77, 0x31, 0x77, 0x31, 0x77, 0x31, 0x77, 0x31, 0x77, 0x31, 0x77, 0x32, 0x73,
		0x33, 0x73, 0x34, 0x6F, 0x15, 0x6B, 0x15, 0x6B, 0xF4, 0x62, 0xD4, 0x5E, 0xF5, 0x5E, 0x38, 0x67,
		0xBB, 0x73, 0xB9, 0x77, 0xD8, 0x7B, 0xD9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xB5, 0x7F, 0x94, 0x7B,
		0x33, 0x73, 0xD2, 0x6A, 0xB1, 0x62, 0xB0, 0x66, 0xCF, 0x6A, 0xCF, 0x6E, 0xEF, 0x72, 0x0F, 0x77,
		0x30, 0x77, 0x2F, 0x77, 0x0F, 0x77, 0x0F, 0x77, 0xEF, 0x72, 0xCF, 0x6E, 0xEF, 0x72, 0x30, 0x77,
		0x71, 0x7B, 0xB3, 0x7F, 0xB4, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xDA, 0x7B,
		0xDB, 0x7B, 0xDC, 0x7B, 0xBC, 0x77, 0xBC, 0x73, 0xBC, 0x73, 0xBC, 0x73, 0xBC, 0x73, 0xBC, 0x6F,
		0xBC, 0x6F, 0x9B, 0x6F, 0x9A, 0x6B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x9A, 0x12, 0xDB, 0x2A, 0x3D, 0x47, 0x9E, 0x5F, 0xDF, 0x73, 0xDF, 0x6F,
		0x9B, 0x12, 0x5D, 0x47, 0xDF, 0x6F, 0x5D, 0x47, 0xDC, 0x22, 0x7B, 0x06, 0x5B, 0x02, 0x5B, 0x02,
		0x1D, 0x37, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xBE, 0x67, 0x3C, 0x3F,
		0xBA, 0x1A, 0x7A, 0x0E, 0xBB, 0x1E, 0x5D, 0x4B, 0xDF, 0x6F, 0xDF, 0x73, 0x1C, 0x3B, 0x59, 0x06,
		0xBA, 0x1A, 0x9A, 0x12, 0x9A, 0x16, 0xDB, 0x26, 0x3C, 0x3F, 0x7E, 0x5B, 0xDF, 0x6F, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4F, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x3A, 0x02,
		0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7D, 0x12, 0x7C, 0x12, 0x7C, 0x0E,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x3C, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3D, 0x0E,
		0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3D, 0x0E, 0x5C, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x12, 0x5F, 0x4B, 0xDF, 0x6F, 0xDF, 0x6F,
		0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x63, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x1E, 0x37, 0xDC, 0x2A, 0x75, 0x6F, 0x94, 0x77, 0x94, 0x7B, 0x93, 0x7B, 0x92, 0x7B,
		0x92, 0x7B, 0x93, 0x7B, 0x94, 0x7B, 0xB5, 0x7B, 0xB6, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B,
		0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B,
		0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7F,
		0xD9, 0x7B, 0xD8, 0x7B, 0xF9, 0x7F, 0xB8, 0x77, 0x93, 0x4E, 0x0D, 0x46, 0xCA, 0x49, 0xC8, 0x51,
		0x08, 0x5A, 0x48, 0x62, 0x69, 0x6A, 0xA9, 0x6E, 0xCA, 0x72, 0xCA, 0x72, 0xEA, 0x72, 0xEB, 0x72,
		0xCB, 0x72, 0xAB, 0x6E, 0xAC, 0x6E, 0xAD, 0x6A, 0xAF, 0x66, 0xB0, 0x62, 0xF3, 0x62, 0x36, 0x67,
		0x58, 0x67, 0x37, 0x63, 0xD2, 0x5A, 0x34, 0x6B, 0xD8, 0x7B, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7F,
		0xD4, 0x7B, 0xB3, 0x7F, 0xB1, 0x7F, 0x50, 0x7B, 0xCE, 0x6A, 0x2C, 0x5A, 0x0A, 0x56, 0x09, 0x5A,
		0x28, 0x62, 0x68, 0x66, 0x88, 0x6E, 0xA8, 0x6E, 0xA9, 0x72, 0xA8, 0x72, 0xA8, 0x6E, 0x88, 0x6E,
		0x68, 0x6A, 0x27, 0x62, 0x48, 0x66, 0xA9, 0x72, 0x2A, 0x7B, 0x6D, 0x7B, 0x8F, 0x7F, 0xB1, 0x7F,
		0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7B, 0xD3, 0x7F, 0xD3, 0x7F, 0xB4, 0x7F,
		0xB5, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B, 0xB8, 0x7B, 0xBA, 0x77, 0xBA, 0x77, 0xBB, 0x73, 0x9B, 0x6F,
		0x9B, 0x6B, 0xBC, 0x6F, 0x9B, 0x6F, 0x9B, 0x6B, 0x9A, 0x6B, 0x7A, 0x67, 0x79, 0x63, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x7A, 0x0A, 0xBB, 0x22, 0xDC, 0x2A, 0x7A, 0x06, 0xBB, 0x1A, 0xBB, 0x1A, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x3D, 0x3F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x6F,
		0x7D, 0x53, 0xFB, 0x2A, 0x9A, 0x12, 0x9A, 0x16, 0xFC, 0x32, 0x9E, 0x5F, 0xFF, 0x7B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4F, 0xBA, 0x1A, 0xDF, 0x73, 0xBE, 0x67, 0x5D, 0x4B, 0xFB, 0x2E,
		0xBA, 0x16, 0x9A, 0x12, 0xBA, 0x1A, 0xFB, 0x2E, 0x5D, 0x4B, 0x9E, 0x63, 0xFF, 0x77, 0x5D, 0x4F,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x9B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x0E,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x5C, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E,
		0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E,
		0x3C, 0x0E, 0x3C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0xFE, 0x32, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x6B, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x5F, 0x47, 0xBD, 0x1E, 0x56, 0x5F,
		0x94, 0x7B, 0x93, 0x7B, 0x92, 0x7B, 0x92, 0x7B, 0x92, 0x7B, 0x73, 0x7B, 0x74, 0x77, 0x95, 0x7B,
		0xB6, 0x7B, 0xD8, 0x7B, 0xDA, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B, 0xFA, 0x7F, 0x54, 0x6F,
		0xCC, 0x3D, 0x89, 0x3D, 0xA8, 0x49, 0xE7, 0x55, 0x27, 0x5E, 0x48, 0x66, 0x88, 0x6E, 0xA9, 0x6E,
		0xC9, 0x72, 0xC9, 0x72, 0xC9, 0x72, 0xCA, 0x72, 0xCA, 0x72, 0xAB, 0x6E, 0xAC, 0x6E, 0xAE, 0x6A,
		0xB0, 0x62, 0xB1, 0x5E, 0xF5, 0x5E, 0x58, 0x63, 0x9B, 0x6B, 0xBC, 0x73, 0xB8, 0x77, 0xD7, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD3, 0x7F, 0xB1, 0x7F, 0x6F, 0x7B,
		0xCE, 0x6E, 0x2B, 0x56, 0xEA, 0x51, 0x09, 0x5A, 0x28, 0x62, 0x48, 0x66, 0x88, 0x6A, 0x88, 0x6E,
		0xA8, 0x72, 0xA8, 0x6E, 0x88, 0x6E, 0x88, 0x6E, 0x47, 0x66, 0x27, 0x62, 0x27, 0x62, 0x88, 0x6E,
		0x2A, 0x7B, 0x6D, 0x7B, 0x8F, 0x7F, 0xB1, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD3, 0x7B,
		0xD3, 0x7F, 0xD3, 0x7B, 0xD3, 0x7F, 0xB4, 0x7F, 0xB5, 0x7B, 0xB6, 0x7B, 0xB8, 0x7B, 0xB9, 0x7B,
		0xBA, 0x77, 0xBB, 0x77, 0xBB, 0x73, 0xBC, 0x6F, 0xBC, 0x6F, 0xBC, 0x6F, 0xBC, 0x6F, 0xBB, 0x6F,
		0x9B, 0x6B, 0x9A, 0x6B, 0x79, 0x67, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x1D, 0x37, 0xBF, 0x67, 0x1D, 0x3F, 0x9A, 0x16, 0x9A, 0x0E, 0xDB, 0x26, 0x5D, 0x4F, 0xDF, 0x6F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3D, 0x47, 0xBA, 0x16,
		0xDF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9E, 0x5F, 0x3C, 0x3F, 0xDB, 0x2A,
		0xBA, 0x1A, 0x9A, 0x16, 0xDB, 0x2A, 0xBB, 0x1E, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x3A, 0x02,
		0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x5C, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E,
		0x3D, 0x0E, 0x3D, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x3C, 0x0E, 0x5C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0xDE, 0x22, 0xBF, 0x6B, 0xDF, 0x73,
		0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63,
		0x9F, 0x63, 0x9F, 0x5F, 0x3E, 0x3F, 0x5B, 0x57, 0xB7, 0x7B, 0xB6, 0x7B, 0xB5, 0x7B, 0xB5, 0x7B,
		0xB6, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B, 0xB8, 0x7B, 0xD9, 0x7B, 0xDB, 0x7B, 0xDC, 0x7B, 0xDC, 0x7B,
		0xDC, 0x7F, 0xDD, 0x7F, 0xDD, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xFC, 0x7F, 0xD9, 0x7F, 0xD2, 0x62, 0x2F, 0x4E, 0x4F, 0x56, 0x6F, 0x5E, 0xAF, 0x66,
		0xCF, 0x6E, 0x10, 0x73, 0x30, 0x77, 0x50, 0x7B, 0x71, 0x7B, 0x71, 0x7B, 0x71, 0x7B, 0x50, 0x7B,
		0x30, 0x77, 0x11, 0x77, 0x11, 0x73, 0xF2, 0x6E, 0xF4, 0x6A, 0x16, 0x67, 0x79, 0x6B, 0xBC, 0x73,
		0xDE, 0x77, 0xDD, 0x7B, 0xFB, 0x7F, 0xFB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD8, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0x94, 0x7F, 0x33, 0x77, 0xD1, 0x66, 0x90, 0x62, 0xB0, 0x66,
		0xCF, 0x6A, 0xEF, 0x6E, 0xEF, 0x72, 0x0F, 0x77, 0x10, 0x77, 0x0F, 0x77, 0x0F, 0x73, 0xEF, 0x72,
		0xCF, 0x6E, 0xAE, 0x6A, 0x8E, 0x66, 0x0F, 0x73, 0x71, 0x7B, 0xB3, 0x7F, 0xD5, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD8, 0x7F, 0xD9, 0x7F, 0xDA, 0x7B, 0xDB, 0x7B, 0xDC, 0x7B, 0xDC, 0x7B, 0xDD, 0x77, 0xDD, 0x77,
		0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x73, 0xBD, 0x73, 0xBC, 0x73, 0xBB, 0x6F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x9B, 0x0E, 0x9C, 0x16, 0xBC, 0x16, 0x3D, 0x43,
		0x9E, 0x63, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4B, 0x9A, 0x16, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x6B, 0x1C, 0x37, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x7B, 0x0E,
		0x9B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x99, 0x12, 0x99, 0x12, 0x99, 0x12,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x5D, 0x0E,
		0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E, 0x3D, 0x0E,
		0x5C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0xBE, 0x16, 0x5F, 0x4F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x63,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x1E, 0x37, 0xDB, 0x2E,
		0x72, 0x73, 0x71, 0x7B, 0x70, 0x7B, 0x71, 0x7B, 0x91, 0x7B, 0x93, 0x7B, 0x94, 0x7B, 0x95, 0x7B,
		0x97, 0x77, 0xB9, 0x7B, 0xDA, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B,
		0xDB, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B, 0xF9, 0x7F, 0x54, 0x6B, 0x72, 0x4A,
		0x50, 0x4A, 0xEB, 0x49, 0xC9, 0x4D, 0x08, 0x5A, 0x49, 0x62, 0x69, 0x6A, 0xAA, 0x6E, 0xCA, 0x72,
		0x0B, 0x77, 0x0B, 0x77, 0x2B, 0x7B, 0x2B, 0x7B, 0x2C, 0x7B, 0x0C, 0x77, 0xED, 0x72, 0xCE, 0x6E,
		0xAF, 0x62, 0xB1, 0x5A, 0x16, 0x5F, 0x9B, 0x67, 0xDE, 0x77, 0xDC, 0x7F, 0xD9, 0x7B, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD4, 0x7F, 0xB2, 0x7F, 0x6F, 0x7B,
		0xED, 0x72, 0x6B, 0x62, 0x09, 0x56, 0x29, 0x5E, 0x48, 0x66, 0x88, 0x6A, 0xA9, 0x6E, 0xA9, 0x72,
		0xA8, 0x72, 0xA8, 0x72, 0x88, 0x6E, 0x68, 0x6A, 0x47, 0x66, 0x07, 0x5E, 0x07, 0x5E, 0xC9, 0x72,
		0x4C, 0x7F, 0x8E, 0x7F, 0xB1, 0x7F, 0xD2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD3, 0x7F, 0xD3, 0x7B, 0xD4, 0x7F, 0xB4, 0x7F, 0xB5, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B, 0xB9, 0x7B,
		0xBA, 0x77, 0xBB, 0x77, 0xBC, 0x77, 0xBC, 0x73, 0xBC, 0x73, 0xBC, 0x73, 0xBC, 0x6F, 0xBC, 0x6F,
		0xBB, 0x6F, 0x9B, 0x6F, 0x79, 0x6B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5B, 0x02, 0x5B, 0x02, 0xDC, 0x26, 0x7E, 0x57, 0xBF, 0x6F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDF, 0x73, 0x5D, 0x4F, 0xFB, 0x2E, 0xDB, 0x2A, 0x1C, 0x3B, 0x9E, 0x5F, 0x3C, 0x3F, 0xBA, 0x1A,
		0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x6F, 0x5C, 0x4F,
		0xFB, 0x2E, 0x9A, 0x16, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x3A, 0x02,
		0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7A, 0x12, 0x98, 0x12, 0x98, 0x12, 0x98, 0x12, 0x7A, 0x12, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x12,
		0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x5C, 0x0E, 0x5D, 0x0E, 0x3D, 0x0E, 0x5D, 0x0E,
		0x5D, 0x0E, 0x3D, 0x0E, 0x5D, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0xBE, 0x16, 0x1E, 0x37, 0xBF, 0x6F,
		0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x67, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x3F, 0x43, 0xBD, 0x1A, 0x34, 0x5F, 0x71, 0x7B, 0x91, 0x7B, 0x91, 0x7B,
		0x92, 0x7B, 0x93, 0x7B, 0x94, 0x7B, 0x95, 0x7B, 0x97, 0x77, 0xB8, 0x77, 0xDA, 0x7B, 0xDB, 0x7B,
		0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7F, 0xDB, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7F, 0xD9, 0x7B, 0xD4, 0x52, 0x30, 0x46, 0x0D, 0x46, 0xCA, 0x45, 0xC9, 0x4D, 0xE9, 0x55,
		0x29, 0x5E, 0x49, 0x62, 0x49, 0x66, 0x69, 0x6A, 0xAA, 0x6E, 0xAA, 0x6E, 0xAA, 0x6E, 0xAB, 0x6E,
		0xCB, 0x72, 0xCC, 0x6E, 0xCD, 0x6E, 0xCE, 0x6E, 0xCF, 0x6A, 0xD1, 0x62, 0xF5, 0x5E, 0x79, 0x67,
		0xBD, 0x6F, 0xDD, 0x7B, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD6, 0x7B, 0xD4, 0x7F, 0xB2, 0x7F, 0x6F, 0x7B, 0x0D, 0x77, 0x8B, 0x6A, 0x4A, 0x5E, 0x49, 0x62,
		0x89, 0x6A, 0xA8, 0x6E, 0xC9, 0x72, 0xC9, 0x72, 0xC9, 0x72, 0xC8, 0x72, 0xA8, 0x72, 0x88, 0x6E,
		0x47, 0x66, 0x27, 0x62, 0x68, 0x6A, 0xEA, 0x76, 0x6C, 0x7F, 0x8F, 0x7F, 0xB1, 0x7F, 0xD3, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xB4, 0x7F, 0xD4, 0x7B,
		0xD5, 0x7B, 0xD6, 0x7B, 0xB7, 0x7B, 0xB9, 0x7B, 0xBA, 0x77, 0xBB, 0x77, 0xBC, 0x77, 0xBC, 0x73,
		0xBC, 0x73, 0xBC, 0x73, 0xBC, 0x6F, 0xBC, 0x6F, 0xBB, 0x6F, 0x9A, 0x6F, 0x79, 0x6B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x7B, 0x06, 0x7B, 0x0A,
		0x9C, 0x12, 0xDC, 0x26, 0x3C, 0x43, 0x3C, 0x3F, 0xBA, 0x1A, 0x9A, 0x12, 0x79, 0x06, 0x79, 0x06,
		0x9A, 0x16, 0x9A, 0x12, 0x7A, 0x0A, 0x7A, 0x0A, 0x3C, 0x43, 0xBE, 0x67, 0xFF, 0x7B, 0xFF, 0x7B,
		0x9E, 0x5F, 0x1B, 0x3B, 0xB9, 0x1A, 0x78, 0x06, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x3A, 0x02, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0xDC, 0x2A, 0xDB, 0x2E, 0xFA, 0x2E, 0xDB, 0x2E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12,
		0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0xDC, 0x26, 0xDC, 0x2E, 0xDC, 0x2E,
		0xDC, 0x2E, 0xBC, 0x1E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0xDD, 0x26,
		0xDD, 0x2A, 0xDD, 0x2A, 0xDD, 0x2A, 0xBD, 0x1E, 0x9C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x9D, 0x0E,
		0x7C, 0x0E, 0xBE, 0x16, 0xBE, 0x1E, 0xBF, 0x6B, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73,
		0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x5F, 0x3E, 0x3F,
		0x5A, 0x5B, 0xB5, 0x7F, 0xB5, 0x7F, 0xB6, 0x7F, 0xB6, 0x7F, 0xB7, 0x7F, 0xB7, 0x7B, 0xB8, 0x7B,
		0xB9, 0x7B, 0xDA, 0x7B, 0xDB, 0x7B, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F,
		0xDC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDC, 0x7F, 0xDB, 0x7F, 0xFC, 0x7F, 0xDB, 0x7F, 0xF4, 0x5E, 0xB4, 0x56,
		0xD5, 0x5E, 0xB2, 0x5E, 0xB0, 0x62, 0xAF, 0x6A, 0xF0, 0x6E, 0x10, 0x73, 0x30, 0x77, 0x51, 0x7B,
		0x51, 0x7B, 0x51, 0x7B, 0x51, 0x77, 0x31, 0x77, 0x31, 0x77, 0x12, 0x73, 0x12, 0x73, 0x13, 0x6F,
		0xF3, 0x6A, 0xF3, 0x6A, 0x15, 0x67, 0x58, 0x67, 0x9B, 0x6F, 0xFE, 0x7B, 0xFD, 0x7F, 0xDB, 0x7F,
		0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xFB, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD6, 0x7F, 0xB4, 0x7F,
		0x53, 0x7B, 0x11, 0x73, 0xD0, 0x6E, 0xF0, 0x6E, 0x10, 0x73, 0x30, 0x77, 0x50, 0x7B, 0x50, 0x7B,
		0x50, 0x7B, 0x50, 0x7B, 0x2F, 0x77, 0x0F, 0x77, 0xCF, 0x6E, 0xCF, 0x6E, 0x0F, 0x77, 0x71, 0x7B,
		0xB2, 0x7F, 0xD4, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7B,
		0xDB, 0x7B, 0xDC, 0x7B, 0xDD, 0x7B, 0xDD, 0x7B, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x73, 0xDD, 0x77,
		0xBC, 0x73, 0xBC, 0x73, 0xBB, 0x73, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x7B, 0x06, 0x9A, 0x16,
		0x1C, 0x3B, 0xBE, 0x63, 0xFB, 0x2A, 0xDB, 0x26, 0xBE, 0x6B, 0x9E, 0x63, 0x3D, 0x47, 0xDB, 0x2A,
		0x9A, 0x12, 0x9A, 0x12, 0xDB, 0x22, 0xBB, 0x1E, 0x7A, 0x06, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDC, 0x2A, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x12, 0x7C, 0x12, 0x3D, 0x4B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x1E, 0x3B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x9F, 0x63, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x9C, 0x16, 0x1D, 0x43, 0xBF, 0x6B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0x1D, 0x3B, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x12,
		0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x9C, 0x16, 0x3D, 0x4B, 0xDF, 0x73,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x7E, 0x57,
		0xBC, 0x1E, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E,
		0x1D, 0x3B, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7B, 0x7E, 0x57, 0xDD, 0x26, 0x9C, 0x0E, 0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0x7F, 0x53,
		0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x63, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0xFE, 0x32, 0xDB, 0x2A, 0x72, 0x73, 0x91, 0x7B, 0x92, 0x7B,
		0x92, 0x7B, 0x93, 0x7B, 0x94, 0x7B, 0x95, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xFA, 0x7F, 0x76, 0x73, 0xF6, 0x56, 0xB3, 0x52, 0x2D, 0x56, 0x09, 0x5A, 0x48, 0x66,
		0xA9, 0x72, 0x0A, 0x77, 0x2B, 0x7B, 0x4B, 0x7B, 0x4B, 0x7F, 0x4C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B,
		0x4C, 0x7B, 0x2D, 0x77, 0xEE, 0x72, 0xCF, 0x6A, 0xB0, 0x62, 0x8F, 0x5E, 0x6F, 0x56, 0x70, 0x52,
		0xB3, 0x52, 0x5A, 0x67, 0xDC, 0x7B, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD7, 0x7B,
		0xD6, 0x7B, 0xD4, 0x7F, 0xB2, 0x7F, 0x6F, 0x7B, 0x2D, 0x77, 0xAB, 0x6E, 0x6A, 0x66, 0x89, 0x6E,
		0xC9, 0x72, 0x0A, 0x77, 0x2A, 0x7B, 0x2A, 0x7B, 0x2A, 0x7B, 0x09, 0x77, 0x08, 0x77, 0xA8, 0x72,
		0x67, 0x6A, 0x87, 0x6E, 0xE9, 0x76, 0x4B, 0x7B, 0x8E, 0x7F, 0xB0, 0x7F, 0xD3, 0x7F, 0xD4, 0x7B,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F,
		0xD5, 0x7B, 0xD6, 0x7B, 0xB7, 0x7B, 0xB8, 0x7B, 0xB9, 0x7B, 0xBA, 0x7B, 0xBB, 0x7B, 0xBB, 0x77,
		0xBB, 0x73, 0xBC, 0x6F, 0xBB, 0x6F, 0xBB, 0x6F, 0x9A, 0x6F, 0x99, 0x6F, 0x79, 0x6B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02,
		0x9B, 0x0E, 0xDC, 0x2A, 0x5E, 0x4F, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x32, 0xDB, 0x2A,
		0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x6F, 0x5D, 0x53, 0xFC, 0x32, 0xBA, 0x1E,
		0x7A, 0x0E, 0x59, 0x06, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDC, 0x2A, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x12, 0x3D, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x1A, 0xDF, 0x73, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDD, 0x26, 0x7C, 0x12, 0x7B, 0x0E, 0xBC, 0x26,
		0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0x9B, 0x16, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12,
		0xDC, 0x26, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3B, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9E, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3E, 0x43,
		0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0x1E, 0x33, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F,
		0xBF, 0x6B, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x3F, 0x47,
		0xBD, 0x1A, 0x54, 0x67, 0x92, 0x7B, 0x92, 0x7B, 0x93, 0x7B, 0x94, 0x7B, 0x95, 0x7B, 0xB5, 0x7B,
		0xB6, 0x7B, 0xB7, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7F, 0xD9, 0x7F, 0xD4, 0x56,
		0x50, 0x4A, 0x2C, 0x52, 0x09, 0x5A, 0x48, 0x66, 0xA9, 0x6E, 0xEA, 0x76, 0x2A, 0x7B, 0x2B, 0x7B,
		0x4C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x2D, 0x7B, 0x2F, 0x77, 0x11, 0x6F,
		0x13, 0x6B, 0x36, 0x67, 0x58, 0x67, 0xF5, 0x5A, 0x71, 0x4E, 0x71, 0x4E, 0xB9, 0x77, 0xFB, 0x7F,
		0xDB, 0x7B, 0xDA, 0x7B, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xB2, 0x7F, 0x90, 0x7B,
		0x0E, 0x77, 0xAB, 0x6A, 0x6A, 0x6A, 0xAA, 0x6E, 0xEA, 0x76, 0x0A, 0x7B, 0x2A, 0x7B, 0x4A, 0x7B,
		0x4A, 0x7B, 0x29, 0x7B, 0x09, 0x77, 0xC8, 0x72, 0x87, 0x6E, 0x88, 0x6E, 0x09, 0x77, 0x6B, 0x7F,
		0x8E, 0x7F, 0xB1, 0x7F, 0xB3, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B,
		0xB9, 0x7B, 0xBA, 0x7B, 0xBA, 0x7B, 0xBB, 0x77, 0xBB, 0x73, 0xBB, 0x6F, 0x9B, 0x6F, 0x9A, 0x6F,
		0x9A, 0x6F, 0x99, 0x6F, 0x78, 0x6B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x7A, 0x06, 0xBB, 0x1E, 0x3D, 0x3F, 0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFB, 0x2E, 0xDB, 0x26, 0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x9E, 0x63, 0x5D, 0x4B, 0xFC, 0x32, 0xBB, 0x1A,
		0x7A, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2A, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x9C, 0x12, 0x3E, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7E, 0x57,
		0x9D, 0x12, 0x9C, 0x12, 0xDD, 0x26, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xBF, 0x6B, 0x9B, 0x16, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x12, 0x7B, 0x12, 0xBC, 0x1E, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x2E, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9E, 0x67, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x9C, 0x12, 0x7C, 0x12, 0x5E, 0x4F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1E, 0x3B, 0xBE, 0x16, 0xBE, 0x16, 0xDE, 0x22,
		0xBF, 0x6B, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63,
		0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x5F, 0x3E, 0x3F, 0x5A, 0x57, 0xB6, 0x7F, 0xB7, 0x7B,
		0xB7, 0x7B, 0xB8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDB, 0x7F, 0xFB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xFC, 0x7F, 0xDA, 0x7B, 0x16, 0x5F, 0xB3, 0x5A, 0x91, 0x5E, 0xAF, 0x66, 0xCF, 0x6E,
		0x10, 0x77, 0x50, 0x7B, 0x71, 0x7B, 0x71, 0x7B, 0x92, 0x7F, 0x92, 0x7F, 0x92, 0x7F, 0x92, 0x7F,
		0x72, 0x7B, 0x73, 0x7B, 0x74, 0x77, 0x55, 0x73, 0x57, 0x6F, 0x99, 0x6F, 0xDD, 0x77, 0xFF, 0x7B,
		0xBC, 0x73, 0x77, 0x6F, 0xDB, 0x7F, 0xFC, 0x7F, 0xFC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F,
		0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F,
		0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F,
		0xD9, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xB5, 0x7F, 0x53, 0x77, 0x12, 0x6F, 0x11, 0x73, 0x30, 0x77,
		0x51, 0x7B, 0x71, 0x7B, 0x71, 0x7F, 0x91, 0x7F, 0x91, 0x7F, 0x91, 0x7B, 0x70, 0x7B, 0x4F, 0x7B,
		0x0F, 0x77, 0x0F, 0x77, 0x70, 0x7B, 0x92, 0x7F, 0xB4, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F, 0xDB, 0x7B, 0xDB, 0x7B, 0xDB, 0x7B, 0xDC, 0x7B,
		0xDC, 0x7B, 0xBC, 0x77, 0xBC, 0x73, 0xBB, 0x73, 0xBB, 0x73, 0xBB, 0x73, 0x9A, 0x73, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x9A, 0x0E, 0xFC, 0x32, 0x7E, 0x57, 0xDF, 0x73, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDB, 0x26,
		0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x7E, 0x5B, 0xBB, 0x22, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x58, 0x02, 0x57, 0x02, 0x57, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFC, 0x2A, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x1A, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBD, 0x1E, 0x9B, 0x12, 0x99, 0x12, 0xDF, 0x73, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x5F, 0x7B, 0x0E, 0x7B, 0x0E,
		0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7C, 0x0E, 0x7C, 0x0E, 0x7B, 0x12, 0x7E, 0x57,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9E, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x67,
		0x9C, 0x12, 0xBC, 0x1E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0x3E, 0x4B, 0xFD, 0x2E, 0x1D, 0x3B, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7B, 0xBE, 0x1E, 0xBE, 0x16, 0xBE, 0x16, 0x5F, 0x4F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F,
		0xDF, 0x6F, 0x9F, 0x63, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x1E, 0x37, 0xDB, 0x2E, 0x93, 0x7B, 0x94, 0x7B, 0x95, 0x7B, 0xB5, 0x7B, 0xB6, 0x7B, 0xB6, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xDA, 0x7B, 0xFA, 0x7F, 0x76, 0x73, 0x0E, 0x46,
		0xCB, 0x41, 0xC8, 0x4D, 0x07, 0x5A, 0x68, 0x6A, 0xA9, 0x72, 0x09, 0x77, 0x2A, 0x7B, 0x4B, 0x7B,
		0x4B, 0x7B, 0x6C, 0x7B, 0x6C, 0x7B, 0x4C, 0x7B, 0x4C, 0x7B, 0x2D, 0x77, 0x0F, 0x73, 0x11, 0x6F,
		0x14, 0x67, 0x58, 0x67, 0x9B, 0x6F, 0xDE, 0x7B, 0xFF, 0x7F, 0xFB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7B,
		0xDB, 0x7B, 0xDB, 0x7F, 0xDA, 0x7B, 0xDB, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xB4, 0x7F, 0x71, 0x7B,
		0x0F, 0x73, 0xAC, 0x66, 0xAB, 0x6E, 0xEA, 0x72, 0x2B, 0x7B, 0x4B, 0x7B, 0x4B, 0x7B, 0x6B, 0x7B,
		0x6B, 0x7B, 0x4B, 0x7B, 0x2A, 0x7B, 0x09, 0x77, 0xA8, 0x72, 0xA8, 0x72, 0x2A, 0x7B, 0x6D, 0x7B,
		0xAF, 0x7F, 0xB2, 0x7F, 0xD4, 0x7F, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B,
		0xD8, 0x7B, 0xB9, 0x7B, 0xB9, 0x7B, 0xBA, 0x7B, 0xBA, 0x77, 0x99, 0x73, 0x99, 0x6F, 0x79, 0x6B,
		0x79, 0x6B, 0x78, 0x6B, 0x57, 0x6B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x12, 0x7E, 0x5B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDB, 0x26, 0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7D, 0x57, 0x79, 0x06, 0x59, 0x02, 0x58, 0x02, 0x57, 0x02, 0x57, 0x02, 0x57, 0x02,
		0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2A, 0x9B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x12, 0x7B, 0x12, 0x7C, 0x12,
		0x3E, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3E, 0x4B, 0x9C, 0x12,
		0x9A, 0x12, 0x1B, 0x3F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B,
		0xDC, 0x2A, 0x7B, 0x0E, 0x7B, 0x0E, 0x1C, 0x3B, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xBB, 0x26, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0xDC, 0x2A, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47,
		0x3D, 0x47, 0x1D, 0x3B, 0x9C, 0x16, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7B, 0x1D, 0x3B, 0x7C, 0x12, 0x7C, 0x12, 0xDD, 0x2E, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x36, 0x9C, 0x12, 0x9C, 0x12, 0x9E, 0x67, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x67, 0x9C, 0x12, 0x5E, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x2E, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xBC, 0x1E,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1E, 0x37, 0xBE, 0x16, 0xBE, 0x16,
		0x1E, 0x37, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x67, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x3F, 0x43, 0xBD, 0x1E, 0x76, 0x63, 0x95, 0x7B,
		0x95, 0x7B, 0xB6, 0x7B, 0xB6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xDA, 0x7B, 0xFA, 0x7F, 0x13, 0x63, 0xAB, 0x39, 0x89, 0x3D, 0xA7, 0x4D, 0xE7, 0x5D, 0x67, 0x6A,
		0xC8, 0x72, 0x09, 0x77, 0x2A, 0x7B, 0x4B, 0x7B, 0x4B, 0x7B, 0x6C, 0x7B, 0x6C, 0x7B, 0x4C, 0x7B,
		0x4C, 0x7B, 0x2E, 0x7B, 0x30, 0x77, 0x12, 0x6F, 0x14, 0x67, 0x79, 0x67, 0xBC, 0x6F, 0xDE, 0x7B,
		0xDE, 0x7B, 0xDB, 0x7F, 0xDB, 0x7B, 0xDB, 0x7F, 0xDB, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B,
		0xD7, 0x7B, 0xD6, 0x7B, 0xB4, 0x7F, 0x71, 0x7B, 0xEF, 0x6E, 0xAD, 0x66, 0xCB, 0x6E, 0x0B, 0x77,
		0x2B, 0x7B, 0x4B, 0x7B, 0x6B, 0x7B, 0x6B, 0x7B, 0x6B, 0x7F, 0x6B, 0x7F, 0x4A, 0x7B, 0x29, 0x7B,
		0xC8, 0x72, 0xA8, 0x72, 0x2A, 0x7B, 0x6D, 0x7F, 0xB0, 0x7F, 0xD2, 0x7F, 0xD5, 0x7F, 0xD6, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xB8, 0x7B, 0xB9, 0x7B, 0xB9, 0x7B,
		0xB9, 0x77, 0x99, 0x73, 0x99, 0x6F, 0x78, 0x6B, 0x78, 0x6B, 0x57, 0x6B, 0x57, 0x6B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xFC, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x2E, 0xDC, 0x26,
		0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7E, 0x5B, 0x79, 0x0A, 0x59, 0x02,
		0x58, 0x02, 0x57, 0x02, 0x57, 0x02, 0x57, 0x02, 0x57, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFC, 0x2A, 0x9A, 0x0E, 0x9B, 0x0E, 0x7B, 0x0E, 0x7A, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7B, 0x12, 0x7B, 0x12, 0xBC, 0x1E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7B, 0x9C, 0x1A, 0x9C, 0x12, 0x99, 0x12, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x9C, 0x1A, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0xDC, 0x2A, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4F, 0x7B, 0x0E,
		0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0xDD, 0x2A, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1D, 0x3B, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0xBC, 0x1E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5E, 0x4F,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x67,
		0x9C, 0x12, 0xBE, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xBC, 0x1A, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x5F, 0x4B, 0xBE, 0x16, 0xBE, 0x16, 0xDE, 0x22, 0xBF, 0x6B, 0xDF, 0x73, 0xDF, 0x73,
		0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63,
		0x9F, 0x5F, 0x3E, 0x3F, 0x7B, 0x5B, 0xB8, 0x7B, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xFB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xFC, 0x7F, 0xFB, 0x7F, 0xF3, 0x5E, 0x30, 0x4A,
		0x2F, 0x56, 0x6E, 0x5E, 0x8E, 0x66, 0xCE, 0x72, 0x0F, 0x77, 0x50, 0x7B, 0x70, 0x7B, 0x71, 0x7B,
		0x91, 0x7F, 0x91, 0x7F, 0x91, 0x7F, 0x92, 0x7F, 0x92, 0x7B, 0x73, 0x7B, 0x54, 0x77, 0x56, 0x73,
		0x78, 0x6F, 0xBB, 0x73, 0xDE, 0x77, 0xDF, 0x7B, 0xDE, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F,
		0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F,
		0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDB, 0x7F,
		0xDC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xD7, 0x7F, 0x96, 0x7B,
		0x34, 0x73, 0x13, 0x6F, 0x32, 0x77, 0x51, 0x7B, 0x71, 0x7B, 0x91, 0x7F, 0x91, 0x7F, 0x91, 0x7F,
		0x92, 0x7F, 0x91, 0x7F, 0x91, 0x7F, 0x70, 0x7B, 0x2F, 0x77, 0x0F, 0x77, 0x71, 0x7B, 0xB3, 0x7F,
		0xD4, 0x7F, 0xD6, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xBA, 0x7B, 0xBA, 0x77, 0xBA, 0x73, 0x9A, 0x73,
		0x9A, 0x6F, 0x79, 0x6F, 0x79, 0x6F, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xFC, 0x2E, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x2E, 0xDD, 0x26, 0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x57, 0x02, 0x57, 0x02, 0x57, 0x02,
		0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7E, 0x57, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47,
		0x3D, 0x47, 0xDC, 0x2A, 0x9B, 0x16, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x12, 0x7B, 0x12, 0x9E, 0x5F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x32, 0x7C, 0x12, 0x7C, 0x12,
		0x9A, 0x12, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5E, 0x4F, 0x9C, 0x12,
		0x9C, 0x12, 0x7B, 0x12, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x9E, 0x63, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x67, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0xBC, 0x1A, 0xFD, 0x2E, 0xDD, 0x26, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xBC, 0x22, 0x9E, 0x5F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5F, 0x4B, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0x7F, 0x57, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x5F, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0xFE, 0x2E, 0xFB, 0x32, 0x96, 0x77,
		0xB6, 0x7B, 0xB7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xFB, 0x7F, 0xB6, 0x77, 0xAA, 0x3D, 0x27, 0x31, 0x67, 0x41, 0xA6, 0x4D, 0xE6, 0x59, 0x47, 0x66,
		0x87, 0x6E, 0xC8, 0x72, 0x09, 0x77, 0x2A, 0x7B, 0x2A, 0x7B, 0x2A, 0x7B, 0x2A, 0x7B, 0x2B, 0x7B,
		0x0B, 0x77, 0xEC, 0x72, 0xCE, 0x6E, 0xF1, 0x66, 0x15, 0x63, 0x79, 0x67, 0xDD, 0x73, 0xDF, 0x7B,
		0xDD, 0x7F, 0xDA, 0x7B, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD7, 0x7B, 0xD6, 0x7B, 0xB4, 0x7F, 0x72, 0x77, 0xF0, 0x6A, 0xAE, 0x66, 0xCC, 0x6E, 0x0B, 0x77,
		0x2B, 0x7B, 0x4B, 0x7B, 0x4C, 0x7B, 0x6C, 0x7F, 0x6B, 0x7B, 0x6B, 0x7F, 0x4B, 0x7B, 0x2A, 0x7B,
		0xE9, 0x76, 0xA8, 0x72, 0x2A, 0x7B, 0x8D, 0x7F, 0xB0, 0x7F, 0xD3, 0x7F, 0xD5, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xB6, 0x7B, 0xB6, 0x7B, 0xB7, 0x7B, 0xB7, 0x7B,
		0x97, 0x77, 0x97, 0x73, 0x77, 0x6F, 0x57, 0x6B, 0x36, 0x67, 0x35, 0x67, 0x34, 0x67, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDC, 0x26,
		0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4F,
		0x9B, 0x16, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x3D, 0x47, 0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0x1D, 0x3B, 0x7B, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0xDD, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x36, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x7B, 0x12,
		0x7B, 0x0E, 0x5D, 0x4F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E,
		0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x9E, 0x63,
		0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67,
		0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xFD, 0x36,
		0x5E, 0x4B, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFE, 0x32, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x1E, 0x37, 0xDF, 0x6F, 0xDF, 0x6F,
		0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x67, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x3F, 0x43, 0xBD, 0x1E, 0x77, 0x67, 0xB6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xFB, 0x7F, 0xAF, 0x5E, 0x27, 0x2D, 0x26, 0x35,
		0x46, 0x3D, 0x86, 0x49, 0xC6, 0x55, 0x06, 0x5E, 0x26, 0x66, 0x67, 0x6A, 0xA8, 0x72, 0xC8, 0x72,
		0xE9, 0x76, 0xE9, 0x76, 0xE9, 0x76, 0xEA, 0x76, 0xCA, 0x72, 0xAB, 0x6E, 0xAD, 0x66, 0xB0, 0x62,
		0xD3, 0x5E, 0x59, 0x63, 0xBD, 0x73, 0xDE, 0x7B, 0xDE, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7F, 0xDA, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xB4, 0x7B, 0x72, 0x77,
		0xF0, 0x6A, 0xAE, 0x66, 0xCC, 0x6E, 0xEB, 0x76, 0x0B, 0x7B, 0x4B, 0x7B, 0x4B, 0x7B, 0x6B, 0x7F,
		0x6B, 0x7B, 0x4B, 0x7B, 0x4A, 0x7B, 0x2A, 0x7B, 0xC9, 0x72, 0xC9, 0x72, 0x2B, 0x7B, 0x8D, 0x7F,
		0xB0, 0x7F, 0xD3, 0x7B, 0xD5, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B,
		0xB5, 0x7B, 0xB5, 0x7B, 0xB6, 0x7B, 0xB6, 0x7B, 0x96, 0x77, 0x96, 0x73, 0x56, 0x6F, 0x55, 0x6B,
		0x35, 0x67, 0x14, 0x67, 0x13, 0x67, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDC, 0x26, 0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0x3D, 0x43, 0x9C, 0x16, 0x7B, 0x12, 0x7B, 0x12,
		0xDD, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x2E, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7B, 0x0E, 0xDC, 0x2A, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47,
		0x3D, 0x47, 0x1D, 0x3B, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x67, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x7C, 0x12, 0x7C, 0x12, 0x7D, 0x12, 0x7D, 0x12,
		0xBD, 0x1E, 0x7E, 0x57, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x1E, 0xDF, 0x6F, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67,
		0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x1E, 0x3B, 0x7B, 0x5F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F,
		0xFA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xFB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xFC, 0x7F,
		0xB8, 0x7B, 0x2F, 0x4E, 0xEE, 0x49, 0x0E, 0x4E, 0x2D, 0x56, 0x4E, 0x5A, 0x6E, 0x5E, 0x8E, 0x66,
		0xAE, 0x6A, 0xAE, 0x6E, 0xCE, 0x6E, 0xEF, 0x72, 0xEF, 0x72, 0xEF, 0x72, 0xEF, 0x72, 0xF0, 0x72,
		0x10, 0x73, 0xF1, 0x72, 0xF2, 0x6E, 0xF3, 0x66, 0x15, 0x67, 0x79, 0x67, 0xDD, 0x73, 0xDF, 0x7B,
		0xDE, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F,
		0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xFB, 0x7F, 0xFB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xD9, 0x7F, 0xD7, 0x7F, 0xB6, 0x7B, 0x54, 0x73, 0xF3, 0x6E, 0x12, 0x73, 0x31, 0x77,
		0x51, 0x7B, 0x71, 0x7B, 0x71, 0x7F, 0x91, 0x7F, 0x91, 0x7F, 0x91, 0x7F, 0x71, 0x7B, 0x50, 0x7B,
		0x10, 0x77, 0x30, 0x77, 0x91, 0x7F, 0xB3, 0x7F, 0xD5, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7B, 0xB8, 0x7B,
		0xB8, 0x7B, 0xB8, 0x77, 0x98, 0x77, 0x78, 0x73, 0x77, 0x6F, 0x57, 0x6F, 0x56, 0x6F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDC, 0x26,
		0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBA, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x1C, 0x3B, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xBF, 0x6B, 0x9B, 0x16, 0x7B, 0x12, 0xDC, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x2E, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x5E, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E,
		0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67,
		0x7C, 0x12, 0x7C, 0x12, 0x7D, 0x12, 0x1E, 0x3B, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73,
		0xDD, 0x26, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x7F, 0x57, 0xDF, 0x6F,
		0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x5F, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0xFE, 0x2E, 0xFC, 0x2E, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7F, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xFA, 0x7F, 0xF8, 0x7F, 0x2B, 0x52, 0x06, 0x2D, 0x26, 0x39, 0x46, 0x3D,
		0x66, 0x45, 0x86, 0x49, 0xA6, 0x51, 0xC6, 0x55, 0xE6, 0x59, 0x06, 0x5E, 0x27, 0x62, 0x47, 0x66,
		0x27, 0x62, 0x27, 0x62, 0x28, 0x62, 0x28, 0x5E, 0x29, 0x5E, 0x4A, 0x5E, 0x4C, 0x5E, 0x6E, 0x5A,
		0x90, 0x56, 0xF5, 0x5A, 0x9A, 0x67, 0xDD, 0x73, 0xDE, 0x7B, 0xDB, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xB4, 0x7F, 0x91, 0x7B,
		0x2F, 0x77, 0x8C, 0x66, 0x6B, 0x66, 0x8A, 0x6E, 0xCA, 0x72, 0xEA, 0x76, 0x0A, 0x77, 0x2A, 0x7B,
		0x2A, 0x7B, 0x2A, 0x7B, 0x0A, 0x77, 0xC9, 0x72, 0xA8, 0x6E, 0x0A, 0x77, 0x6C, 0x7B, 0x8F, 0x7B,
		0xB1, 0x7F, 0xD3, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F,
		0xB4, 0x7F, 0xB4, 0x7B, 0xB4, 0x7B, 0x94, 0x7B, 0x94, 0x7B, 0x74, 0x77, 0x54, 0x73, 0x33, 0x6B,
		0x12, 0x6B, 0xF2, 0x6A, 0x11, 0x6B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDC, 0x26, 0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBA, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3D, 0x3F, 0xFC, 0x2A, 0xFC, 0x2A, 0x7D, 0x57,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x67, 0x7A, 0x0E, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0x7B, 0x12,
		0xDC, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFD, 0x32, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x5E, 0x4F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7A, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63, 0x9E, 0x63,
		0x9E, 0x63, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7B, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x67, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x9C, 0x12, 0x7D, 0x12, 0xFD, 0x2E, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7B, 0x5E, 0x4F, 0x9D, 0x1A, 0x7D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0x1E, 0x37, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x67,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x3F, 0x43, 0xBD, 0x1E,
		0x97, 0x6B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7F, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xFA, 0x7F, 0xF8, 0x7F, 0x8C, 0x5E,
		0x26, 0x35, 0x47, 0x39, 0x46, 0x3D, 0x66, 0x45, 0x86, 0x49, 0xA6, 0x4D, 0xC6, 0x55, 0xE6, 0x59,
		0xE6, 0x5D, 0x07, 0x5E, 0x27, 0x62, 0x27, 0x62, 0x27, 0x62, 0x27, 0x62, 0x08, 0x5E, 0x08, 0x5A,
		0x09, 0x5A, 0x0A, 0x56, 0x0B, 0x56, 0x2D, 0x52, 0x4E, 0x4E, 0x92, 0x52, 0x16, 0x57, 0x7A, 0x67,
		0xDD, 0x77, 0xDB, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B,
		0xD7, 0x7B, 0xD6, 0x7B, 0xD4, 0x7F, 0x92, 0x7F, 0x6F, 0x7B, 0xED, 0x72, 0x8A, 0x6A, 0x69, 0x6A,
		0x89, 0x6E, 0xA9, 0x72, 0xC9, 0x72, 0xE9, 0x76, 0xE9, 0x76, 0xC9, 0x72, 0xA9, 0x72, 0xA8, 0x6E,
		0xE9, 0x72, 0x4B, 0x7B, 0x8D, 0x7B, 0xB0, 0x7F, 0xD2, 0x7F, 0xD4, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7B, 0xB3, 0x7F, 0xB3, 0x7F, 0xB3, 0x7B, 0x93, 0x7B,
		0x93, 0x7B, 0x73, 0x77, 0x53, 0x73, 0x12, 0x6B, 0xF2, 0x6A, 0xF1, 0x6A, 0x11, 0x6F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDC, 0x2A,
		0xFF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFB, 0x2A, 0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E, 0x7D, 0x57, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x99, 0x12, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7B, 0x0E, 0x9A, 0x12, 0x99, 0x12, 0xDA, 0x26, 0x7D, 0x57, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDC, 0x2A, 0x7B, 0x0E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x5E, 0x4F, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x67, 0x7B, 0x0E,
		0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67,
		0x9C, 0x12, 0x7C, 0x12, 0x9E, 0x5F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x7E, 0x57, 0x1E, 0x3B, 0x9D, 0x1A, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xDE, 0x26, 0xDF, 0x6F,
		0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63,
		0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x5F, 0x1E, 0x3F, 0x7B, 0x5B, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xF9, 0x7F, 0xF9, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F,
		0xFA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xFB, 0x7F, 0xFA, 0x7F, 0x13, 0x6B, 0x2E, 0x4E, 0x2F, 0x4E, 0x2F, 0x52, 0x4E, 0x56, 0x4E, 0x5A,
		0x6E, 0x5E, 0x6E, 0x5E, 0x8E, 0x62, 0x8E, 0x66, 0xAE, 0x66, 0xAE, 0x6A, 0xAF, 0x6A, 0xAF, 0x6A,
		0xCF, 0x6A, 0xCF, 0x6A, 0xD0, 0x6A, 0xD0, 0x6A, 0xB0, 0x66, 0xB1, 0x66, 0xB1, 0x62, 0xB2, 0x5E,
		0xB3, 0x5E, 0xD4, 0x5A, 0xF6, 0x5A, 0x59, 0x63, 0xBC, 0x6F, 0xFD, 0x7F, 0xDB, 0x7F, 0xDC, 0x7F,
		0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD6, 0x7F,
		0xB4, 0x7F, 0x93, 0x7B, 0x51, 0x7B, 0x30, 0x77, 0x10, 0x73, 0x10, 0x73, 0x0F, 0x77, 0x0F, 0x77,
		0x0F, 0x77, 0x0F, 0x77, 0x2F, 0x77, 0x50, 0x7B, 0x71, 0x7B, 0xB2, 0x7F, 0xB4, 0x7F, 0xD5, 0x7F,
		0xD7, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xB7, 0x7F, 0xB6, 0x7B, 0xB6, 0x7B, 0x96, 0x7B, 0x76, 0x77, 0x55, 0x73,
		0x55, 0x73, 0x55, 0x73, 0x54, 0x77, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x2E, 0xDC, 0x26, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFB, 0x2A, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x99, 0x12, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x9B, 0x16, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3D, 0x47,
		0x7B, 0x0E, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x9B, 0x16,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0xFD, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x5E, 0x4F, 0x9C, 0x12, 0x5D, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7C, 0x12, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x9C, 0x12, 0x9C, 0x12, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x1E, 0x3B, 0xBD, 0x1E, 0x9D, 0x12, 0xFD, 0x2E,
		0x3E, 0x4B, 0x1E, 0x3B, 0xFD, 0x2E, 0xFD, 0x2E, 0xFD, 0x2E, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x7F, 0x57, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F,
		0x9F, 0x5F, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0xFE, 0x2E,
		0xFB, 0x32, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xF9, 0x7F, 0xD8, 0x7F, 0xF0, 0x66, 0xCB, 0x45, 0xAB, 0x41,
		0xCA, 0x45, 0xA9, 0x45, 0xA9, 0x45, 0xA8, 0x4D, 0xC8, 0x4D, 0xC8, 0x51, 0xE7, 0x55, 0xE7, 0x59,
		0x08, 0x5A, 0x28, 0x5E, 0x28, 0x62, 0x28, 0x62, 0x29, 0x62, 0x49, 0x62, 0x49, 0x62, 0x4A, 0x5E,
		0x2A, 0x5E, 0x2B, 0x5A, 0x2C, 0x5A, 0x2D, 0x56, 0x4E, 0x52, 0x4F, 0x4E, 0x71, 0x4E, 0xB4, 0x52,
		0x38, 0x5B, 0xBB, 0x73, 0xDA, 0x7F, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B, 0xDA, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD7, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD3, 0x7F, 0xB1, 0x7F, 0x8F, 0x7F, 0x6D, 0x7B, 0x4B, 0x7B,
		0x2B, 0x77, 0x0A, 0x77, 0x0A, 0x77, 0xE9, 0x76, 0x0A, 0x77, 0x0A, 0x77, 0x2A, 0x7B, 0x4B, 0x7B,
		0x6C, 0x7B, 0x8E, 0x7B, 0xB0, 0x7F, 0xD2, 0x7F, 0xD4, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7F,
		0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0x92, 0x7B, 0x92, 0x7B,
		0x71, 0x7B, 0x51, 0x77, 0x31, 0x73, 0x10, 0x6F, 0xF0, 0x6E, 0xEF, 0x6E, 0x0F, 0x73, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x7E, 0x57, 0x9A, 0x12, 0x5A, 0x06,
		0x3D, 0x43, 0xBF, 0x6B, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFB, 0x2A, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x16, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7B, 0x7A, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7A, 0x0E, 0x7A, 0x0E, 0x7B, 0x0E, 0x7A, 0x0E, 0xBB, 0x1E, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3D, 0x47, 0x7B, 0x0E, 0x1C, 0x3B, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0xDC, 0x2E, 0x9B, 0x12, 0x9B, 0x16, 0x1D, 0x3B,
		0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDD, 0x26, 0x9C, 0x12,
		0x5E, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDC, 0x2A, 0xDC, 0x2A,
		0xDC, 0x2A, 0xDC, 0x2A, 0xDC, 0x2A, 0xDC, 0x2A, 0xDC, 0x2A, 0xDC, 0x2A, 0x9B, 0x16, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12,
		0x7B, 0x12, 0x7C, 0x12, 0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67,
		0x9C, 0x12, 0x9C, 0x12, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3E, 0x4B,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9F, 0x67, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xDF, 0x73, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x3E, 0x3F,
		0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x67, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x3E, 0x3F, 0xBD, 0x1E, 0x97, 0x6B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xF9, 0x7F, 0xD7, 0x7F,
		0xD0, 0x62, 0x0D, 0x4A, 0x0D, 0x4A, 0xEC, 0x49, 0xEB, 0x49, 0xEA, 0x4D, 0xE9, 0x4D, 0xE9, 0x51,
		0x08, 0x56, 0x08, 0x5A, 0x08, 0x5E, 0x28, 0x5E, 0x28, 0x62, 0x48, 0x62, 0x48, 0x66, 0x49, 0x62,
		0x49, 0x66, 0x49, 0x62, 0x4A, 0x62, 0x4B, 0x5E, 0x2B, 0x5A, 0x2B, 0x5A, 0x4D, 0x5A, 0x4E, 0x56,
		0x6F, 0x56, 0x70, 0x52, 0x92, 0x52, 0xB4, 0x52, 0x17, 0x57, 0x9A, 0x67, 0xDB, 0x7B, 0xDA, 0x7F,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F,
		0xB2, 0x7F, 0xB1, 0x7F, 0x8F, 0x7F, 0x8D, 0x7B, 0x6D, 0x7B, 0x6C, 0x7B, 0x6B, 0x7B, 0x4B, 0x7B,
		0x4B, 0x7B, 0x6C, 0x7B, 0x6C, 0x7F, 0x8D, 0x7F, 0x8E, 0x7F, 0xB0, 0x7F, 0xB2, 0x7F, 0xD3, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F,
		0xB3, 0x7F, 0xB2, 0x7F, 0x92, 0x7B, 0x91, 0x7B, 0x71, 0x7B, 0x50, 0x77, 0x30, 0x73, 0x10, 0x73,
		0xEF, 0x6E, 0x0F, 0x73, 0x0E, 0x77, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x6B, 0x5D, 0x4B,
		0xDB, 0x22, 0x7A, 0x0E, 0xBB, 0x22, 0xDC, 0x2A, 0x9A, 0x12, 0x9B, 0x0E, 0xBB, 0x22, 0x1D, 0x3B,
		0x7E, 0x57, 0xBF, 0x6F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x7D, 0x5B, 0x79, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBE, 0x6B, 0x9E, 0x63, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x5F, 0x7A, 0x0E, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x3D, 0x47, 0x3D, 0x47, 0x3D, 0x47,
		0x5D, 0x4F, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x32,
		0x7B, 0x0E, 0x7B, 0x0E, 0xBF, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x9E, 0x5F, 0x9C, 0x12, 0x9C, 0x12, 0x5E, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xDC, 0x2A, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7B, 0x0E, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67, 0x9C, 0x12, 0x9C, 0x12, 0x9E, 0x5F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0xBD, 0x1E, 0x9D, 0x12, 0x3E, 0x43, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7E, 0x57, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xDE, 0x22, 0xDF, 0x6F, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73,
		0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x5F,
		0x1E, 0x3B, 0x9B, 0x63, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xFB, 0x7F, 0xD9, 0x7F, 0x14, 0x67, 0xB4, 0x56, 0xB4, 0x56, 0xB3, 0x5A, 0x91, 0x5A,
		0x90, 0x5E, 0x8F, 0x62, 0xAF, 0x66, 0xCF, 0x6A, 0xEF, 0x6E, 0xF0, 0x72, 0x10, 0x77, 0x30, 0x77,
		0x30, 0x77, 0x30, 0x77, 0x50, 0x77, 0x30, 0x77, 0x30, 0x77, 0x10, 0x73, 0xF0, 0x72, 0xF1, 0x6E,
		0xD1, 0x6A, 0xD1, 0x6A, 0xD2, 0x66, 0xD3, 0x62, 0xF4, 0x62, 0xF5, 0x62, 0x16, 0x63, 0x38, 0x63,
		0x59, 0x67, 0x9B, 0x6B, 0xDD, 0x77, 0xFC, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F,
		0xDB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F,
		0xB4, 0x7F, 0xB4, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0xB3, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xB6, 0x7F, 0xB5, 0x7B,
		0x95, 0x7B, 0x95, 0x7B, 0x74, 0x77, 0x54, 0x77, 0x54, 0x77, 0x53, 0x77, 0x73, 0x7B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77,
		0x9E, 0x5B, 0xFC, 0x32, 0x9A, 0x12, 0x7A, 0x0E, 0xDB, 0x2A, 0x7D, 0x57, 0xFF, 0x77, 0xFF, 0x7F,
		0x7D, 0x53, 0x7A, 0x0A, 0xDC, 0x26, 0xBB, 0x1E, 0x7B, 0x0A, 0x9B, 0x12, 0xDC, 0x2A, 0x3D, 0x47,
		0x9E, 0x63, 0xDF, 0x73, 0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x5B, 0x79, 0x0A, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBB, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDB, 0x2A, 0x7A, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x9B, 0x16, 0x7A, 0x0E, 0x7A, 0x0E, 0xDB, 0x26, 0xFF, 0x7B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xBF, 0x6B, 0x9C, 0x16, 0x9B, 0x12, 0x9C, 0x12,
		0x5D, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDC, 0x2A, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12,
		0x7B, 0x12, 0x7B, 0x12, 0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x67,
		0x9C, 0x12, 0x9C, 0x12, 0xFD, 0x2E, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xBD, 0x1E, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0x7F, 0x5B, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x5F, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0xFE, 0x2A, 0xFB, 0x32, 0xD5, 0x7B, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xF8, 0x7F, 0x34, 0x67, 0x94, 0x4E,
		0xB5, 0x52, 0xD5, 0x56, 0xB3, 0x56, 0x4E, 0x52, 0x0B, 0x52, 0x0A, 0x5A, 0x29, 0x5E, 0x6A, 0x66,
		0x8A, 0x6E, 0xCA, 0x72, 0xEA, 0x76, 0x2A, 0x7B, 0x4B, 0x7F, 0x4B, 0x7F, 0x6B, 0x7F, 0x6C, 0x7F,
		0x4C, 0x7F, 0x4C, 0x7B, 0x2B, 0x7B, 0x0C, 0x77, 0xEC, 0x72, 0xCC, 0x6E, 0x8D, 0x66, 0x8E, 0x62,
		0x6F, 0x5A, 0x90, 0x56, 0x91, 0x56, 0xB3, 0x56, 0xF5, 0x5A, 0x16, 0x5B, 0x59, 0x63, 0xDB, 0x7B,
		0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B,
		0xD5, 0x7F, 0xD4, 0x7B, 0xD3, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F,
		0xB0, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xD2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7B, 0xD5, 0x7F,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD4, 0x7B,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xB3, 0x7F,
		0xB2, 0x7F, 0xB2, 0x7F, 0x91, 0x7B, 0x90, 0x7B, 0x70, 0x7B, 0x50, 0x77, 0x2F, 0x77, 0x0F, 0x73,
		0x0E, 0x73, 0x0E, 0x77, 0x2E, 0x77, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xFB, 0x2E, 0xFF, 0x7F,
		0xFF, 0x7F, 0xBE, 0x6B, 0x3D, 0x47, 0xBB, 0x1E, 0x7A, 0x0E, 0x9A, 0x1A, 0x3C, 0x43, 0xBE, 0x67,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x5F, 0x9B, 0x16, 0xBE, 0x67, 0xFF, 0x77,
		0x9E, 0x5F, 0x3D, 0x47, 0xDC, 0x26, 0x9B, 0x16, 0x9B, 0x12, 0xBC, 0x1A, 0xFD, 0x32, 0x7D, 0x53,
		0xBE, 0x6F, 0x7D, 0x53, 0x79, 0x0A, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBA, 0x22, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x5D, 0x4F, 0x7A, 0x0E, 0x7A, 0x0E, 0x3D, 0x47,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0xDB, 0x26, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0xDB, 0x26, 0xDF, 0x73, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63,
		0x9B, 0x16, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x5D, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xDC, 0x2A, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63, 0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x1D, 0x3B,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x1E, 0x3B, 0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x1E, 0x3B, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F,
		0xDF, 0x6F, 0xBF, 0x67, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x3E, 0x43, 0xBD, 0x1A, 0xB5, 0x73, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B,
		0xD8, 0x7F, 0xD7, 0x7F, 0x98, 0x6B, 0x7B, 0x63, 0x17, 0x5B, 0xF5, 0x5E, 0xD4, 0x5A, 0x6F, 0x52,
		0x2E, 0x4E, 0x0C, 0x4E, 0x0B, 0x52, 0x0B, 0x52, 0x0B, 0x52, 0x2A, 0x5A, 0x2A, 0x5E, 0x4A, 0x62,
		0x6A, 0x66, 0x8A, 0x6A, 0xAB, 0x6E, 0xCB, 0x72, 0x0C, 0x77, 0x2D, 0x7B, 0x4D, 0x7B, 0x4E, 0x7B,
		0x4E, 0x7B, 0x4F, 0x7B, 0x2F, 0x77, 0x10, 0x73, 0xF0, 0x6A, 0xB1, 0x62, 0xB2, 0x5A, 0xD3, 0x56,
		0xF5, 0x5A, 0x17, 0x5B, 0x37, 0x5B, 0x78, 0x67, 0xD9, 0x7B, 0xD9, 0x7F, 0xD9, 0x7B, 0xD9, 0x7B,
		0xD9, 0x7B, 0xD9, 0x7B, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7B,
		0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xB3, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0x91, 0x7B, 0x70, 0x7B,
		0x70, 0x7B, 0x4F, 0x77, 0x2F, 0x77, 0x0F, 0x73, 0x0F, 0x73, 0x0E, 0x77, 0x2E, 0x7B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xDB, 0x26, 0x9E, 0x5F, 0x1C, 0x3B, 0x9A, 0x16, 0x9A, 0x12, 0xFB, 0x2E,
		0x7D, 0x57, 0xDF, 0x77, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7E, 0x5B, 0x9A, 0x12, 0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x6F,
		0x7E, 0x53, 0x1D, 0x3B, 0xDC, 0x2A, 0xBC, 0x1A, 0xBB, 0x1E, 0x9A, 0x1A, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0xBA, 0x22, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x73, 0x9E, 0x5F, 0xDB, 0x2A,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x3D, 0x47, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63,
		0x5D, 0x4F, 0xBB, 0x1E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x1C, 0x3B, 0xBE, 0x6B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0x9E, 0x5F, 0x1D, 0x3B, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x5D, 0x4B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDC, 0x2A, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x3D, 0x47, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12,
		0x7B, 0x12, 0x7B, 0x12, 0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x63,
		0x7C, 0x12, 0x7C, 0x12, 0x9F, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9F, 0x63,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xDD, 0x26, 0x7E, 0x57, 0xFF, 0x7B, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B, 0x7E, 0x57, 0xDD, 0x26, 0x9D, 0x12,
		0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xDE, 0x26, 0xDF, 0x6F, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x63, 0x9F, 0x63,
		0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x5F, 0x1E, 0x3B, 0x9A, 0x63, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD9, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F,
		0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xFA, 0x7F,
		0xFA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xBA, 0x77, 0x38, 0x63,
		0xF5, 0x5A, 0xB3, 0x5A, 0x92, 0x56, 0x92, 0x56, 0x71, 0x52, 0x51, 0x52, 0x50, 0x4E, 0x50, 0x4E,
		0x50, 0x4E, 0x30, 0x52, 0x50, 0x52, 0x50, 0x52, 0x50, 0x56, 0x70, 0x5A, 0x70, 0x5E, 0x91, 0x5E,
		0xB1, 0x62, 0xB2, 0x66, 0xF2, 0x6A, 0x13, 0x6F, 0x34, 0x73, 0x55, 0x73, 0x55, 0x73, 0x76, 0x73,
		0x76, 0x73, 0x56, 0x6F, 0x57, 0x6F, 0x58, 0x6B, 0x79, 0x6B, 0x9B, 0x6B, 0xBC, 0x6F, 0xBC, 0x6F,
		0xDC, 0x77, 0xDB, 0x7F, 0xFA, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDB, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xB6, 0x7F, 0xB5, 0x7F, 0xB5, 0x7B, 0x95, 0x7B, 0x74, 0x7B, 0x74, 0x7B, 0x74, 0x77,
		0x73, 0x7B, 0x73, 0x7B, 0x73, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x79, 0x0A, 0x79, 0x0A,
		0x9A, 0x16, 0x3D, 0x4B, 0xBF, 0x6F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7E, 0x5B, 0x9A, 0x12, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xDF, 0x77, 0x3D, 0x43,
		0x7B, 0x06, 0x5A, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0xDC, 0x2A, 0xDC, 0x2A, 0xDC, 0x2A, 0xDB, 0x26, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x9B, 0x0E,
		0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9B, 0x12, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12,
		0x7B, 0x12, 0x9C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x7C, 0x12,
		0x7C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xBD, 0x1E, 0xFD, 0x2E, 0xFD, 0x2E, 0xFD, 0x2E, 0xBD, 0x1E,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x7F, 0x57, 0xDF, 0x6F, 0xDF, 0x6F,
		0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x5F, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0xFE, 0x2E, 0xFB, 0x32, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xF8, 0x7F, 0x95, 0x77, 0xCA, 0x41, 0x48, 0x35, 0x88, 0x41, 0xE9, 0x4D, 0x6C, 0x5A,
		0xAD, 0x66, 0xAD, 0x62, 0x0A, 0x4E, 0x67, 0x41, 0x86, 0x49, 0xE7, 0x51, 0xE8, 0x55, 0x09, 0x5A,
		0x29, 0x5A, 0x29, 0x5A, 0x2A, 0x5A, 0x2A, 0x56, 0x2B, 0x56, 0x0B, 0x52, 0x0C, 0x52, 0x0D, 0x4E,
		0x2F, 0x4E, 0x70, 0x52, 0x92, 0x56, 0xD3, 0x5A, 0xF4, 0x62, 0x15, 0x63, 0x15, 0x63, 0x15, 0x63,
		0x37, 0x63, 0x58, 0x63, 0x7A, 0x67, 0x9C, 0x6B, 0xBD, 0x73, 0xDB, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F,
		0xB2, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0x91, 0x7F, 0x91, 0x7B, 0x70, 0x7B,
		0x70, 0x7B, 0x4F, 0x77, 0x2F, 0x77, 0x2E, 0x77, 0x0E, 0x77, 0x2D, 0x77, 0x4D, 0x7B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0xBA, 0x1A, 0x3C, 0x43, 0x7D, 0x57, 0xBE, 0x6B,
		0xFF, 0x7B, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F,
		0x7E, 0x5B, 0x9A, 0x12, 0x9E, 0x63, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7B,
		0x9E, 0x63, 0x3D, 0x43, 0xDC, 0x26, 0x9B, 0x12, 0x5B, 0x02, 0x5B, 0x02, 0x5A, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9B, 0x12, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x9B, 0x12,
		0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x7B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x7B, 0x12, 0x7C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x7C, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0x3E, 0x43, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x67, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x3E, 0x3F, 0xDD, 0x22, 0xB5, 0x6F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD5, 0x7B,
		0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xF8, 0x7F, 0xEF, 0x66,
		0x86, 0x49, 0xA7, 0x51, 0x4A, 0x62, 0xED, 0x76, 0x4F, 0x7F, 0x90, 0x7F, 0x6F, 0x7F, 0xAC, 0x66,
		0xE8, 0x55, 0x6C, 0x62, 0xCD, 0x6E, 0xAA, 0x72, 0xA9, 0x72, 0xEA, 0x76, 0xEA, 0x76, 0x0B, 0x77,
		0x0B, 0x77, 0x0C, 0x77, 0xEC, 0x72, 0xCD, 0x6A, 0xAE, 0x62, 0x90, 0x5A, 0x91, 0x56, 0xD4, 0x56,
		0xF6, 0x56, 0xF7, 0x56, 0xF6, 0x5A, 0xF5, 0x5A, 0xD4, 0x5A, 0xF5, 0x5A, 0x38, 0x5F, 0x7A, 0x67,
		0xBC, 0x6B, 0xBB, 0x73, 0xD9, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B, 0xD8, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F,
		0xB2, 0x7F, 0x91, 0x7F, 0x91, 0x7B, 0x70, 0x7B, 0x50, 0x7B, 0x4F, 0x77, 0x2F, 0x77, 0x2E, 0x77,
		0x0E, 0x77, 0x2D, 0x7B, 0x4D, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x06, 0x9A, 0x16, 0xDB, 0x2A, 0x3C, 0x43, 0x9E, 0x5F, 0xDF, 0x77,
		0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x9E, 0x5B, 0x9A, 0x16, 0x9E, 0x63, 0xFF, 0x7F,
		0xFF, 0x7F, 0xDF, 0x77, 0x7D, 0x57, 0xFC, 0x2E, 0x7B, 0x0E, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5A, 0x02, 0x59, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7B, 0x0E,
		0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9B, 0x12, 0x9B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E, 0x7B, 0x0E,
		0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x7B, 0x12, 0x7C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xDE, 0x2A, 0xDF, 0x6F, 0xDF, 0x73,
		0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x67, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63,
		0x9F, 0x63, 0x9F, 0x5F, 0x1E, 0x3B, 0x9A, 0x63, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0x96, 0x77, 0xD1, 0x66, 0x6F, 0x5A, 0x6F, 0x5E,
		0xB0, 0x66, 0x12, 0x73, 0x53, 0x7B, 0x93, 0x7F, 0x74, 0x7B, 0x79, 0x73, 0x36, 0x6B, 0xD1, 0x6A,
		0xCF, 0x6E, 0xF0, 0x72, 0x10, 0x73, 0x11, 0x77, 0x31, 0x77, 0x31, 0x77, 0x33, 0x77, 0x54, 0x77,
		0x76, 0x77, 0x77, 0x73, 0x34, 0x6F, 0x14, 0x6B, 0x35, 0x6B, 0x55, 0x6F, 0x57, 0x6B, 0x58, 0x67,
		0x17, 0x5F, 0xF6, 0x5E, 0x17, 0x5F, 0x5A, 0x67, 0x9B, 0x6B, 0xBA, 0x77, 0xFA, 0x7F, 0xDA, 0x7F,
		0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xB5, 0x7F, 0xB5, 0x7F, 0xB5, 0x7B,
		0x94, 0x7B, 0x94, 0x7B, 0x73, 0x7B, 0x73, 0x7B, 0x73, 0x7B, 0x73, 0x7B, 0x92, 0x7F, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x79, 0x0A, 0x9A, 0x1A, 0xFB, 0x32, 0x5D, 0x4F, 0xBE, 0x67, 0xDF, 0x77,
		0x7D, 0x57, 0x9A, 0x16, 0x9E, 0x5F, 0xBE, 0x6B, 0x3C, 0x43, 0xBB, 0x1E, 0x5A, 0x06, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5B, 0x02, 0x59, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E,
		0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9B, 0x12, 0x9B, 0x0E, 0x7B, 0x0E, 0x9B, 0x0E, 0x7B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12,
		0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0x9F, 0x5B, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x5F,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0xFE, 0x2A, 0x1A, 0x3B,
		0xD3, 0x7B, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B,
		0xF8, 0x7F, 0xF6, 0x7F, 0x71, 0x73, 0xAD, 0x62, 0x4A, 0x56, 0xE9, 0x51, 0x09, 0x56, 0x2A, 0x5E,
		0x6C, 0x66, 0x36, 0x67, 0x15, 0x67, 0x6B, 0x66, 0x69, 0x6A, 0xCA, 0x72, 0xEA, 0x72, 0xEB, 0x76,
		0xEB, 0x76, 0xCC, 0x72, 0xCD, 0x6E, 0xD0, 0x66, 0x57, 0x6B, 0xBC, 0x73, 0x31, 0x73, 0x0C, 0x77,
		0x4C, 0x7B, 0x2B, 0x7F, 0x2C, 0x7B, 0x30, 0x77, 0x14, 0x67, 0xB3, 0x56, 0x71, 0x4E, 0x72, 0x4A,
		0x56, 0x67, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD5, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F,
		0xB2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F,
		0xB1, 0x7F, 0x91, 0x7B, 0x90, 0x7B, 0x70, 0x7B, 0x4F, 0x7B, 0x4F, 0x77, 0x2E, 0x77, 0x2E, 0x77,
		0x2E, 0x77, 0x4D, 0x7B, 0x4C, 0x7B, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E,
		0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9B, 0x12, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x3E, 0x43, 0xDF, 0x6F,
		0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xBF, 0x67, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x3E, 0x3F, 0xBD, 0x1E, 0xB4, 0x73, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7F, 0xF8, 0x7F, 0xF6, 0x7F,
		0xD5, 0x7B, 0x72, 0x77, 0x30, 0x6F, 0xED, 0x66, 0x8B, 0x62, 0xD2, 0x5E, 0xD4, 0x5E, 0x6C, 0x62,
		0x69, 0x6A, 0xAA, 0x6E, 0xEB, 0x72, 0xEB, 0x72, 0xEC, 0x72, 0xED, 0x72, 0xEE, 0x72, 0xF1, 0x6A,
		0x57, 0x6B, 0x9A, 0x73, 0xED, 0x76, 0xEA, 0x76, 0xCA, 0x72, 0xAA, 0x72, 0xAC, 0x6E, 0xF0, 0x6E,
		0xD1, 0x66, 0xB0, 0x62, 0xB1, 0x5A, 0xD1, 0x5E, 0xB6, 0x7B, 0xD8, 0x7F, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7B, 0xD2, 0x7F,
		0xD2, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F,
		0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0x90, 0x7B, 0x90, 0x7B, 0x6F, 0x7B,
		0x4F, 0x7B, 0x4F, 0x77, 0x2E, 0x77, 0x2E, 0x77, 0x2D, 0x77, 0x4D, 0x7B, 0x6D, 0x7B, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02,
		0x58, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5A, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xDE, 0x26, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73,
		0xBF, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x5F, 0x1E, 0x3B,
		0x99, 0x67, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xF9, 0x7F,
		0xF8, 0x7F, 0xB7, 0x7B, 0xF4, 0x62, 0x90, 0x62, 0xD0, 0x6E, 0x10, 0x73, 0x31, 0x77, 0x31, 0x77,
		0x32, 0x77, 0x33, 0x77, 0x34, 0x73, 0x36, 0x6F, 0x59, 0x6B, 0x15, 0x6B, 0x8F, 0x62, 0x8F, 0x62,
		0x8F, 0x62, 0x8F, 0x62, 0xB1, 0x62, 0xD2, 0x66, 0xF2, 0x66, 0x34, 0x6F, 0x96, 0x77, 0xD9, 0x7F,
		0xFA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F,
		0xD9, 0x7F, 0xF9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F,
		0xB5, 0x7F, 0xB5, 0x7F, 0xB5, 0x7F, 0x94, 0x7B, 0x94, 0x7B, 0x74, 0x7B, 0x73, 0x7B, 0x73, 0x7B,
		0x73, 0x7B, 0x92, 0x7B, 0x92, 0x7F, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02,
		0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x58, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02,
		0x5A, 0x02, 0x59, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x99, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9B, 0x0E,
		0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x1A, 0x9F, 0x5B,
		0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0x9F, 0x5F, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57,
		0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x53, 0xFE, 0x2A, 0xFA, 0x36, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F,
		0xD2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD4, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xF7, 0x7F, 0xF8, 0x7F, 0x11, 0x67, 0xA8, 0x45,
		0xA7, 0x51, 0x49, 0x66, 0x8A, 0x6E, 0xAB, 0x72, 0xCC, 0x6E, 0xCD, 0x6E, 0x8E, 0x66, 0x6F, 0x5A,
		0x33, 0x6B, 0x71, 0x77, 0x50, 0x73, 0x50, 0x73, 0x50, 0x6F, 0x51, 0x73, 0x72, 0x73, 0x93, 0x77,
		0xB4, 0x7B, 0xD6, 0x7F, 0xF7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7F, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7B,
		0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7B, 0xD4, 0x7B, 0xD3, 0x7B, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xB2, 0x7F, 0xB2, 0x7F,
		0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F,
		0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0x90, 0x7F, 0x90, 0x7B, 0x70, 0x7B, 0x6F, 0x7B,
		0x4E, 0x7B, 0x2E, 0x7B, 0x2E, 0x77, 0x2E, 0x77, 0x2D, 0x7B, 0x4D, 0x7B, 0x6D, 0x7B, 0x58, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x38, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x38, 0x02, 0x38, 0x02,
		0x38, 0x02, 0x38, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x59, 0x02, 0x58, 0x02,
		0x59, 0x02, 0x58, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x99, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E,
		0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9C, 0x12, 0x9D, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x3E, 0x43, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F, 0xDF, 0x6F,
		0xBF, 0x67, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x7F, 0x57, 0x1E, 0x3B,
		0xDC, 0x22, 0xB3, 0x73, 0xB1, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F,
		0xD3, 0x7F, 0xD2, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD5, 0x7B, 0xD4, 0x7B, 0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xF7, 0x7F, 0xF7, 0x7F, 0x11, 0x6B, 0x0A, 0x52, 0xA7, 0x4D, 0xE8, 0x55, 0x08, 0x5E,
		0x09, 0x5A, 0x0A, 0x5A, 0x2B, 0x56, 0xF1, 0x66, 0xD6, 0x7B, 0xF7, 0x7F, 0xF8, 0x7F, 0xF8, 0x7F,
		0xF8, 0x7F, 0xF8, 0x7F, 0xF8, 0x7F, 0xF8, 0x7F, 0xF8, 0x7F, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B,
		0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD7, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B,
		0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD6, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B, 0xD5, 0x7B,
		0xD5, 0x7B, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD4, 0x7B, 0xD4, 0x7B, 0xD4, 0x7B, 0xD4, 0x7F,
		0xD4, 0x7B, 0xD4, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F, 0xD3, 0x7B, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F,
		0xD3, 0x7B, 0xD3, 0x7F, 0xD3, 0x7F, 0xD3, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F, 0xD2, 0x7F,
		0xD2, 0x7F, 0xB2, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F, 0xB1, 0x7F,
		0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F, 0xB0, 0x7F,
		0x90, 0x7F, 0x90, 0x7B, 0x6F, 0x7B, 0x6F, 0x7B, 0x4F, 0x7B, 0x2E, 0x7B, 0x2E, 0x77, 0x2E, 0x77,
		0x2D, 0x7B, 0x4D, 0x7B, 0x6C, 0x7B, 0x38, 0x02, 0x38, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x58, 0x02, 0x58, 0x02, 0x58, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x38, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x58, 0x02, 0x59, 0x02,
		0x39, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x59, 0x02,
		0x59, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
		0x5B, 0x02, 0x5B, 0x02, 0x5B, 0x02, 0x59, 0x02, 0x59, 0x02, 0x38, 0x02, 0x58, 0x02, 0x58, 0x02,
		0x59, 0x02, 0x59, 0x02, 0x59, 0x02, 0x99, 0x0E, 0x99, 0x0E, 0x99, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E,
		0x7A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x7A, 0x0E, 0x9A, 0x0E, 0x7A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E,
		0x9A, 0x0E, 0x9A, 0x0E, 0x9A, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E, 0x9B, 0x0E,
		0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12, 0x9B, 0x12,
		0x9B, 0x12, 0x9B, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9D, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12,
		0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0x9C, 0x12, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16,
		0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0xBE, 0x16, 0x1E, 0x33,
		0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xDF, 0x73, 0xBF, 0x63, 0x9F, 0x63, 0x9F, 0x63,
		0x9F, 0x63, 0x9F, 0x63, 0x9F, 0x63, 0x7F, 0x5B, 0x1E, 0x3B, 0x99, 0x63, 0xD5, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD7, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xF9, 0x7F, 0xF9, 0x7F, 0xFA, 0x7F,
		0xD9, 0x7F, 0x76, 0x73, 0x34, 0x6F, 0x13, 0x6B, 0x13, 0x6B, 0x34, 0x6F, 0x97, 0x77, 0xFA, 0x7F,
		0xFA, 0x7F, 0xDA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xFA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F, 0xDA, 0x7F,
		0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xF9, 0x7F,
		0xD9, 0x7F, 0xF9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD9, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F, 0xD8, 0x7F,
		0xD8, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F,
		0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD7, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F,
		0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD6, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F,
		0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xD4, 0x7F, 0xD4, 0x7F,
		0xD4, 0x7F, 0xD5, 0x7F, 0xD5, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0xB4, 0x7F, 0x94, 0x7F, 0x94, 0x7B,
		0x94, 0x7B, 0x73, 0x7B, 0x73, 0x7B, 0x73, 0x7B, 0x73, 0x7B, 0x92, 0x7F, 0x92, 0x7F, 
};

#define MARGIN 13

CExtProfUISAboutDialog::CExtProfUISAboutDialog( 
	LPCTSTR szApp, 
	LPCTSTR szOtherStuff,
	HICON hIcon 
	)
	: CExtResizableDialog()
	, m_szApp( szApp )
	, m_szOtherStuff( szOtherStuff )
	, m_hIcon( hIcon )
{
}

/////////////////////////////////////////////////////////////////////////////
// CExtProfUISAboutDialog dialog

BEGIN_MESSAGE_MAP(CExtProfUISAboutDialog, CExtResizableDialog)
//{{AFX_MSG_MAP(CExtProfUISAboutDialog)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtProfUISAboutDialog message handlers

BOOL CExtProfUISAboutDialog::OnInitDialog() 
{
	CExtResizableDialog::OnInitDialog();
	
	ShowSizeGrip(FALSE);

	CRect rcClient;
	GetClientRect( &rcClient );
	
	CString sCaption = _T("About ");
	sCaption += m_szApp;	
	SetWindowText( sCaption );

	//////////////////////////////////////////////////////////////////////////
	// Logo
	//////////////////////////////////////////////////////////////////////////
	
	int nLogoHeight = 60;
				
	CMemFile _file;
	_file.Attach( g_arrBmpData, sizeof(g_arrBmpData) / sizeof(g_arrBmpData[0]) );
	CArchive ar( &_file, CArchive::load );
	try
	{
		HBITMAP hBitmap = NULL;
		if( ! CExtPaintManager::stat_SerializeBitmap( ar, &hBitmap ) )
		{
			ASSERT( FALSE );
			AfxThrowArchiveException( CArchiveException::generic );
		}
		if( hBitmap != NULL  )
		{
			CRect rcLogo(
				0,
				0,
				rcClient.right,
				nLogoHeight
				);

			if( !m_labelLogo.Create(
					_T(""),
					WS_CHILD|WS_VISIBLE|SS_BITMAP,
					rcLogo,
					this,
					UINT(IDC_STATIC)
					)
				)
			{
				ASSERT( FALSE );
				return FALSE;
			}

			m_labelLogo.SetBitmap(hBitmap);
		}
		else
		{
			ASSERT( FALSE );
			return FALSE;
		}
		
	} // try
	catch( CException * pException )
	{
		ASSERT( FALSE );
		pException->Delete();
		return FALSE;
	} // catch( CException * pException )
	catch( ... )
	{
		ASSERT( FALSE );
		return FALSE;
	} // catch( ... )
	_file.Detach();
	
	int nCurYPosition = nLogoHeight + MARGIN;

	//////////////////////////////////////////////////////////////////////////
	// Label Icon App
	//////////////////////////////////////////////////////////////////////////

	int nIconSize = 32;

	CRect rcLabelAppIcon(
		MARGIN,
		nCurYPosition,
		nIconSize + MARGIN,
		nCurYPosition + nIconSize
		);
	if( !m_labelAppIcon.Create(
		_T(""),
		WS_CHILD|WS_VISIBLE|SS_ICON,
		rcLabelAppIcon,
		this,
		UINT(IDC_STATIC)
		)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_labelAppIcon.SetIcon(m_hIcon);

	int nCurX1Position = nIconSize + 2*MARGIN;
	int nCurX2Position = rcClient.right - MARGIN;

	//////////////////////////////////////////////////////////////////////////
	// Label App
	//////////////////////////////////////////////////////////////////////////

	int nLabelAppHeight = 18;
	
	CRect rcLabelApp(
		nCurX1Position,
		nCurYPosition,
		nCurX2Position,
		nCurYPosition + nLabelAppHeight
		);
	if( !m_labelApp.Create(
		m_szApp,
		WS_CHILD|WS_VISIBLE,
		rcLabelApp,
		this,
		UINT(IDC_STATIC)
		)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_labelApp.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);

	nCurYPosition += nLabelAppHeight;
	
	//////////////////////////////////////////////////////////////////////////
	// Label Other Stuff
	//////////////////////////////////////////////////////////////////////////
	
	int nLabelOtherStuffHeight = 22;
	
	CRect rcLabelOtherStuff(
		nCurX1Position,
		nCurYPosition,
		nCurX2Position,
		nCurYPosition + nLabelOtherStuffHeight
		);
	if( !m_labelOtherStuff.Create(
		m_szOtherStuff,
		WS_CHILD|WS_VISIBLE,
		rcLabelOtherStuff,
		this,
		UINT(IDC_STATIC)
		)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_labelOtherStuff.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);

	nCurYPosition += nLabelOtherStuffHeight;

	//////////////////////////////////////////////////////////////////////////
	// SEPARATOR
	//////////////////////////////////////////////////////////////////////////
	
	int nSeparatorHeight = 10;
	
	CRect rcSeparator(
		nCurX1Position,
		nCurYPosition,
		nCurX2Position,
		nCurYPosition + nSeparatorHeight
		);
	if( !m_labelSeparator.Create(
		_T(""),
		WS_CHILD|WS_VISIBLE|SS_ETCHEDHORZ,
		rcSeparator,
		this,
		UINT(IDC_STATIC)
		)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	
	nCurYPosition += nSeparatorHeight;

	
	//////////////////////////////////////////////////////////////////////////
	// Label Copyright
	//////////////////////////////////////////////////////////////////////////
	
	int nLabelCopyrightHeight = 20;
	
	CRect rcLabelCopyright(
		nCurX1Position,
		nCurYPosition,
		nCurX2Position,
		nCurYPosition + nLabelCopyrightHeight
		);
	if( !m_labelCopyright.Create(
			_T("Copyright 2000-2004, FOSS Software, Inc."),
			WS_CHILD|WS_VISIBLE,
			rcLabelCopyright,
			this,
			UINT(IDC_STATIC)
			)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_labelCopyright.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);

	nCurYPosition += nLabelCopyrightHeight;

	//////////////////////////////////////////////////////////////////////////
	// Web-Site
	//////////////////////////////////////////////////////////////////////////
	
	int nLabelWebSiteHeight = 18;

	CRect rcLabelWebSite(
		nCurX1Position,
		nCurYPosition,
		nCurX1Position + 55,
		nCurYPosition + nLabelWebSiteHeight
		);
	if( !m_labelWebSite.Create(
			_T("web site:"),
			WS_CHILD|WS_VISIBLE,
			rcLabelWebSite,
			this,
			UINT(IDC_STATIC)
			)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_labelWebSite.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);

	//////////////////////////////////////////////////////////////////////////
	
	CRect rcLabelWndWebSite(
		nCurX1Position + 55,
		nCurYPosition-5,
		nCurX2Position,
		nCurYPosition + nLabelWebSiteHeight
		);

	if( !m_wndWebSite.Create(
			__URL_WWW,
			WS_CHILD|WS_VISIBLE|BS_OWNERDRAW,
			rcLabelWndWebSite,
			this,
			UINT(IDC_STATIC)
			)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_wndWebSite.m_strURL = _T("http://");
	m_wndWebSite.m_strURL += __URL_WWW;
	m_wndWebSite.SetTooltipText( __TOOLTIP_WWW );
	m_wndWebSite.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);

	nCurYPosition += nLabelWebSiteHeight;

	//////////////////////////////////////////////////////////////////////////
	// E-Mail
	//////////////////////////////////////////////////////////////////////////

	int nLabelEMailHeight = 18;

	CRect rcLabelEMail(
		nCurX1Position,
		nCurYPosition,
		nCurX1Position + 55,
		nCurYPosition + nLabelEMailHeight
		);
	if( !m_labelEMail.Create(
			_T("e-mail:"),
			WS_CHILD|WS_VISIBLE,
			rcLabelEMail,
			this,
			UINT(IDC_STATIC)
			)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_labelEMail.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);

	//////////////////////////////////////////////////////////////////////////
	
	CRect rcLabelWndEMail(
		nCurX1Position + 55,
		nCurYPosition-5,
		nCurX2Position,
		nCurYPosition + nLabelWebSiteHeight
		);

	if( !m_wndEMail.Create(
			__URL_E_MAIL,
			WS_CHILD|WS_VISIBLE|BS_OWNERDRAW,
			rcLabelWndEMail,
			this,
			UINT(IDC_STATIC)
			)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_wndEMail.m_strURL = _T("mailto:");
	m_wndEMail.m_strURL += __URL_E_MAIL;
	m_wndEMail.SetTooltipText( __TOOLTIP_E_MAIL );
	m_wndEMail.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);

	nCurYPosition += nLabelEMailHeight;
	
	//////////////////////////////////////////////////////////////////////////
	// OK button
	//////////////////////////////////////////////////////////////////////////
	
	CRect rcBtnOk(
		rcClient.right - MARGIN - 80,
		rcClient.bottom - MARGIN - 24,
		nCurX2Position,
		rcClient.bottom - MARGIN
		);
	if( !m_btnOk.Create(
		_T("OK"),
		WS_CHILD|WS_VISIBLE|WS_TABSTOP,
		rcBtnOk,
		this,
		IDOK
		)
		)
	{
		ASSERT( FALSE );
		return FALSE;
	}
	m_btnOk.SetFont(
		CFont::FromHandle(
		(HFONT)::GetStockObject(DEFAULT_GUI_FONT)
		)
		);
	
	return TRUE; 
}

BOOL ProfUISAbout( 
	HWND hWndParent, // = NULL
	__EXT_MFC_SAFE_LPCTSTR szApp, // = NULL
	__EXT_MFC_SAFE_LPCTSTR szOtherStuff, // = NULL
	HICON hIcon, // = NULL
	bool bAutoDetectNullParms // = true
	)
{
CWinApp * pApp = ::AfxGetApp();
	ASSERT_VALID( pApp );
	if( hWndParent == NULL && bAutoDetectNullParms )
		hWndParent = pApp->m_pMainWnd->GetSafeHwnd();
	if( szApp == NULL )
		szApp = bAutoDetectNullParms ? pApp->m_pszAppName : _T("");
	if( szOtherStuff == NULL )
		szOtherStuff = _T("");
	if( hIcon == NULL && hWndParent != NULL && bAutoDetectNullParms )
	{
		hIcon = (HICON)
			::SendMessage(
				hWndParent,
				WM_GETICON,
				ICON_BIG,
				0L
				);
		if( hIcon == NULL ) 
		{
			hIcon = (HICON)::GetClassLong(hWndParent, GCL_HICON);
			if(hIcon == NULL) 
				hIcon = pApp->LoadStandardIcon(IDI_WINLOGO);
		}
	}
const WORD nDlgItems = 0;
DLGTEMPLATE dlgTmpl;
	dlgTmpl.x = 0;
	dlgTmpl.y = 0;
	dlgTmpl.cx = 225;  
	dlgTmpl.cy = 140;  
	dlgTmpl.style = 
		WS_CAPTION 
		| WS_POPUP 
		| WS_VISIBLE 
		| WS_CLIPSIBLINGS
		| WS_CLIPCHILDREN
		| WS_SYSMENU
		| DS_3DLOOK
		| DS_MODALFRAME 
		| DS_SETFONT;
	dlgTmpl.dwExtendedStyle = 0;

	dlgTmpl.cdit = nDlgItems;  // nDlgItems dialog items in the dialog

	// The first step is to allocate memory to define the dialog.  
	// The information to be stored in the allocated buffer is the following:
	//
	// 1.  DLGTEMPLATE structure
	// 2.    0x0000 (Word) indicating the dialog has no menu
	// 3.    0x0000 (Word) Let windows assign default class to the dialog
	// 4.    (Caption)  Null terminated unicode string

	WCHAR szBoxCaption[] = L"";
	WCHAR szFontName[] = L"MS Sans Serif";
	
	TRY  // catch memory exceptions and don't worry about allocation failures
	{
		// The following expressions have unnecessary parenthesis trying to make the
		// comments more clear.
		int nBufferSize =  sizeof(DLGTEMPLATE) + (2 * sizeof(WORD))/*menu and class*/ + sizeof(szBoxCaption);
		nBufferSize += sizeof(WORD) + sizeof(szFontName); /* font information*/
		
		HLOCAL hLocal = LocalAlloc(LHND, nBufferSize);
		if (hLocal == NULL)
			AfxThrowMemoryException();

		BYTE*   pBuffer = (BYTE*)LocalLock(hLocal);
		if (pBuffer == NULL)
		{
			LocalFree(hLocal);
			AfxThrowMemoryException();
		}

		BYTE*   pdest = pBuffer;
		// transfer DLGTEMPLATE structure to the buffer
		memcpy(pdest, &dlgTmpl, sizeof(DLGTEMPLATE));
		pdest += sizeof(DLGTEMPLATE);
		*(WORD*)pdest = 0; // no menu
		*(WORD*)(pdest + sizeof(WORD)) = 0;  // use default window class
		pdest += 2 * sizeof(WORD);
		memcpy(pdest, szBoxCaption, sizeof(szBoxCaption));
		pdest += sizeof(szBoxCaption);
	
		*(WORD*)pdest = 8;  // font size
		pdest += sizeof(WORD);
		memcpy(pdest, szFontName, sizeof(szFontName));
		pdest += sizeof(szFontName);
		
		CExtProfUISAboutDialog dlg( 
			szApp,
			szOtherStuff,
			hIcon
			);
		dlg.InitModalIndirect(
			(DLGTEMPLATE*)pBuffer,
			CWnd::FromHandle( hWndParent )
			);
		//dlg.DoModal();
		(&dlg)->CDialog::DoModal();

		LocalUnlock(hLocal);
		LocalFree(hLocal);
	}
	CATCH(CMemoryException, e)
	{
		TRACE0("Memory allocation for dialog template failed.");
		return FALSE;
	}
	END_CATCH
	return TRUE;
}

#endif // (!defined __EXT_MFC_NO_PROF_UIS_ABOUT_DIALOG)

