#ifndef _SPRITEPROPERTIES_H_
#define _SPRITEPROPERTIES_H_

#include "propertyhandler.h"

class SpriteClassPropertyHandler : public PropertyHandler
{
	typedef enum
	{
		PROPERTY_TITLE,
		PROPERTY_POSITIONX,
		PROPERTY_POSITIONY,
		PROPERTY_WIDTH,
		PROPERTY_HEIGHT,
		PROPERTY_SCALE,
		PROPERTY_ORIGIN,
		PROPERTY_ROTATION,
		PROPERTY_BASECOLOR,
		PROPERTY_FAMILYCOLOR,
		PROPERTY_VERTEX1COLOR,
		PROPERTY_VERTEX2COLOR,
		PROPERTY_VERTEX3COLOR,
		PROPERTY_VERTEX4COLOR,
		PROPERTY_TEXTUREPATH,
		PROPERTY_TEXTURENAME,
		PROPERTY_TEXTURESIZE,
		PROPERTY_TEXTUREFORMAT,
		PROPERTY_TEXTURECELL,
		PROPERTY_TEXTUREROWS,
		PROPERTY_TEXTURECOLUMNS,
		PROPERTY_VERTEX1TEXTURE,
		PROPERTY_VERTEX2TEXTURE,
		PROPERTY_VERTEX3TEXTURE,
		PROPERTY_VERTEX4TEXTURE,
		PROPERTY_SHADOWENABLED,
		PROPERTY_SHADOWINTENSITY,
		PROPERTY_SHADOWPOSITION,
	}
	PROPERTY;

	public:
		SpriteClassPropertyHandler( void );
		virtual const char* GetKnownClass( void );
		virtual void SetProperty( const char* pKey, const char* pValue, int PropertyId );

		Sprite* GetKnownSprite( void ) { return (Sprite*) GetKnownObject(); }
};

#endif // _SPRITEPROPERTIES_H_