///////////////////////////////////////////////////////////////////////////////
// System to build an array of all the instances in a world file
///////////////////////////////////////////////////////////////////////////////
#include "instlist.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
InstanceList::InstanceList(void) :
instanceList(256, 16, true)
{
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
InstanceList::~InstanceList(void)
{
}

///////////////////////////////////////////////////////////////////////////////
// Build the list
///////////////////////////////////////////////////////////////////////////////
void InstanceList::Build(
ts_Group *groupList,
uint groups)
{
	ts_Group *group = groupList;
	for (uint index = 0; index < groups; index++, group++)
		for (uint instanceCount = 0; instanceCount < group->usDispStatInst; instanceCount++)
		{
			// Get an alias to the instance
			CInstance *instance = group->ppDispStatArray[instanceCount];

			// Add it!
			if (!FindInstance(instance))
				AddInstance(instance);
		}
}

///////////////////////////////////////////////////////////////////////////////
// Find a Instance in the list
///////////////////////////////////////////////////////////////////////////////
bool InstanceList::FindInstance(
CInstance *instance)
{
	int count = instanceList.Count();
	for (int i = 0; i < count; i++)
		if (instanceList[i] == instance)
			return(true);

	return(false);
}

