/////////////////////////////////////////////////////////////////////////////
// A category is a collection of phrases
/////////////////////////////////////////////////////////////////////////////
inline SayVoiceSet::Category::Category()
{
	m_name = NULL;
	m_index = -1;
	m_stream = false;
	m_priority = SAYPRIO_NORMAL;
	m_phrase = NULL;
	m_phrases = m_maxPhrases = 0;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline SayVoiceSet::Category::~Category()
{
	if (m_phrase)
	{
		if (m_stream)
		{
			for (int p = 0; p < m_phrases; p++)
				g_audio.ReleaseStreamNameToken(m_phrase[p].name);
		}
		delete [] m_phrase;
	}
}

/////////////////////////////////////////////////////////////////////////////
// A category is a collection of phrases
/////////////////////////////////////////////////////////////////////////////
inline bool SayVoiceSet::Category::Setup(
const char *name,
int index,
bool stream,
SayPriority priority,
int phrases)
{
	// You can only call this once
	ASSERT(m_phrase == NULL);

	m_name = g_sayLib.m_categoryPool.Add(name, StringPool::SPADD_FORCELOWER);
	m_index = index;
	m_stream = stream;
	m_priority = priority;

	if (phrases > 0)
	{
		m_phrase = new Phrase[phrases];
		ASSERT(m_phrase);
		if (m_phrase)
			m_maxPhrases = phrases;
	}

	return (m_maxPhrases > 0);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline const char *SayVoiceSet::Category::Name() const
{
	return m_name;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline int SayVoiceSet::Category::Index() const
{
	return m_index;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline bool SayVoiceSet::Category::IsStream() const
{
	return m_stream;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline SayPriority SayVoiceSet::Category::GetPriority() const
{
	return m_priority;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline int SayVoiceSet::Category::Phrases()
{
	return m_phrases;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline bool SayVoiceSet::Category::AddPhrase(const char *phrase)
{
	ASSERT(phrase);

	// Are we full?
	ASSERT(m_phrases <= m_maxPhrases);
	if (m_phrases == m_maxPhrases)
		return false;

	// Does this exist?
	if (m_stream)
	{
		const char *token = g_audio.TokenizeStreamName(phrase);
		if (!token)
			return false;
		m_phrase[m_phrases++].name = token;
	}
	else
	{
		const char *token = g_sayLib.m_sfxPool.Add(phrase, StringPool::SPADD_FORCELOWER);
		if (!token)
			return false;
		m_phrase[m_phrases++].name = token;
	}

	return true;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline const char *SayVoiceSet::Category::GetPhrase(int index) const
{
	if (index < 0 || index >= m_phrases)
		return NULL;
	else
		return m_phrase[index].name;
}

