/*
 *	Main actions / entry points.
 */
//#define ACTION_DIE								0x0000
#define ACTION_ROAM_RESPAWN					0x0000
#define ACTION_ROAM_UPRIGHT					0x0100
#define ACTION_ROAM_JUMP						0x0200
#define ACTION_ROAM_KICK						0x0300
#define ACTION_ROAM_RECOIL						0x0400
#define ACTION_ROAM_LADDER						0x0500
#define ACTION_ROAM_HOSTAGE						0x0600

/*
 *	Sub-actions. Note that sub-action 0x00 for all main actions is reserved
 *	for initial entry and initialization.
 */
#define ACTION_ROAM_IDLE						(0x01 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_WALK						(0x02 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_RUN							(0x03 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_STOP						(0x04 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_WALKBACK					(0x05 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_RUNBACK						(0x06 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_SIDESTEPRIGHT				(0x07 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_SIDESTEPLEFT				(0x08 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_SIDESTEPRUNRIGHT			(0x09 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_SIDESTEPRUNLEFT				(0x0a | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_DIE							(0x0b | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_TURNLEFT					(0x0c | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_TURNRIGHT					(0x0d | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_COWER						(0x0e | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_HANDSUP						(0x0f | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_STOW_WEAPON					(0x10 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_VAULT						(0x11 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_TAG							(0x12 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_UNINTERRUPTIBLE				(0x13 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_PEEK						(0x14 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_STUNNED						(0x15 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_ONFIRE						(0x16 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_RELOAD						(0x17 | ACTION_ROAM_UPRIGHT)
#define ACTION_ROAM_UNINTERRUPTIBLE_UPRIGHT	(0x18 | ACTION_ROAM_UPRIGHT)

#define ACTION_ROAM_LADDER_ONTOP				(0x01 | ACTION_ROAM_LADDER)
#define ACTION_ROAM_LADDER_SLIDE				(0x02 | ACTION_ROAM_LADDER)
#define ACTION_ROAM_LADDER_SLIDE_LAND			(0x03 | ACTION_ROAM_LADDER)
#define ACTION_ROAM_LADDER_CLIMBDOWN			(0x04 | ACTION_ROAM_LADDER)

#define ACTION_ROAM_HOSTAGE_STANCE				(0x01 | ACTION_ROAM_HOSTAGE)
#define ACTION_ROAM_HOSTAGE_FORWARD				(0x02 | ACTION_ROAM_HOSTAGE)
#define ACTION_ROAM_HOSTAGE_BACKWARD			(0x03 | ACTION_ROAM_HOSTAGE)
#define ACTION_ROAM_HOSTAGE_LEFT				(0x04 | ACTION_ROAM_HOSTAGE)
#define ACTION_ROAM_HOSTAGE_RIGHT				(0x05 | ACTION_ROAM_HOSTAGE)

/*
 * Action Sub Type Mask
 */
#define ACTION_TYPE_MASK(a)					(a & 0xFF00)
#define ACTION_SUB_TYPE_MASK(a)				(a & 0x00FF)

/*
 * Action Flags
 */
#define ACTIONFLAG_CAM_TARGET_SPECIAL					0x2000	// Signal special tracking to a Avatar camera Point.  Ie. A big offset change by script.
#define ACTIONFLAG_DISABLE_JOYSTICK						0x4000	//	Allow scripts to keep avatar in a mode but not be controllable.
#define ACTIONFLAG_DISABLE_JOYSTICK_TRANSLATION		0x8000	//	Allow scripts to keep avatar in a mode but not be controllable.

/*
 * Constants used by the game and by script variables.
 */
