///////////////////////////////////////////////////////////////////////////////
// Simple text based instrument
///////////////////////////////////////////////////////////////////////////////
#include "TTLPCH.h"

#include "main/cheats.h"
#include "hud/icheat.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
CheaterInstrument::CheaterInstrument() :
TextInstrument("cheater")
{
}

///////////////////////////////////////////////////////////////////////////////
// The update (called once per frame)
///////////////////////////////////////////////////////////////////////////////
void CheaterInstrument::Update(float dt)
{
	// Wee!
	if (Cheats::Enabled(Cheats::NOCHEATERHUD) || Cheats::InUse() == 0)
		SetText(NULL);
	else
	{
		float alpha = (1.0f + Math::Cos(g_timer.GetOSEndSec() * Math::Pi)) * 0.5f + 0.25f;
		SetText("* Buster *");
		m_text.SetAlpha(Math::Clamp(alpha));
	}

	// Do the rest of the wrok
	TextInstrument::Update(dt);
}

