///////////////////////////////////////////////////////////////////////////////
// Simple text based instrument
///////////////////////////////////////////////////////////////////////////////
#include "TTLPCH.h"

#include "hud/ispawntickets.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
SpawnTicketsInstrument::SpawnTicketsInstrument() :
TextInstrument("spawntickets")
{
}

///////////////////////////////////////////////////////////////////////////////
// The update (called once per frame)
///////////////////////////////////////////////////////////////////////////////
void SpawnTicketsInstrument::Update(float dt)
{
	uint16 count = g_referee.ParticipantSpawnTicketCount( g_referee.GetLocalPlayerAgentId() );
	if (count != 0xffff)
	{
		char spawnTicketString[32];
		Place( 448.0f, 36.0f);
		sprintf(spawnTicketString, "%03d", count);
		SetText(spawnTicketString);
	}
	else
	{
		SetText(NULL);
	}

	// Do the rest of the work
	TextInstrument::Update(dt);
}

