/////////////////////////////////////////////////////////////////////////////
// Car bomb is used to generate a projectile-like explosion
/////////////////////////////////////////////////////////////////////////////
#include "TTLPCH.h"

#include "weapons/carbomb.h"

DeclareSingleton(CarBomb);
volatile CarBombDependency g_carBombDependency;

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
CarBomb::CarBomb()
{
	m_carBomb = (AreaOfEffectProjectile *)g_projectileLib.CreateInstance("carbomb");
	ASSERT(m_carBomb);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
CarBomb::~CarBomb()
{
	delete m_carBomb;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void CarBomb::Explode(
CActor *instigator,
CActor *generator,
const Vector3 &pos)
{
	// Wee!
	if (!m_carBomb)
		return;

	m_carBomb->SetOwner(instigator);
	m_carBomb->SetGenerator(generator);
	Vector3 up(0.0f, 1.0f, 0.0f);
	m_carBomb->Fire(NULL, pos, up);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void CarBombDependency::InitializeEvery()
{
	NewSingleton(CarBomb);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void CarBombDependency::TerminateEvery()
{
	DeleteSingleton(CarBomb);
}

