/////////////////////////////////////////////////////////////////////////////
// Weapon instantiation class for a supersonic projectile
/////////////////////////////////////////////////////////////////////////////
#include "TTLPCH.h"

#include "weapons/fireproj.h"

// Create this
FireProjectileCreator g_fireCreator;

/////////////////////////////////////////////////////////////////////////////
// Do the work
/////////////////////////////////////////////////////////////////////////////
FireProjectileCreator::FireProjectileCreator() :
ProjectileCreator("fireaoe")
{
}

/////////////////////////////////////////////////////////////////////////////
// Create
/////////////////////////////////////////////////////////////////////////////
Projectile *FireProjectileCreator::CreateInstance(
const VarObjProperties<Projectile> &properties)
{
	return new FireProjectile((const FireProjectileProperties &)properties);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
ProjectileProperties *FireProjectileCreator::NewProperties(
int index)
{
	return new FireProjectileProperties(*this, index);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
FireProjectileProperties::FireProjectileProperties(
ProjectileCreator &creator,
int index) :
AreaOfEffectProjectileProperties(creator, index)
{
	m_fireDuration = 0.0f;
	m_fireDamage = 0.0f;
}

/////////////////////////////////////////////////////////////////////////////
// For parsing the data
/////////////////////////////////////////////////////////////////////////////
void FireProjectileProperties::RegisterContext(
const char *context)
{
	// Call the parent
	AreaOfEffectProjectileProperties::RegisterContext(context);

	g_console.CreateVar(context, "fireDuration", m_fireDuration);
	g_console.CreateVar(context, "fireDamage",  m_fireDamage);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
FireProjectile::FireProjectile(
const FireProjectileProperties &properties) :
AreaOfEffectProjectile(properties),
m_fireProps(properties)
{
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
FireProjectile::~FireProjectile()
{
}

/////////////////////////////////////////////////////////////////////////////
// Send the hit
/////////////////////////////////////////////////////////////////////////////
void FireProjectile::SendHit(
Weapon *weapon,
CActor *victim,
const Vector3 &pos,
u8 material,
const Vector3 *intersection,
float factor)
{
	// Let this pass through
	AreaOfEffectProjectile::SendHit(weapon, victim, pos, material, intersection, factor);

	// They are on fire!
	if (!Math::Zero(m_fireProps.m_fireDuration))
	{
		int type = m_fireProps.GetIndex();
		if (victim)
			g_messageDispatcher.SendMessageToActor("MunitionOnFire", CMessageDispatcher::IntToData(type), m_owner, victim->GetHandle());
	}
}





















