/////////////////////////////////////////////////////////////////////////////
// Weapon instantiation class for a shock projectile
/////////////////////////////////////////////////////////////////////////////
#include "TTLPCH.h"

#include "weapons/shockproj.h"

// Create this
ShockProjectileCreator g_shockCreator;

/////////////////////////////////////////////////////////////////////////////
// Do the work
/////////////////////////////////////////////////////////////////////////////
ShockProjectileCreator::ShockProjectileCreator() :
ProjectileCreator("shockaoe")
{
}

/////////////////////////////////////////////////////////////////////////////
// Create
/////////////////////////////////////////////////////////////////////////////
Projectile *ShockProjectileCreator::CreateInstance(
const VarObjProperties<Projectile> &properties)
{
	return new ShockProjectile((const ShockProjectileProperties &)properties);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
ProjectileProperties *ShockProjectileCreator::NewProperties(
int index)
{
	return new ShockProjectileProperties(*this, index);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
ShockProjectileProperties::ShockProjectileProperties(
ProjectileCreator &creator,
int index) :
AreaOfEffectProjectileProperties(creator, index)
{
	m_shockDuration = 0.0f;
}

/////////////////////////////////////////////////////////////////////////////
// For parsing the data
/////////////////////////////////////////////////////////////////////////////
void ShockProjectileProperties::RegisterContext(
const char *context)
{
	// Call the parent
	AreaOfEffectProjectileProperties::RegisterContext(context);

	g_console.CreateVar(context, "shockDuration", m_shockDuration);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
ShockProjectile::ShockProjectile(
const ShockProjectileProperties &properties) :
AreaOfEffectProjectile(properties),
m_shockProps(properties)
{
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
ShockProjectile::~ShockProjectile()
{
}

/////////////////////////////////////////////////////////////////////////////
// Send the hit
/////////////////////////////////////////////////////////////////////////////
void ShockProjectile::SendHit(
Weapon *weapon,
CActor *victim,
const Vector3 &pos,
u8 material,
const Vector3 *intersection,
float factor)
{
	// Let this pass through
	AreaOfEffectProjectile::SendHit(weapon, victim, pos, material, intersection, factor);

	// They are shocked!
	if (!Math::Zero(m_shockProps.m_shockDuration))
	{
		int type = m_shockProps.GetIndex();
		if (victim)
			g_messageDispatcher.SendMessageToActor("MunitionShock", CMessageDispatcher::IntToData(type), m_owner, victim->GetHandle());
	}
}





















