/////////////////////////////////////////////////////////////////////////////
// Weapon instantiation class for a taser projectile
/////////////////////////////////////////////////////////////////////////////
#include "TTLPCH.h"
#include "weapons/taser.h"

// Create this
TaserProjectileCreator g_taserCreator;

/////////////////////////////////////////////////////////////////////////////
// Do the work
/////////////////////////////////////////////////////////////////////////////
TaserProjectileCreator::TaserProjectileCreator() :
ProjectileCreator("taser")
{
}

/////////////////////////////////////////////////////////////////////////////
// Create
/////////////////////////////////////////////////////////////////////////////
Projectile *TaserProjectileCreator::CreateInstance(
const VarObjProperties<Projectile> &properties)
{
	return new TaserProjectile((const TaserProjectileProperties &)properties);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
ProjectileProperties *TaserProjectileCreator::NewProperties(
int index)
{
	return new TaserProjectileProperties(*this, index);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
TaserProjectileProperties::TaserProjectileProperties(
ProjectileCreator &creator,
int index) :
SupersonicProjectileProperties(creator, index)
{
	m_stunDuration = 0.0f;
}

/////////////////////////////////////////////////////////////////////////////
// For parsing the data
/////////////////////////////////////////////////////////////////////////////
void TaserProjectileProperties::RegisterContext(
const char *context)
{
	// Call the parent
	SupersonicProjectileProperties::RegisterContext(context);

	// Do our shiznizzy
	g_console.CreateVar(context, "stunDuration", m_stunDuration);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
TaserProjectile::TaserProjectile(
const TaserProjectileProperties &properties) :
SupersonicProjectile(properties),
m_taserProps(properties)
{
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void TaserProjectile::HandleIntersection(
HitSalvo &salvo, 
const Vector3 &shotOrigin,
CLineQuery &test,
float energy,
bool deflected)
{
	// Let this bad boy go
	SupersonicProjectile::HandleIntersection(salvo, shotOrigin, test, energy, deflected);

	// Stun?
	if (test.actor && !Math::Zero(m_taserProps.m_stunDuration))
	{
		float duration = m_taserProps.m_stunDuration;
		g_messageDispatcher.SendMessageToActor("MunitionStun", CMessageDispatcher::FloatToData(duration), m_owner, test.actor->GetHandle());
	}
}

