/////////////////////////////////////////////////////////////////////////////
// Projectile base for the game
/////////////////////////////////////////////////////////////////////////////
#include "TTLPCH.h"

#include "weapons/ttlprojectile.h"

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
TTLProjectileProperties::TTLProjectileProperties(
ProjectileCreator &creator, int index) :
ProjectileProperties(creator, index)
{
	m_ammoType[0] = '\0';
}

/////////////////////////////////////////////////////////////////////////////
// Register our context
/////////////////////////////////////////////////////////////////////////////
void TTLProjectileProperties::RegisterContext(
const char *context)
{
	// Call the parent
	ProjectileProperties::RegisterContext(context);

	g_console.CreateVar(context, "ammoType", m_ammoType, sizeof(m_ammoType) - 1);
}

/////////////////////////////////////////////////////////////////////////////
// After the load
/////////////////////////////////////////////////////////////////////////////
void TTLProjectileProperties::PostLoadSetup()
{
	ProjectileProperties::PostLoadSetup();

	if (m_ammoType[0] == '\0')
	{
		strncpy(m_ammoType, GetName(), sizeof(m_ammoType) - 1);
		m_ammoType[sizeof(m_ammoType) - 1] = '\0';
	}
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
TTLProjectile::TTLProjectile(
const TTLProjectileProperties &properties) :
Projectile(properties),
m_ttlProps(properties)
{
}
