/////////////////////////////////////////////////////////////////////////////
// Weapon animation constants
/////////////////////////////////////////////////////////////////////////////
#ifndef WEAPONANIM_H
#define WEAPONANIM_H

enum WeaponHold
{
	WEAPONHOLD_NONE = 0,
	WEAPONHOLD_PISTOL,
	WEAPONHOLD_LONG2HAND,
	WEAPONHOLD_DUALPISTOL,
	WEAPONHOLD_SHORT2HAND,
	WEAPONHOLD_LOBBED,
	WEAPONHOLD_MELEE_SWING,
	WEAPONHOLD_MELEE_STAB,
	WEAPONHOLD_MELEE_SPRAY,
	WEAPONHOLD_MELEE_TOUCH,
	WEAPONHOLD_SNIPER,
	WEAPONHOLD_SNIPERP,
	WEAPONHOLD_ROCKET,
	WEAPONHOLD_COUNT,
};

enum WeaponReload
{
	WEAPONRELOAD_NONE = 0,
	WEAPONRELOAD_GRIPCLIP,
	WEAPONRELOAD_REVOLVER,
	WEAPONRELOAD_DUALPISTOL,
	WEAPONRELOAD_SHOTGUN,
	WEAPONRELOAD_SUBCLIP,
	WEAPONRELOAD_RIFLECLIP,
	WEAPONRELOAD_RIFLEBOLT,
	WEAPONRELOAD_BULLPUP,
	WEAPONRELOAD_COUNT,
};

// What is the "class" of the weapon?
enum WeaponClass
{
	WEAPONCLASS_NONE,
	WEAPONCLASS_MELEE,
	WEAPONCLASS_FIREARM,
	WEAPONCLASS_LOBBED,

	WEAPONCLASSES
};

// Our weapon types
enum WeaponType
{
	WEAPONTYPE_NONE,
	WEAPONTYPE_MELEE,
	WEAPONTYPE_PISTOL,
	WEAPONTYPE_SHOTGUN,
	WEAPONTYPE_SUB,
	WEAPONTYPE_ASSAULT,
	WEAPONTYPE_SNIPER,
	WEAPONTYPE_LOBBED,
	WEAPONTYPE_LAUNCHER,

	WEAPONTYPES,
};

// Some weapon sub-types (this are specific to types)
enum WeaponSubType
{
	// No sub typing
	WEAPONSUBTYPE_NONE,

	// For melee
	WEAPONSUBTYPE_MELEE_STAB,
	WEAPONSUBTYPE_MELEE_SWING,
	WEAPONSUBTYPE_MELEE_SPRAY,
	WEAPONSUBTYPE_MELEE_TOUCH,
	WEAPONSUBTYPE_MELEE_PROP,
	WEAPONSUBTYPE_MELEE_PROPSMOKE,

	// For pistols
	WEAPONSUBTYPE_PISTOL,
	WEAPONSUBTYPE_PISTOL_DUAL,

	// For grenades
	WEAPONSUBTYPE_LOBBED_FUSEEXPLODE,
	WEAPONSUBTYPE_LOBBED_CONTACTEXPLODE,
	WEAPONSUBTYPE_LOBBED_FLASHBANG,
	WEAPONSUBTYPE_LOBBED_SMOKE,
	WEAPONSUBTYPE_LOBBED_TEARGAS
};

#endif
