#pragma warning( disable : 4996 ) // Allow non _s func's

// TEXTURE MANIPULATION

#ifndef TEXVIEW_H
#define TEXVIEW_H

#include <Windows.h>
#include <stdio.h>
#include "dblreader.h"

#define TEX_NORMAL	0x1C // Normal non-palettized
#define TEX_NP5BPP	0x02 // 5bpp for colors 1b for alpha non-palettized
#define TEX_PALET	0x09 // 8bpp palettized
#define TEX_PAL4BPP 0x08 // 4bpp palettized

typedef struct tPixel_t {
	BYTE r, g, b, a;
} tPixel_s;

typedef struct tImagedata_t {
	char name[64]; // Texture name
	char* basepath; // The rest of the path
	tPixel_s* pixels; // Array of pixels that comprise this texture
	INT pixelcount; // Total number of pixels
	INT offset; // Offset to the texture within the datachunk
	BYTE mode; // Texture mode, see TEX_ definitions
	INT paloffs; // Offset to the palette, -1 if the texture is not palettized
	tPixel_t pal[256]; // The palette
	INT16 w, h; // Dimensions
} tImagedata_s;

typedef struct tTextureList_t {
	tImagedata_s* textures; // Pointer to the array of textures
	INT16 texturenum; // Total number of textures stored in this texturelist
} tTextureList_s;

// Load the texture datachunk into memory
tTextureList_t* LoadTexChunk( FILE* pChunk );

// Fetch the texture pixels
void GetTexture( FILE* pChunk, tImagedata_s* texture );

// Load a texture into a bitmap, for preview's
System::Drawing::Bitmap^ DrawTextureIntoABMP( FILE* pChunk, tTextureList_s* pTex, INT iTexNum );

// Exports a palettized texture along with its palette
void ExportPalettized( FILE* pal, FILE* pChunk, tTextureList_s* pTex, INT iTexNum, BYTE bNumForName );

// Replaces a specified texture, the input texture has to have the same w/h
BOOL ReplaceTexture( const char* chunkfname, System::String^ texturefile, tTextureList_s* pTex, INT iTexNum );

// Creates a texture chunk from given files & header
BOOL CreateTexChunk( tTextureList_s* textures, dbl_chunk_header_s* pChunkHeader, const char* output,
					INT chunkN, System::Windows::Forms::RichTextBox^ logbox, System::Windows::Forms::ProgressBar^ pbar );

#endif