/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.MultipartUrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class HttpTestSampleGui
extends AbstractSamplerGui
implements ItemListener {
    private static final long serialVersionUID = 240L;
    private static final Font FONT_VERY_SMALL = new Font("SansSerif", 0, 9);
    private static final Font FONT_SMALL = new Font("SansSerif", 0, 12);
    private MultipartUrlConfigGui urlConfigGui;
    private JCheckBox getImages;
    private JCheckBox concurrentDwn;
    private JTextField concurrentPool;
    private JCheckBox isMon;
    private JCheckBox useMD5;
    private JLabel labelEmbeddedRE = new JLabel(JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"));
    private JTextField embeddedRE;
    private JTextField sourceIpAddr;
    private JComboBox sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());
    private final boolean isAJP;

    public HttpTestSampleGui() {
        this.isAJP = false;
        this.init();
    }

    protected HttpTestSampleGui(boolean ajp) {
        this.isAJP = ajp;
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)element;
        this.urlConfigGui.configure(element);
        this.getImages.setSelected(samplerBase.isImageParser());
        this.concurrentDwn.setSelected(samplerBase.isConcurrentDwn());
        this.concurrentPool.setText(samplerBase.getConcurrentPool());
        this.isMon.setSelected(samplerBase.isMonitor());
        this.useMD5.setSelected(samplerBase.useMD5());
        this.embeddedRE.setText(samplerBase.getEmbeddedUrlRE());
        if (!this.isAJP) {
            this.sourceIpAddr.setText(samplerBase.getIpSource());
            this.sourceIpType.setSelectedIndex(samplerBase.getIpSourceType());
        }
    }

    public TestElement createTestElement() {
        HTTPSamplerProxy sampler = new HTTPSamplerProxy();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        this.urlConfigGui.modifyTestElement(sampler);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)sampler;
        samplerBase.setImageParser(this.getImages.isSelected());
        this.enableConcurrentDwn(this.getImages.isSelected());
        samplerBase.setConcurrentDwn(this.concurrentDwn.isSelected());
        samplerBase.setConcurrentPool(this.concurrentPool.getText());
        samplerBase.setMonitor(this.isMon.isSelected());
        samplerBase.setMD5(this.useMD5.isSelected());
        samplerBase.setEmbeddedUrlRE(this.embeddedRE.getText());
        if (!this.isAJP) {
            samplerBase.setIpSource(this.sourceIpAddr.getText());
            samplerBase.setIpSourceType(this.sourceIpType.getSelectedIndex());
        }
        this.configureTestElement(sampler);
    }

    public String getLabelResource() {
        return "web_testing_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.urlConfigGui = new MultipartUrlConfigGui(true, !this.isAJP);
        this.add(this.urlConfigGui, "Center");
        VerticalPanel bottomPane = new VerticalPanel();
        bottomPane.add(this.createEmbeddedRsrcPanel());
        HorizontalPanel optionAndSourcePane = new HorizontalPanel();
        optionAndSourcePane.add(this.createSourceAddrPanel());
        optionAndSourcePane.add(this.createOptionalTasksPanel());
        bottomPane.add((Component)optionAndSourcePane);
        this.add((Component)bottomPane, "South");
    }

    protected JPanel createEmbeddedRsrcPanel() {
        VerticalPanel embeddedRsrcPanel = new VerticalPanel();
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        HorizontalPanel checkBoxPanel = new HorizontalPanel();
        this.getImages = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.getImages.setFont(FONT_SMALL);
        this.getImages.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    HttpTestSampleGui.this.enableConcurrentDwn(true);
                } else {
                    HttpTestSampleGui.this.enableConcurrentDwn(false);
                }
            }
        });
        this.concurrentDwn = new JCheckBox(JMeterUtils.getResString((String)"web_testing_concurrent_download"));
        this.concurrentDwn.setFont(FONT_SMALL);
        this.concurrentDwn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (HttpTestSampleGui.this.getImages.isSelected() && e.getStateChange() == 1) {
                    HttpTestSampleGui.this.concurrentPool.setEnabled(true);
                } else {
                    HttpTestSampleGui.this.concurrentPool.setEnabled(false);
                }
            }
        });
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setFont(FONT_SMALL);
        this.concurrentPool.setMaximumSize(new Dimension(30, 20));
        checkBoxPanel.add(this.getImages);
        checkBoxPanel.add(this.concurrentDwn);
        checkBoxPanel.add(this.concurrentPool);
        embeddedRsrcPanel.add((Component)checkBoxPanel);
        this.labelEmbeddedRE.setFont(FONT_SMALL);
        checkBoxPanel.add(this.labelEmbeddedRE);
        this.embeddedRE = new JTextField(10);
        checkBoxPanel.add(this.embeddedRE);
        embeddedRsrcPanel.add((Component)checkBoxPanel);
        return embeddedRsrcPanel;
    }

    protected JPanel createOptionalTasksPanel() {
        HorizontalPanel checkBoxPanel = new HorizontalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        this.isMon = new JCheckBox(JMeterUtils.getResString((String)"monitor_is_title"));
        this.isMon.setFont(FONT_SMALL);
        this.useMD5 = new JCheckBox(JMeterUtils.getResString((String)"response_save_as_md5"));
        this.useMD5.setFont(FONT_SMALL);
        checkBoxPanel.add(this.isMon);
        checkBoxPanel.add(this.useMD5);
        return checkBoxPanel;
    }

    protected JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_source_ip")));
        if (!this.isAJP) {
            this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
            this.sourceIpType.setFont(FONT_VERY_SMALL);
            sourceAddrPanel.add(this.sourceIpType);
            this.sourceIpAddr = new JTextField();
            sourceAddrPanel.add(this.sourceIpAddr);
        }
        return sourceAddrPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void clearGui() {
        super.clearGui();
        this.getImages.setSelected(false);
        this.concurrentDwn.setSelected(false);
        this.concurrentPool.setText(String.valueOf(4));
        this.enableConcurrentDwn(false);
        this.isMon.setSelected(false);
        this.useMD5.setSelected(false);
        this.urlConfigGui.clear();
        this.embeddedRE.setText("");
        if (!this.isAJP) {
            this.sourceIpAddr.setText("");
            this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        }
    }

    private void enableConcurrentDwn(boolean enable) {
        if (enable) {
            this.concurrentDwn.setEnabled(true);
            this.labelEmbeddedRE.setEnabled(true);
            this.embeddedRE.setEnabled(true);
            if (this.concurrentDwn.isSelected()) {
                this.concurrentPool.setEnabled(true);
            }
        } else {
            this.concurrentDwn.setEnabled(false);
            this.concurrentPool.setEnabled(false);
            this.labelEmbeddedRE.setEnabled(false);
            this.embeddedRE.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.enableConcurrentDwn(true);
        } else {
            this.enableConcurrentDwn(false);
        }
    }
}

