/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.assertions.ResponseAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.TextAreaCellRenderer;
import org.apache.jmeter.gui.util.TextAreaTableCellEditor;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;

public class AssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private static final String COL_RESOURCE_NAME = "assertion_patterns_to_test";
    private JRadioButton responseStringButton;
    private JRadioButton responseAsDocumentButton;
    private JRadioButton urlButton;
    private JRadioButton responseMessageButton;
    private JRadioButton responseCodeButton;
    private JRadioButton responseHeadersButton;
    private JCheckBox assumeSuccess;
    private JRadioButton containsBox;
    private JRadioButton matchesBox;
    private JRadioButton equalsBox;
    private JRadioButton substringBox;
    private JCheckBox notBox;
    private JTable stringTable;
    private JButton deletePattern;
    private PowerTableModel tableModel;

    public AssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "assertion_title";
    }

    public TestElement createTestElement() {
        ResponseAssertion el = new ResponseAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.stringTable);
        this.configureTestElement(el);
        if (el instanceof ResponseAssertion) {
            String[] testStrings;
            ResponseAssertion ra = (ResponseAssertion)el;
            this.saveScopeSettings((AbstractScopedTestElement)ra);
            ra.clearTestStrings();
            for (String testString : testStrings = this.tableModel.getData().getColumn(COL_RESOURCE_NAME)) {
                ra.addTestString(testString);
            }
            if (this.responseStringButton.isSelected()) {
                ra.setTestFieldResponseData();
            } else if (this.responseAsDocumentButton.isSelected()) {
                ra.setTestFieldResponseDataAsDocument();
            } else if (this.responseCodeButton.isSelected()) {
                ra.setTestFieldResponseCode();
            } else if (this.responseMessageButton.isSelected()) {
                ra.setTestFieldResponseMessage();
            } else if (this.responseHeadersButton.isSelected()) {
                ra.setTestFieldResponseHeaders();
            } else {
                ra.setTestFieldURL();
            }
            ra.setAssumeSuccess(this.assumeSuccess.isSelected());
            if (this.containsBox.isSelected()) {
                ra.setToContainsType();
            } else if (this.equalsBox.isSelected()) {
                ra.setToEqualsType();
            } else if (this.substringBox.isSelected()) {
                ra.setToSubstringType();
            } else {
                ra.setToMatchType();
            }
            if (this.notBox.isSelected()) {
                ra.setToNotType();
            } else {
                ra.unsetNotType();
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        GuiUtils.stopTableEditing((JTable)this.stringTable);
        this.tableModel.clearData();
        this.responseStringButton.setSelected(true);
        this.urlButton.setSelected(false);
        this.responseCodeButton.setSelected(false);
        this.responseMessageButton.setSelected(false);
        this.responseHeadersButton.setSelected(false);
        this.assumeSuccess.setSelected(false);
        this.containsBox.setSelected(true);
        this.notBox.setSelected(false);
    }

    public void configure(TestElement el) {
        super.configure(el);
        ResponseAssertion model = (ResponseAssertion)el;
        this.showScopeSettings((AbstractScopedTestElement)model, true);
        if (model.isContainsType()) {
            this.containsBox.setSelected(true);
        } else if (model.isEqualsType()) {
            this.equalsBox.setSelected(true);
        } else if (model.isSubstringType()) {
            this.substringBox.setSelected(true);
        } else {
            this.matchesBox.setSelected(true);
        }
        this.notBox.setSelected(model.isNotType());
        if (model.isTestFieldResponseData()) {
            this.responseStringButton.setSelected(true);
        } else if (model.isTestFieldResponseDataAsDocument()) {
            this.responseAsDocumentButton.setSelected(true);
        } else if (model.isTestFieldResponseCode()) {
            this.responseCodeButton.setSelected(true);
        } else if (model.isTestFieldResponseMessage()) {
            this.responseMessageButton.setSelected(true);
        } else if (model.isTestFieldResponseHeaders()) {
            this.responseHeadersButton.setSelected(true);
        } else {
            this.urlButton.setSelected(true);
        }
        this.assumeSuccess.setSelected(model.getAssumeSuccess());
        this.tableModel.clearData();
        PropertyIterator tests = model.getTestStrings().iterator();
        while (tests.hasNext()) {
            this.tableModel.addRow(new Object[]{tests.next().getStringValue()});
        }
        if (model.getTestStrings().size() == 0) {
            this.deletePattern.setEnabled(false);
        } else {
            this.deletePattern.setEnabled(true);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        this.setBorder(this.makeBorder());
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true));
        box.add(this.createFieldPanel());
        box.add(this.createTypePanel());
        this.add(box, "North");
        this.add(this.createStringPanel(), "Center");
    }

    private JPanel createFieldPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_resp_field")));
        this.responseStringButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_text_resp"));
        this.responseAsDocumentButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_text_document"));
        this.urlButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_url_samp"));
        this.responseCodeButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_code_resp"));
        this.responseMessageButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_message_resp"));
        this.responseHeadersButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_headers"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.responseStringButton);
        group.add(this.responseAsDocumentButton);
        group.add(this.urlButton);
        group.add(this.responseCodeButton);
        group.add(this.responseMessageButton);
        group.add(this.responseHeadersButton);
        panel.add(this.responseStringButton);
        panel.add(this.responseAsDocumentButton);
        panel.add(this.urlButton);
        panel.add(this.responseCodeButton);
        panel.add(this.responseMessageButton);
        panel.add(this.responseHeadersButton);
        this.responseStringButton.setSelected(true);
        this.assumeSuccess = new JCheckBox(JMeterUtils.getResString((String)"assertion_assume_success"));
        panel.add(this.assumeSuccess);
        return panel;
    }

    private JPanel createTypePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_pattern_match_rules")));
        ButtonGroup group = new ButtonGroup();
        this.containsBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_contains"));
        group.add(this.containsBox);
        this.containsBox.setSelected(true);
        panel.add(this.containsBox);
        this.matchesBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_matches"));
        group.add(this.matchesBox);
        panel.add(this.matchesBox);
        this.equalsBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_equals"));
        group.add(this.equalsBox);
        panel.add(this.equalsBox);
        this.substringBox = new JRadioButton(JMeterUtils.getResString((String)"assertion_substring"));
        group.add(this.substringBox);
        panel.add(this.substringBox);
        this.notBox = new JCheckBox(JMeterUtils.getResString((String)"assertion_not"));
        panel.add(this.notBox);
        return panel;
    }

    private JPanel createStringPanel() {
        this.tableModel = new PowerTableModel(new String[]{COL_RESOURCE_NAME}, new Class[]{String.class});
        this.stringTable = new JTable((TableModel)this.tableModel);
        this.stringTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        TextAreaCellRenderer renderer = new TextAreaCellRenderer();
        this.stringTable.setRowHeight(renderer.getPreferredHeight());
        this.stringTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this.stringTable.setDefaultEditor(String.class, (TableCellEditor)new TextAreaTableCellEditor());
        this.stringTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)COL_RESOURCE_NAME)));
        panel.add((Component)new JScrollPane(this.stringTable), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JPanel createButtonPanel() {
        JButton addPattern = new JButton(JMeterUtils.getResString((String)"add"));
        addPattern.addActionListener(new AddPatternListener());
        this.deletePattern = new JButton(JMeterUtils.getResString((String)"delete"));
        this.deletePattern.addActionListener(new ClearPatternsListener());
        this.deletePattern.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(addPattern);
        buttonPanel.add(this.deletePattern);
        return buttonPanel;
    }

    private class AddPatternListener
    implements ActionListener {
        private AddPatternListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AssertionGui.this.tableModel.addNewRow();
            AssertionGui.this.deletePattern.setEnabled(true);
            AssertionGui.this.tableModel.fireTableDataChanged();
        }
    }

    private class ClearPatternsListener
    implements ActionListener {
        private ClearPatternsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = AssertionGui.this.stringTable.getSelectedRow();
            if (index > -1) {
                AssertionGui.this.stringTable.getCellEditor(index, AssertionGui.this.stringTable.getSelectedColumn()).cancelCellEditing();
                AssertionGui.this.tableModel.removeRow(index);
                AssertionGui.this.tableModel.fireTableDataChanged();
            }
            if (AssertionGui.this.stringTable.getModel().getRowCount() == 0) {
                AssertionGui.this.deletePattern.setEnabled(false);
            }
        }
    }
}

