/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.extractor.Extractor;
import org.apache.jmeter.extractor.HtmlExtractor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;

public class RenderAsCssJQuery
implements ResultRenderer,
ActionListener {
    private static final String CSSJQUEY_TESTER_COMMAND = "cssjquery_tester";
    private JPanel cssJqueryPane;
    private JTextArea cssJqueryDataField;
    private JLabeledTextField cssJqueryField;
    private JTextArea cssJqueryResultField;
    private JLabeledTextField attributeField;
    private JTabbedPane rightSide;
    private JLabeledChoice cssJqueryLabeledChoice;
    private SampleResult sampleResult = null;

    @Override
    public void clearData() {
        this.cssJqueryDataField.setText("");
        this.cssJqueryResultField.setText("");
    }

    @Override
    public void init() {
        this.cssJqueryPane = this.createCssJqueryPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.sampleResult != null && CSSJQUEY_TESTER_COMMAND.equals(command)) {
            String response = ViewResultsFullVisualizer.getResponseAsString(this.sampleResult);
            this.executeAndShowCssJqueryTester(response);
        }
    }

    private void executeAndShowCssJqueryTester(String textToParse) {
        if (textToParse != null && textToParse.length() > 0 && this.cssJqueryField.getText().length() > 0) {
            this.cssJqueryResultField.setText(this.process(textToParse));
            this.cssJqueryResultField.setCaretPosition(0);
        }
    }

    private String process(String textToParse) {
        ArrayList<String> result = new ArrayList<String>();
        Extractor extractor = HtmlExtractor.getExtractorImpl(this.cssJqueryLabeledChoice.getText());
        int nbFound = extractor.extract(this.cssJqueryField.getText(), this.attributeField.getText(), -1, textToParse, result, 0, null);
        StringBuilder sb = new StringBuilder();
        sb.append("Match count: ").append(nbFound).append("\n");
        for (int j = 0; j < nbFound; ++j) {
            String mr = (String)result.get(j);
            sb.append("Match[").append(j + 1).append("]=").append(mr).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        this.clearData();
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.cssJqueryDataField.setText(response);
        this.cssJqueryDataField.setCaretPosition(0);
    }

    @Override
    public void setupTabPane() {
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"cssjquery_tester_title")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"cssjquery_tester_title"), this.cssJqueryPane);
        }
        this.clearData();
    }

    private JPanel createCssJqueryPanel() {
        this.cssJqueryDataField = new JTextArea();
        this.cssJqueryDataField.setEditable(false);
        this.cssJqueryDataField.setLineWrap(true);
        this.cssJqueryDataField.setWrapStyleWord(true);
        JScrollPane cssJqueryDataPane = GuiUtils.makeScrollPane((Component)this.cssJqueryDataField);
        cssJqueryDataPane.setMinimumSize(new Dimension(0, 200));
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        JSplitPane mainSplit = new JSplitPane(0, cssJqueryDataPane, this.createCssJqueryTasksPanel());
        mainSplit.setDividerLocation(300);
        pane.add((Component)mainSplit, "Center");
        return pane;
    }

    private static String[] getImplementations() {
        return new String[]{"JSOUP", "JODD", ""};
    }

    private JPanel createCssJqueryTasksPanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel cssJqueryActionPanel = new JPanel();
        cssJqueryActionPanel.setLayout(g);
        EmptyBorder margin = new EmptyBorder(5, 5, 0, 5);
        cssJqueryActionPanel.setBorder(margin);
        this.cssJqueryField = new JLabeledTextField(JMeterUtils.getResString((String)"cssjquery_tester_field"));
        this.cssJqueryField.setPreferredSize(new Dimension(300, 30));
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        cssJqueryActionPanel.add((Component)this.cssJqueryField, c);
        this.cssJqueryLabeledChoice = new JLabeledChoice(JMeterUtils.getResString((String)"cssjquery_impl"), RenderAsCssJQuery.getImplementations());
        this.cssJqueryLabeledChoice.setPreferredSize(new Dimension(300, 30));
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        cssJqueryActionPanel.add((Component)this.cssJqueryLabeledChoice, c);
        this.attributeField = new JLabeledTextField(JMeterUtils.getResString((String)"cssjquery_attribute"));
        this.attributeField.setPreferredSize(new Dimension(300, 30));
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        cssJqueryActionPanel.add((Component)this.attributeField, c);
        JButton cssJqueryTester = new JButton(JMeterUtils.getResString((String)"cssjquery_tester_button_test"));
        cssJqueryTester.setPreferredSize(new Dimension(100, 30));
        cssJqueryTester.setActionCommand(CSSJQUEY_TESTER_COMMAND);
        cssJqueryTester.addActionListener(this);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        cssJqueryActionPanel.add((Component)cssJqueryTester, c);
        this.cssJqueryResultField = new JTextArea();
        this.cssJqueryResultField.setEditable(false);
        this.cssJqueryResultField.setLineWrap(true);
        this.cssJqueryResultField.setWrapStyleWord(true);
        JPanel cssJqueryTasksPanel = new JPanel(new BorderLayout(0, 5));
        cssJqueryTasksPanel.add((Component)cssJqueryActionPanel, "North");
        cssJqueryTasksPanel.add((Component)GuiUtils.makeScrollPane((Component)this.cssJqueryResultField), "Center");
        return cssJqueryTasksPanel;
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public synchronized void setSamplerResult(Object userObject) {
        if (userObject instanceof SampleResult) {
            this.sampleResult = (SampleResult)userObject;
        }
    }

    @Override
    public void setLastSelectedTab(int index) {
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"cssjquery_tester_title");
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        this.clearData();
        this.cssJqueryDataField.setText(JMeterUtils.getResString((String)"cssjquery_render_no_text"));
    }

    @Override
    public void setBackgroundColor(Color backGround) {
    }
}

