/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.Document;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RenderAsDocument
extends SamplerResultTab
implements ResultRenderer {
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    public void renderResult(SampleResult sampleResult) {
        try {
            this.showDocumentResponse(sampleResult);
        }
        catch (Exception e) {
            this.results.setText(e.toString());
            log.error("Error:", (Throwable)e);
        }
    }

    private void showDocumentResponse(SampleResult sampleResult) {
        String response = Document.getTextFromDocument((byte[])sampleResult.getResponseData());
        this.results.setContentType("text/plain");
        this.results.setText(response);
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"view_results_render_document");
    }
}

