/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.CachingStatCalculator;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.Spline3;

public class SplineModel
implements Clearable {
    public static final int DEFAULT_NUMBER_OF_NODES = 10;
    public static final int DEFAULT_REFRESH_PERIOD = 1;
    protected final boolean SHOW_INCOMING_SAMPLES = true;
    protected int numberOfNodes = 10;
    protected int refreshPeriod = 1;
    private Spline3 dataCurve = null;
    final CachingStatCalculator samples = new CachingStatCalculator("Spline");
    private GraphListener listener;
    private String name;

    public synchronized void setListener(GraphListener vis) {
        this.listener = vis;
    }

    public synchronized void setName(String newName) {
        this.name = newName;
    }

    public boolean isEditable() {
        return true;
    }

    public synchronized Spline3 getDataCurve() {
        return this.dataCurve;
    }

    public long getMinimum() {
        return this.samples.getMin().longValue();
    }

    public long getMaximum() {
        return this.samples.getMax().longValue();
    }

    public long getAverage() {
        return (long)this.samples.getMean();
    }

    public long getCurrent() {
        return this.samples.getCurrentSample().getData();
    }

    public long getSample(int i) {
        return this.samples.getSample(i).getData();
    }

    public long getNumberOfCollectedSamples() {
        return this.samples.getCount();
    }

    public synchronized String getName() {
        return this.name;
    }

    public void uncompile() {
        this.clearData();
    }

    public synchronized void clearData() {
        this.samples.clear();
        this.dataCurve = null;
        if (this.listener != null) {
            this.listener.updateGui();
        }
    }

    public synchronized void add(SampleResult sampleResult) {
        this.samples.addSample(sampleResult);
        long n = this.samples.getCount();
        if (n % (long)(this.numberOfNodes * this.refreshPeriod) == 0L) {
            float[] floatNode = new float[this.numberOfNodes];
            long loadFactor = n / (long)this.numberOfNodes;
            for (int i = 0; i < this.numberOfNodes; ++i) {
                int j = 0;
                while ((long)j < loadFactor) {
                    int n2 = i;
                    floatNode[n2] = floatNode[n2] + (float)this.samples.getSample((int)((long)i * loadFactor + (long)j)).getData();
                    ++j;
                }
                floatNode[i] = floatNode[i] / (float)loadFactor;
            }
            this.dataCurve = new Spline3(floatNode);
            if (this.listener != null) {
                this.listener.updateGui();
            }
        }
    }
}

