/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.monitor.util;

import org.apache.jmeter.monitor.model.Connector;
import org.apache.jmeter.monitor.model.Status;

public class Stats {
    public static final int DEAD = 0;
    public static final int ACTIVE = 2;
    public static final int WARNING = 1;
    public static final int HEALTHY = 3;
    public static final int DEFAULT_MEMORY_FACTOR = 50;
    public static final int DEFAULT_THREAD_FACTOR = 50;
    public static final double HEALTHY_PER = 0.0;
    public static final double ACTIVE_PER = 0.25;
    public static final double WARNING_PER = 0.67;

    public static int calculateLoad(Status stat) {
        if (stat != null) {
            long totMem = stat.getJvm().getMemory().getTotal();
            long freeMem = stat.getJvm().getMemory().getFree();
            long usedMem = totMem - freeMem;
            double memdiv = (double)usedMem / (double)totMem;
            double memWeight = 50.0 * memdiv;
            double threadWeight = 0.0;
            if (stat.getConnector().size() > 0) {
                Connector cntr = Stats.fetchConnector(stat);
                int maxThread = cntr.getThreadInfo().getMaxThreads();
                int curThread = cntr.getThreadInfo().getCurrentThreadsBusy();
                double thdiv = (double)curThread / (double)maxThread;
                threadWeight = 50.0 * thdiv;
            }
            return (int)(memWeight + threadWeight);
        }
        return 0;
    }

    public static int calculateStatus(Status stat) {
        if (stat != null && stat.getConnector().size() > 0) {
            Connector cntr = Stats.fetchConnector(stat);
            int max = cntr.getThreadInfo().getMaxThreads();
            int current = cntr.getThreadInfo().getCurrentThreadsBusy();
            double per = (double)current / (double)max;
            if (per > 0.67) {
                return 1;
            }
            if (per >= 0.25 && per <= 0.67) {
                return 2;
            }
            if (per < 0.25 && per >= 0.0) {
                return 3;
            }
            return 0;
        }
        return 0;
    }

    public static int calculateMemoryLoad(Status stat) {
        double load = 0.0;
        if (stat != null) {
            double total = stat.getJvm().getMemory().getTotal();
            double free = stat.getJvm().getMemory().getFree();
            double used = total - free;
            load = used / total;
        }
        return (int)(load * 100.0);
    }

    public static int calculateThreadLoad(Status stat) {
        int load = 0;
        if (stat != null && stat.getConnector().size() > 0) {
            Connector cntr = Stats.fetchConnector(stat);
            double max = cntr.getThreadInfo().getMaxThreads();
            double current = cntr.getThreadInfo().getCurrentThreadsBusy();
            load = (int)(current / max * 100.0);
        }
        return load;
    }

    private static Connector fetchConnector(Status stat) {
        Connector cntr = null;
        String connectorPrefix = stat.getConnectorPrefix();
        if (connectorPrefix != null && connectorPrefix.length() > 0) {
            for (int i = 0; i < stat.getConnector().size(); ++i) {
                cntr = stat.getConnector().get(i);
                if (!cntr.getName().startsWith(connectorPrefix)) continue;
                return cntr;
            }
        }
        cntr = stat.getConnector().get(0);
        return cntr;
    }
}

