/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.IfController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class IfControllerPanel
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JTextField theCondition;
    private JCheckBox useExpression;
    private JCheckBox evaluateAll;
    private boolean displayName = true;

    public IfControllerPanel() {
        this(true);
    }

    public IfControllerPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof IfController) {
            IfController ifController = (IfController)element;
            this.theCondition.setText(ifController.getCondition());
            this.evaluateAll.setSelected(ifController.isEvaluateAll());
            this.useExpression.setSelected(ifController.isUseExpression());
        }
    }

    @Override
    public TestElement createTestElement() {
        IfController controller = new IfController();
        this.modifyTestElement(controller);
        return controller;
    }

    @Override
    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof IfController) {
            IfController ifController = (IfController)controller;
            ifController.setCondition(this.theCondition.getText());
            ifController.setEvaluateAll(this.evaluateAll.isSelected());
            ifController.setUseExpression(this.useExpression.isSelected());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.theCondition.setText("");
        this.evaluateAll.setSelected(false);
    }

    @Override
    public String getLabelResource() {
        return "if_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createConditionPanel(), "North");
            this.add((Component)mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createConditionPanel(), "North");
        }
    }

    private JPanel createConditionPanel() {
        JPanel conditionPanel = new JPanel(new BorderLayout(5, 0));
        JLabel conditionLabel = new JLabel(JMeterUtils.getResString("if_controller_label"));
        conditionPanel.add((Component)conditionLabel, "West");
        this.theCondition = new JTextField("");
        conditionLabel.setLabelFor(this.theCondition);
        conditionPanel.add((Component)this.theCondition, "Center");
        conditionPanel.add(Box.createHorizontalStrut(conditionLabel.getPreferredSize().width + this.theCondition.getPreferredSize().width), "North");
        JPanel optionPanel = new JPanel();
        this.useExpression = new JCheckBox(JMeterUtils.getResString("if_controller_expression"));
        optionPanel.add(this.useExpression);
        this.evaluateAll = new JCheckBox(JMeterUtils.getResString("if_controller_evaluate_all"));
        optionPanel.add(this.evaluateAll);
        conditionPanel.add((Component)optionPanel, "South");
        return conditionPanel;
    }
}

