/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action.template;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.template.Template;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TemplateManager {
    private static final String TEMPLATE_FILES = JMeterUtils.getPropDefault("template.files", "/bin/templates/templates.xml");
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final TemplateManager SINGLETON = new TemplateManager();
    private final Map<String, Template> allTemplates;
    private final XStream xstream = this.initXStream();

    public static final TemplateManager getInstance() {
        return SINGLETON;
    }

    private TemplateManager() {
        this.allTemplates = this.readTemplates();
    }

    private XStream initXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.alias("template", Template.class);
        xstream.alias("templates", Templates.class);
        xstream.useAttributeFor(Template.class, "isTestPlan");
        xstream.addImplicitMap(Templates.class, "templates", Template.class, "name");
        return xstream;
    }

    public void addTemplate(Template template) {
        this.allTemplates.put(template.getName(), template);
    }

    public TemplateManager reset() {
        this.allTemplates.clear();
        this.allTemplates.putAll(this.readTemplates());
        return this;
    }

    public String[] getTemplateNames() {
        return this.allTemplates.keySet().toArray(new String[this.allTemplates.size()]);
    }

    private Map<String, Template> readTemplates() {
        String[] templateFiles;
        LinkedHashMap<String, Template> temps = new LinkedHashMap<String, Template>();
        for (String templateFile : templateFiles = TEMPLATE_FILES.split(",")) {
            if (StringUtils.isEmpty((CharSequence)templateFile)) continue;
            File f = new File(JMeterUtils.getJMeterHome(), templateFile);
            try {
                if (f.exists() && f.canRead()) {
                    log.info("Reading templates from:" + f.getAbsolutePath());
                    File parent = f.getParentFile();
                    LinkedHashMap templates = ((Templates)this.xstream.fromXML(f)).templates;
                    for (Template t : templates.values()) {
                        if (t.getFileName().startsWith("/")) continue;
                        t.setParent(parent);
                    }
                    temps.putAll(templates);
                    continue;
                }
                log.warn("Ignoring template file:'" + f.getAbsolutePath() + "' as it does not exist or is not readable");
            }
            catch (Exception ex) {
                log.warn("Ignoring template file:'" + f.getAbsolutePath() + "', an error occured parsing the file", (Throwable)ex);
            }
        }
        return temps;
    }

    public Template getTemplateByName(String selectedTemplate) {
        return this.allTemplates.get(selectedTemplate);
    }

    private static class Templates {
        private final LinkedHashMap<String, Template> templates = new LinkedHashMap();

        private Templates() {
        }
    }
}

