/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.control.gui.WorkBenchGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;

public class JMeterTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 240L;

    public JMeterTreeModel(TestElement tp, TestElement wb) {
        super(new JMeterTreeNode(wb, null));
        this.initTree(tp, wb);
    }

    public JMeterTreeModel() {
        this(new TestPlanGui().createTestElement(), new WorkBenchGui().createTestElement());
    }

    @Deprecated
    public JMeterTreeModel(Object o) {
        this(new TestPlan(), new WorkBench());
    }

    public List<JMeterTreeNode> getNodesOfType(Class<?> type) {
        LinkedList<JMeterTreeNode> nodeList = new LinkedList<JMeterTreeNode>();
        this.traverseAndFind(type, (JMeterTreeNode)this.getRoot(), nodeList);
        return nodeList;
    }

    public JMeterTreeNode getNodeOf(TestElement userObject) {
        return this.traverseAndFind(userObject, (JMeterTreeNode)this.getRoot());
    }

    public HashTree addSubTree(HashTree subTree, JMeterTreeNode current) throws IllegalUserActionException {
        for (TestElement item : subTree.list()) {
            if (item instanceof TestPlan) {
                TestPlan tp = (TestPlan)item;
                current = (JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0);
                TestPlan userObject = (TestPlan)current.getUserObject();
                userObject.addTestElement(item);
                userObject.setName(item.getName());
                userObject.setFunctionalMode(tp.isFunctionalMode());
                userObject.setSerialized(tp.isSerialized());
                this.addSubTree(subTree.getTree((Object)item), current);
                continue;
            }
            if (item instanceof WorkBench) {
                current = (JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(1);
                TestElement testElement = (TestElement)current.getUserObject();
                testElement.addTestElement(item);
                testElement.setName(item.getName());
                this.addSubTree(subTree.getTree((Object)item), current);
                continue;
            }
            this.addSubTree(subTree.getTree((Object)item), this.addComponent(item, current));
        }
        return this.getCurrentSubTree(current);
    }

    public JMeterTreeNode addComponent(TestElement component, JMeterTreeNode node) throws IllegalUserActionException {
        if (node.getUserObject() instanceof AbstractConfigGui) {
            throw new IllegalUserActionException("This node cannot hold sub-elements");
        }
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (guiPackage != null) {
            guiPackage.updateCurrentNode();
            JMeterGUIComponent guicomp = guiPackage.getGui(component);
            guicomp.configure(component);
            guicomp.modifyTestElement(component);
            guiPackage.getCurrentGui();
        }
        JMeterTreeNode newNode = new JMeterTreeNode(component, this);
        try {
            newNode.setEnabled(component.isEnabled());
        }
        catch (Exception e) {
            newNode.setEnabled(true);
        }
        this.insertNodeInto(newNode, node, node.getChildCount());
        return newNode;
    }

    public void removeNodeFromParent(JMeterTreeNode node) {
        if (!(node.getUserObject() instanceof TestPlan) && !(node.getUserObject() instanceof WorkBench)) {
            super.removeNodeFromParent(node);
        }
    }

    private void traverseAndFind(Class<?> type, JMeterTreeNode node, List<JMeterTreeNode> nodeList) {
        if (type.isInstance(node.getUserObject())) {
            nodeList.add(node);
        }
        Enumeration<JMeterTreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = enumNode.nextElement();
            this.traverseAndFind(type, child, nodeList);
        }
    }

    private JMeterTreeNode traverseAndFind(TestElement userObject, JMeterTreeNode node) {
        if (userObject == node.getUserObject()) {
            return node;
        }
        Enumeration<JMeterTreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = enumNode.nextElement();
            JMeterTreeNode result = this.traverseAndFind(userObject, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HashTree getCurrentSubTree(JMeterTreeNode node) {
        ListedHashTree hashTree = new ListedHashTree((Object)node);
        Enumeration<JMeterTreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            JMeterTreeNode child = enumNode.nextElement();
            hashTree.add((Object)node, this.getCurrentSubTree(child));
        }
        return hashTree;
    }

    public HashTree getTestPlan() {
        return this.getCurrentSubTree((JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0));
    }

    public HashTree getWorkBench() {
        return this.getCurrentSubTree((JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(1));
    }

    public void clearTestPlan() {
        TestElement tp = new TestPlanGui().createTestElement();
        this.clearTestPlan(tp);
    }

    public void clearTestPlan(TestElement testPlan) {
        int children = this.getChildCount(this.getRoot());
        while (children > 0) {
            JMeterTreeNode child = (JMeterTreeNode)this.getChild(this.getRoot(), 0);
            super.removeNodeFromParent(child);
            children = this.getChildCount(this.getRoot());
        }
        this.initTree(testPlan, new WorkBenchGui().createTestElement());
    }

    private void initTree(TestElement tp, TestElement wb) {
        this.insertNodeInto(new JMeterTreeNode(tp, this), (JMeterTreeNode)this.getRoot(), 0);
        this.insertNodeInto(new JMeterTreeNode(wb, this), (JMeterTreeNode)this.getRoot(), 1);
        this.nodeStructureChanged((JMeterTreeNode)this.getRoot());
    }
}

