/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.apache.jorphan.collections.Data;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PowerTableModel
extends DefaultTableModel {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 233L;
    private Data model = new Data();
    private Class<?>[] columnClasses;

    public PowerTableModel(String[] headers, Class<?>[] classes) {
        if (headers.length != classes.length) {
            throw new IllegalArgumentException("Header and column array sizes differ");
        }
        this.model.setHeaders(headers);
        this.columnClasses = classes;
    }

    public PowerTableModel() {
    }

    public void setRowValues(int row, Object[] values) {
        if (values.length != this.model.getHeaderCount()) {
            throw new IllegalArgumentException("Incorrect number of data items");
        }
        this.model.setCurrentPos(row);
        for (int i = 0; i < values.length; ++i) {
            this.model.addColumnValue(this.model.getHeaders()[i], values[i]);
        }
    }

    public Data getData() {
        return this.model;
    }

    public void addNewColumn(String colName, Class<?> colClass) {
        this.model.addHeader(colName);
        Class[] newClasses = new Class[this.columnClasses.length + 1];
        System.arraycopy(this.columnClasses, 0, newClasses, 0, this.columnClasses.length);
        newClasses[newClasses.length - 1] = colClass;
        this.columnClasses = newClasses;
        Object defaultValue = this.createDefaultValue(this.columnClasses.length - 1);
        this.model.setColumnData(colName, defaultValue);
        this.fireTableStructureChanged();
    }

    @Override
    public void removeRow(int row) {
        log.debug("remove row: " + row);
        if (this.model.size() > row) {
            log.debug("Calling remove row on Data");
            this.model.removeRow(row);
        }
    }

    public void removeColumn(int col) {
        this.model.removeColumn(col);
        this.fireTableStructureChanged();
    }

    public void setColumnData(int col, List<?> data) {
        this.model.setColumnData(col, data);
    }

    public List<?> getColumnData(String colName) {
        return this.model.getColumnAsObjectArray(colName);
    }

    public void clearData() {
        String[] headers = this.model.getHeaders();
        this.model = new Data();
        this.model.setHeaders(headers);
        this.fireTableDataChanged();
    }

    @Override
    public void addRow(Object[] data) {
        if (data.length != this.model.getHeaderCount()) {
            throw new IllegalArgumentException("Incorrect number of data items");
        }
        this.model.setCurrentPos(this.model.size());
        for (int i = 0; i < data.length; ++i) {
            this.model.addColumnValue(this.model.getHeaders()[i], data[i]);
        }
    }

    public void addNewRow() {
        this.addRow(this.createDefaultRow());
    }

    private Object[] createDefaultRow() {
        Object[] rowData = new Object[this.getColumnCount()];
        for (int i = 0; i < rowData.length; ++i) {
            rowData[i] = this.createDefaultValue(i);
        }
        return rowData;
    }

    public Object[] getRowData(int row) {
        Object[] rowData = new Object[this.getColumnCount()];
        for (int i = 0; i < rowData.length; ++i) {
            rowData[i] = this.model.getColumnValue(i, row);
        }
        return rowData;
    }

    private Object createDefaultValue(int i) {
        Class<?> colClass = this.getColumnClass(i);
        try {
            return colClass.newInstance();
        }
        catch (Exception e) {
            try {
                Constructor<?> constr = colClass.getConstructor(String.class);
                return constr.newInstance("");
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Integer.TYPE);
                return constr.newInstance(0);
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Long.TYPE);
                return constr.newInstance(0L);
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Boolean.TYPE);
                return constr.newInstance(Boolean.FALSE);
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Float.TYPE);
                return constr.newInstance(Float.valueOf(0.0f));
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Double.TYPE);
                return constr.newInstance(0.0);
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Character.TYPE);
                return constr.newInstance(Character.valueOf(' '));
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Byte.TYPE);
                return constr.newInstance((byte)-128);
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            try {
                Constructor<?> constr = colClass.getConstructor(Short.TYPE);
                return constr.newInstance((short)Short.MIN_VALUE);
            }
            catch (NoSuchMethodException err) {
            }
            catch (InstantiationException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {
                // empty catch block
            }
            return "";
        }
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getHeaders().length;
    }

    @Override
    public String getColumnName(int column) {
        return this.model.getHeaders()[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.columnClasses[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.model.getColumnValue(column, row);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row < this.model.size()) {
            this.model.setCurrentPos(row);
            this.model.addColumnValue(this.model.getHeaders()[column], value);
        }
    }
}

