/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class TestPlan
extends AbstractTestElement
implements Serializable,
TestStateListener {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String FUNCTIONAL_MODE = "TestPlan.functional_mode";
    private static final String USER_DEFINED_VARIABLES = "TestPlan.user_defined_variables";
    private static final String SERIALIZE_THREADGROUPS = "TestPlan.serialize_threadgroups";
    private static final String CLASSPATHS = "TestPlan.user_define_classpath";
    private static final String TEARDOWN_ON_SHUTDOWN = "TestPlan.tearDown_on_shutdown";
    private static final String CLASSPATH_SEPARATOR = ",";
    private static final String BASEDIR = "basedir";
    private transient List<AbstractThreadGroup> threadGroups = new LinkedList<AbstractThreadGroup>();
    private static volatile boolean functionalMode = false;

    public TestPlan() {
    }

    public TestPlan(String name) {
        this.setName(name);
    }

    private Object readResolve() {
        this.threadGroups = new LinkedList<AbstractThreadGroup>();
        return this;
    }

    public void prepareForPreCompile() {
        this.getVariables().setRunningVersion(true);
    }

    public boolean isFunctionalMode() {
        return this.getPropertyAsBoolean(FUNCTIONAL_MODE);
    }

    public void setUserDefinedVariables(Arguments vars) {
        this.setProperty(new TestElementProperty(USER_DEFINED_VARIABLES, vars));
    }

    public JMeterProperty getUserDefinedVariablesAsProperty() {
        return this.getProperty(USER_DEFINED_VARIABLES);
    }

    public String getBasedir() {
        return this.getPropertyAsString(BASEDIR);
    }

    public void setBasedir(String b) {
        this.setProperty(BASEDIR, b);
    }

    public Arguments getArguments() {
        return this.getVariables();
    }

    public Map<String, String> getUserDefinedVariables() {
        Arguments args = this.getVariables();
        return args.getArgumentsAsMap();
    }

    private Arguments getVariables() {
        Arguments args = (Arguments)this.getProperty(USER_DEFINED_VARIABLES).getObjectValue();
        if (args == null) {
            args = new Arguments();
            this.setUserDefinedVariables(args);
        }
        return args;
    }

    public void setFunctionalMode(boolean funcMode) {
        this.setProperty(new BooleanProperty(FUNCTIONAL_MODE, funcMode));
        functionalMode = funcMode;
    }

    public static boolean getFunctionalMode() {
        return functionalMode;
    }

    public void setSerialized(boolean serializeTGs) {
        this.setProperty(new BooleanProperty(SERIALIZE_THREADGROUPS, serializeTGs));
    }

    public void setTearDownOnShutdown(boolean tearDown) {
        this.setProperty(TEARDOWN_ON_SHUTDOWN, tearDown, false);
    }

    public boolean isTearDownOnShutdown() {
        return this.getPropertyAsBoolean(TEARDOWN_ON_SHUTDOWN, false);
    }

    public void setTestPlanClasspath(String text) {
        this.setProperty(CLASSPATHS, text);
    }

    public void setTestPlanClasspathArray(String[] text) {
        StringBuilder cat = new StringBuilder();
        for (int idx = 0; idx < text.length; ++idx) {
            if (idx > 0) {
                cat.append(CLASSPATH_SEPARATOR);
            }
            cat.append(text[idx]);
        }
        this.setTestPlanClasspath(cat.toString());
    }

    public String[] getTestPlanClasspathArray() {
        return JOrphanUtils.split((String)this.getTestPlanClasspath(), (String)CLASSPATH_SEPARATOR);
    }

    public String getTestPlanClasspath() {
        return this.getPropertyAsString(CLASSPATHS);
    }

    public boolean isSerialized() {
        return this.getPropertyAsBoolean(SERIALIZE_THREADGROUPS);
    }

    public void addParameter(String name, String value) {
        this.getVariables().addArgument(name, value);
    }

    @Override
    public void addTestElement(TestElement tg) {
        super.addTestElement(tg);
        if (tg instanceof AbstractThreadGroup && !this.isRunningVersion()) {
            this.addThreadGroup((AbstractThreadGroup)tg);
        }
    }

    public void addThreadGroup(AbstractThreadGroup group) {
        this.threadGroups.add(group);
    }

    @Override
    public void testEnded() {
        try {
            FileServer.getFileServer().closeFiles();
        }
        catch (IOException e) {
            log.error("Problem closing files at end of test", (Throwable)e);
        }
    }

    @Override
    public void testEnded(String host) {
        this.testEnded();
    }

    @Override
    public void testStarted() {
        if (this.getBasedir() != null && this.getBasedir().length() > 0) {
            try {
                FileServer.getFileServer().setBasedir(FileServer.getFileServer().getBaseDir() + this.getBasedir());
            }
            catch (IllegalStateException e) {
                log.error("Failed to set file server base dir with " + this.getBasedir(), (Throwable)e);
            }
        }
        String[] paths = this.getTestPlanClasspathArray();
        for (int idx = 0; idx < paths.length; ++idx) {
            NewDriver.addURL((String)paths[idx]);
            log.info("add " + paths[idx] + " to classpath");
        }
    }

    @Override
    public void testStarted(String host) {
        this.testStarted();
    }
}

