/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public final class NameUpdater {
    private static final Properties nameMap;
    private static final Logger log;
    private static final String NAME_UPDATER_PROPERTIES = "META-INF/resources/org.apache.jmeter.nameupdater.properties";

    public static String getCurrentName(String className) {
        if (nameMap.containsKey(className)) {
            String newName = nameMap.getProperty(className);
            log.info("Upgrading class " + className + " to " + newName);
            return newName;
        }
        return className;
    }

    public static String getCurrentTestName(String testClassName, String guiClassName) {
        String key = testClassName + "|" + guiClassName;
        if (nameMap.containsKey(key)) {
            String newName = nameMap.getProperty(key);
            log.info("Upgrading " + key + " to " + newName);
            return newName;
        }
        return NameUpdater.getCurrentName(testClassName);
    }

    public static String getCurrentName(String propertyName, String className) {
        String key = className + "/" + propertyName;
        if (nameMap.containsKey(key)) {
            String newName = nameMap.getProperty(key);
            log.info("Upgrading property " + propertyName + " to " + newName);
            return newName;
        }
        return propertyName;
    }

    public static String getCurrentName(String value, String propertyName, String className) {
        String key = className + "." + propertyName + "/" + value;
        if (nameMap.containsKey(key)) {
            String newValue = nameMap.getProperty(key);
            log.info("Upgrading value " + value + " to " + newValue);
            return newValue;
        }
        return value;
    }

    private NameUpdater() {
    }

    public static boolean isMapped(String key) {
        return nameMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        log = LoggingManager.getLoggerForClass();
        nameMap = new Properties();
        FileInputStream fis = null;
        File f = new File(JMeterUtils.getJMeterHome(), JMeterUtils.getPropDefault("upgrade_properties", "/bin/upgrade.properties"));
        try {
            fis = new FileInputStream(f);
            nameMap.load(fis);
        }
        catch (FileNotFoundException e) {
            log.error("Could not find upgrade file: ", (Throwable)e);
            JOrphanUtils.closeQuietly((Closeable)fis);
        }
        catch (IOException e2) {
            log.error("Error processing upgrade file: " + f.getPath(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    JOrphanUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            JOrphanUtils.closeQuietly((Closeable)fis);
        }
        JOrphanUtils.closeQuietly((Closeable)fis);
        Enumeration<URL> enu = null;
        try {
            enu = JMeterUtils.class.getClassLoader().getResources(NAME_UPDATER_PROPERTIES);
        }
        catch (IOException e) {
            log.error("Error in finding additional nameupdater.properties files: ", (Throwable)e);
        }
        if (enu != null) {
            while (enu.hasMoreElements()) {
                URL ressourceUrl = enu.nextElement();
                log.info("Processing " + ressourceUrl.toString());
                Properties prop = new Properties();
                InputStream is = null;
                try {
                    is = ressourceUrl.openStream();
                    prop.load(is);
                }
                catch (IOException e) {
                    log.error("Error processing upgrade file: " + ressourceUrl.getPath(), (Throwable)e);
                }
                finally {
                    JOrphanUtils.closeQuietly((Closeable)is);
                }
                Enumeration<?> propertyNames = prop.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String key = (String)propertyNames.nextElement();
                    if (!nameMap.contains(key)) {
                        nameMap.put(key, prop.get(key));
                        log.info("Added additional nameMap entry: " + key);
                        continue;
                    }
                    log.warn("Additional nameMap entry: '" + key + "' rejected as already defined.");
                }
            }
        }
    }
}

