/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler.protocol;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.protocol.smtp.sampler.protocol.LocalTrustStoreSSLSocketFactory;
import org.apache.jmeter.protocol.smtp.sampler.protocol.SynchronousTransportListener;
import org.apache.jmeter.protocol.smtp.sampler.protocol.TrustAllSSLSocketFactory;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SendMailCommand {
    private static final Logger logger = LoggingManager.getLoggerForClass();
    private static final String TRUST_ALL_SOCKET_FACTORY = TrustAllSSLSocketFactory.class.getName();
    private boolean useSSL = false;
    private boolean useStartTLS = false;
    private boolean trustAllCerts = false;
    private boolean enforceStartTLS = false;
    private boolean sendEmlMessage = false;
    private boolean enableDebug;
    private String smtpServer;
    private String smtpPort;
    private String sender;
    private List<InternetAddress> replyTo;
    private String emlMessage;
    private List<InternetAddress> receiverTo;
    private List<InternetAddress> receiverCC;
    private List<InternetAddress> receiverBCC;
    private CollectionProperty headerFields;
    private String subject = "";
    private boolean useAuthentication = false;
    private String username;
    private String password;
    private boolean useLocalTrustStore;
    private String trustStoreToUse;
    private List<File> attachments;
    private String mailBody;
    private boolean synchronousMode;
    private Session session;
    private StringBuilder serverResponse = new StringBuilder();
    private boolean plainBody;

    public SendMailCommand() {
        this.headerFields = new CollectionProperty();
        this.attachments = new ArrayList<File>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message prepareMessage() throws MessagingException, IOException {
        InternetAddress[] to;
        MimeMessage message;
        block25: {
            MimeMultipart multipart;
            block26: {
                block27: {
                    block24: {
                        Properties props = new Properties();
                        String protocol = this.getProtocol();
                        props.setProperty("mail." + protocol + ".host", this.smtpServer);
                        props.setProperty("mail." + protocol + ".port", this.getPort());
                        props.setProperty("mail." + protocol + ".auth", Boolean.toString(this.useAuthentication));
                        if (this.enableDebug) {
                            props.setProperty("mail.debug", "true");
                        }
                        if (this.useStartTLS) {
                            props.setProperty("mail.smtp.starttls.enable", "true");
                            if (this.enforceStartTLS) {
                                props.setProperty("mail.smtp.starttls.require", "true");
                            }
                        }
                        if (this.trustAllCerts) {
                            if (this.useSSL) {
                                props.setProperty("mail.smtps.ssl.socketFactory.class", TRUST_ALL_SOCKET_FACTORY);
                                props.setProperty("mail.smtps.ssl.socketFactory.fallback", "false");
                            } else if (this.useStartTLS) {
                                props.setProperty("mail.smtp.ssl.socketFactory.class", TRUST_ALL_SOCKET_FACTORY);
                                props.setProperty("mail.smtp.ssl.socketFactory.fallback", "false");
                            }
                        } else if (this.useLocalTrustStore) {
                            File truststore = new File(this.trustStoreToUse);
                            logger.info("load local truststore - try to load truststore from: " + truststore.getAbsolutePath());
                            if (!truststore.exists()) {
                                logger.info("load local truststore -Failed to load truststore from: " + truststore.getAbsolutePath());
                                truststore = new File(FileServer.getFileServer().getBaseDir(), this.trustStoreToUse);
                                logger.info("load local truststore -Attempting to read truststore from:  " + truststore.getAbsolutePath());
                                if (!truststore.exists()) {
                                    logger.info("load local truststore -Failed to load truststore from: " + truststore.getAbsolutePath() + ". Local truststore not available, aborting execution.");
                                    throw new IOException("Local truststore file not found. Also not available under : " + truststore.getAbsolutePath());
                                }
                            }
                            if (this.useSSL) {
                                props.put("mail.smtps.ssl.socketFactory", new LocalTrustStoreSSLSocketFactory(truststore));
                                props.put("mail.smtps.ssl.socketFactory.fallback", "false");
                            } else if (this.useStartTLS) {
                                props.put("mail.smtp.ssl.socketFactory", new LocalTrustStoreSSLSocketFactory(truststore));
                                props.put("mail.smtp.ssl.socketFactory.fallback", "false");
                            }
                        }
                        this.session = Session.getInstance((Properties)props, null);
                        if (!this.sendEmlMessage) break block24;
                        message = new MimeMessage(this.session, (InputStream)new BufferedInputStream(new FileInputStream(this.emlMessage)));
                        break block25;
                    }
                    message = new MimeMessage(this.session);
                    multipart = new MimeMultipart();
                    int attachmentCount = this.attachments.size();
                    if (!this.plainBody || attachmentCount != 0 && (this.mailBody.length() != 0 || attachmentCount != 1)) break block26;
                    if (attachmentCount != 1) break block27;
                    File first = this.attachments.get(0);
                    BufferedInputStream is = null;
                    try {
                        is = new BufferedInputStream(new FileInputStream(first));
                        message.setText(IOUtils.toString((InputStream)is));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    break block25;
                }
                message.setText(this.mailBody);
                break block25;
            }
            MimeBodyPart body = new MimeBodyPart();
            body.setText(this.mailBody);
            multipart.addBodyPart((BodyPart)body);
            for (File f : this.attachments) {
                MimeBodyPart attach = new MimeBodyPart();
                attach.setFileName(f.getName());
                attach.setDataHandler(new DataHandler((DataSource)new FileDataSource(f.getAbsolutePath())));
                multipart.addBodyPart((BodyPart)attach);
            }
            message.setContent((Multipart)multipart);
        }
        if (null != this.sender) {
            message.setFrom((Address)new InternetAddress(this.sender));
        }
        if (null != this.replyTo) {
            to = new InternetAddress[this.replyTo.size()];
            message.setReplyTo((Address[])this.replyTo.toArray(to));
        }
        if (null != this.subject) {
            message.setSubject(this.subject);
        }
        if (this.receiverTo != null) {
            to = new InternetAddress[this.receiverTo.size()];
            this.receiverTo.toArray(to);
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        if (this.receiverCC != null) {
            InternetAddress[] cc = new InternetAddress[this.receiverCC.size()];
            this.receiverCC.toArray(cc);
            message.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if (this.receiverBCC != null) {
            InternetAddress[] bcc = new InternetAddress[this.receiverBCC.size()];
            this.receiverBCC.toArray(bcc);
            message.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        for (int i = 0; i < this.headerFields.size(); ++i) {
            Argument argument = (Argument)((TestElementProperty)this.headerFields.get(i)).getObjectValue();
            message.setHeader(argument.getName(), argument.getValue());
        }
        message.saveChanges();
        return message;
    }

    public void execute(Message message) throws MessagingException, IOException, InterruptedException {
        Transport tr = this.session.getTransport(this.getProtocol());
        SynchronousTransportListener listener = null;
        if (this.synchronousMode) {
            listener = new SynchronousTransportListener();
            tr.addTransportListener((TransportListener)listener);
        }
        if (this.useAuthentication) {
            tr.connect(this.smtpServer, this.username, this.password);
        } else {
            tr.connect();
        }
        tr.sendMessage(message, message.getAllRecipients());
        if (listener != null) {
            listener.attend();
        }
        tr.close();
        logger.debug("transport closed");
        logger.debug("message sent");
    }

    public void execute() throws Exception {
        this.execute(this.prepareMessage());
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReceiverTo(List<InternetAddress> receiverTo) {
        this.receiverTo = receiverTo;
    }

    public List<InternetAddress> getReceiverCC() {
        return this.receiverCC;
    }

    public void setReceiverCC(List<InternetAddress> receiverCC) {
        this.receiverCC = receiverCC;
    }

    public List<InternetAddress> getReceiverBCC() {
        return this.receiverBCC;
    }

    public void setReceiverBCC(List<InternetAddress> receiverBCC) {
        this.receiverBCC = receiverBCC;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public boolean isTrustAllCerts() {
        return this.trustAllCerts;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setEnforceStartTLS(boolean enforceStartTLS) {
        this.enforceStartTLS = enforceStartTLS;
    }

    public boolean isEnforceStartTLS() {
        return this.enforceStartTLS;
    }

    public CollectionProperty getHeaders() {
        return this.headerFields;
    }

    public void setHeaderFields(CollectionProperty headerFields) {
        this.headerFields = headerFields;
    }

    public void addHeader(String headerName, String headerValue) {
        if (this.headerFields == null) {
            this.headerFields = new CollectionProperty();
        }
        Argument argument = new Argument(headerName, headerValue);
        this.headerFields.addItem((Object)argument);
    }

    public void clearHeaders() {
        if (this.headerFields == null) {
            this.headerFields = new CollectionProperty();
        } else {
            this.headerFields.clear();
        }
    }

    public List<File> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<File> attachments) {
        this.attachments = attachments;
    }

    public void addAttachment(File attachment) {
        this.attachments.add(attachment);
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public boolean isSynchronousMode() {
        return this.synchronousMode;
    }

    public void setSynchronousMode(boolean synchronousMode) {
        this.synchronousMode = synchronousMode;
    }

    private String getProtocol() {
        return this.useSSL ? "smtps" : "smtp";
    }

    private String getPort() {
        String port = this.smtpPort.trim();
        if (port.length() > 0) {
            return port;
        }
        if (this.useSSL) {
            return "465";
        }
        if (this.useStartTLS) {
            return "587";
        }
        return "25";
    }

    public void setUseLocalTrustStore(boolean useLocalTrustStore) {
        this.useLocalTrustStore = useLocalTrustStore;
    }

    public void setTrustStoreToUse(String trustStoreToUse) {
        this.trustStoreToUse = trustStoreToUse;
    }

    public void setUseEmlMessage(boolean sendEmlMessage) {
        this.sendEmlMessage = sendEmlMessage;
    }

    public void setEmlMessage(String emlMessage) {
        this.emlMessage = emlMessage;
    }

    public void setMailBody(String body) {
        this.mailBody = body;
    }

    public void setPlainBody(boolean plainBody) {
        this.plainBody = plainBody;
    }

    public String getServerResponse() {
        return this.serverResponse.toString();
    }

    public void setEnableDebug(boolean selected) {
        this.enableDebug = selected;
    }

    public void setReplyTo(List<InternetAddress> replyTo) {
        this.replyTo = replyTo;
    }
}

